/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.output;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.main.option.display.type.argument.DisplayType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.ProgrammingLanguage;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context.ProgrammingLanguageContext;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.PlantUMLClassesDiagram;
import net.sourceforge.plantumldependency.common.utils.file.FileUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.execution.AbstractOptionExecution;
import net.sourceforge.plantumldependency.commoncli.option.execution.OptionExecution;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

public class PlantUMLDependencyOutputOptionExecution
extends AbstractOptionExecution {
    private static final long serialVersionUID = 2237748681247499173L;
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLDependencyOutputOptionExecution.class.getName());
    private File outputFile;
    private transient FileSet inputFileSet;
    private ProgrammingLanguage programmingLanguage;
    private Set<DisplayType> displayTypesOptions;
    private Pattern displayPackageNamePattern;
    private Pattern displayNamePattern;

    private static ProgrammingLanguageContext readDependenciesContextFromFiles(ProgrammingLanguage language, FileSet includeExcludeFiles, Set<DisplayType> displayTypesOpts, Pattern displayPackageNamePattern, Pattern displayNamePattern) {
        ProgrammingLanguageContext programmingLanguageContext = language.createNewContext(displayTypesOpts, displayPackageNamePattern, displayNamePattern);
        for (FileResource fileResource : includeExcludeFiles) {
            try {
                PlantUMLDependencyOutputOptionExecution.readDependencyFromFile(fileResource.getFile(), programmingLanguageContext, language);
            }
            catch (PlantUMLDependencyException e) {
                LOGGER.log(Level.SEVERE, LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-032] : Severe parsing errors have occurred while reading the source file \"{0}\", the file will be ignored", (Object)fileResource.getFile()));
                LOGGER.log(Level.INFO, e.getMessage(), e);
            }
        }
        programmingLanguageContext.removeAllPotentialJavaLangSeenDependencyAndChangePackageToJavaLang();
        return programmingLanguageContext;
    }

    private static GenericDependency readDependencyFromFile(File file, ProgrammingLanguageContext programmingLanguageContext, ProgrammingLanguage language) throws PlantUMLDependencyException {
        String sourceFileContent = FileUtils.readFileIntoString((File)file);
        return language.readDependencyFromFile(sourceFileContent, programmingLanguageContext);
    }

    public PlantUMLDependencyOutputOptionExecution(File file, ProgrammingLanguage language, FileSet includeExcludeFiles, Set<DisplayType> displayTypesOpts, Pattern displayPackageNamePatternOpt, Pattern displayNamePatternOpt, int optionPriority) {
        super(optionPriority);
        this.setOutputFile(file);
        this.setInputFileSet(includeExcludeFiles);
        this.setProgrammingLanguage(language);
        this.setDisplayTypesOptions(displayTypesOpts);
        this.setDisplayPackageNamePattern(displayPackageNamePatternOpt);
        this.setDisplayNamePattern(displayNamePatternOpt);
    }

    public OptionExecution deepClone() {
        PlantUMLDependencyOutputOptionExecution p = (PlantUMLDependencyOutputOptionExecution)super.deepClone();
        p.outputFile = new File(this.outputFile.getAbsolutePath());
        p.inputFileSet = (FileSet)this.inputFileSet.clone();
        p.displayTypesOptions = new TreeSet<DisplayType>(this.displayTypesOptions);
        p.displayPackageNamePattern = this.displayPackageNamePattern;
        p.displayNamePattern = this.displayNamePattern;
        return p;
    }

    public void execute() throws CommandLineException {
        ProgrammingLanguageContext programmingLanguageContext = PlantUMLDependencyOutputOptionExecution.readDependenciesContextFromFiles(this.getProgrammingLanguage(), this.getInputFileSet(), this.getDisplayTypesOptions(), this.getDisplayPackageNamePattern(), this.getDisplayNamePattern());
        PlantUMLClassesDiagram plantUMLDiagram = programmingLanguageContext.getPlantUMLClassesDiagram();
        FileUtils.writeIntoFile((String)plantUMLDiagram.getPlantUMLTextDescription(), (File)this.getOutputFile());
        LOGGER.log(Level.INFO, LogUtils.buildLogString((String)"[info-plantuml-dependency-cli-003] : Number of processed dependencies : \"{0}\"", (Object)programmingLanguageContext.getParsedDependencies().size()));
    }

    private Pattern getDisplayNamePattern() {
        return this.displayNamePattern;
    }

    private Pattern getDisplayPackageNamePattern() {
        return this.displayPackageNamePattern;
    }

    private Set<DisplayType> getDisplayTypesOptions() {
        return this.displayTypesOptions;
    }

    private FileSet getInputFileSet() {
        return this.inputFileSet;
    }

    private File getOutputFile() {
        return this.outputFile;
    }

    private ProgrammingLanguage getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    private void setDisplayNamePattern(Pattern value) {
        this.displayNamePattern = value;
    }

    private void setDisplayPackageNamePattern(Pattern value) {
        this.displayPackageNamePattern = value;
    }

    private void setDisplayTypesOptions(Set<DisplayType> value) {
        this.displayTypesOptions = value;
    }

    private void setInputFileSet(FileSet value) {
        this.inputFileSet = value;
    }

    private void setOutputFile(File value) {
        this.outputFile = value;
    }

    private void setProgrammingLanguage(ProgrammingLanguage value) {
        this.programmingLanguage = value;
    }
}

