/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.output;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.plantumldependency.cli.main.option.basedirectory.PlantUMLDependencyBaseDirectoryOption;
import net.sourceforge.plantumldependency.cli.main.option.display.name.PlantUMLDependencyDisplayNameOption;
import net.sourceforge.plantumldependency.cli.main.option.display.packagename.PlantUMLDependencyDisplayPackageNameOption;
import net.sourceforge.plantumldependency.cli.main.option.display.type.PlantUMLDependencyDisplayTypeOption;
import net.sourceforge.plantumldependency.cli.main.option.exclude.PlantUMLDependencyExcludeOption;
import net.sourceforge.plantumldependency.cli.main.option.include.PlantUMLDependencyIncludeOption;
import net.sourceforge.plantumldependency.cli.main.option.output.PlantUMLDependencyOutputOptionExecution;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.PlantUMLDependencyProgrammingLanguageOption;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.ProgrammingLanguage;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.commoncli.command.CommandLine;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.Option;
import net.sourceforge.plantumldependency.commoncli.option.argument.OptionArgument;
import net.sourceforge.plantumldependency.commoncli.option.argument.impl.file.ExistingOrNotFileOptionArgumentImpl;
import net.sourceforge.plantumldependency.commoncli.option.execution.ExecutableOption;
import net.sourceforge.plantumldependency.commoncli.option.execution.OptionExecution;
import net.sourceforge.plantumldependency.commoncli.option.impl.output.OutputOption;
import net.sourceforge.plantumldependency.commoncli.option.impl.verbose.VerboseLevelOption;
import net.sourceforge.plantumldependency.commoncli.option.status.OptionStatus;
import org.apache.tools.ant.types.FileSet;

public class PlantUMLDependencyOutputOption
extends OutputOption
implements ExecutableOption {
    private static final long serialVersionUID = -1629517125349614965L;
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLDependencyOutputOption.class.getName());
    private VerboseLevelOption verboseLevelOption;
    private PlantUMLDependencyProgrammingLanguageOption programmingLanguageOption;
    private PlantUMLDependencyIncludeOption includeOption;
    private PlantUMLDependencyExcludeOption excludeOption;
    private PlantUMLDependencyDisplayTypeOption displayTypeOption;
    private PlantUMLDependencyDisplayPackageNameOption displayPackageNameOption;
    private PlantUMLDependencyDisplayNameOption displayNameOption;
    private PlantUMLDependencyBaseDirectoryOption baseDirOption;
    private int priority;

    public PlantUMLDependencyOutputOption(VerboseLevelOption verboseLvlOpt, PlantUMLDependencyProgrammingLanguageOption programmingLanguageOpt, PlantUMLDependencyIncludeOption includeOpt, PlantUMLDependencyExcludeOption excludeOpt, PlantUMLDependencyDisplayTypeOption displayTypeOpt, PlantUMLDependencyDisplayPackageNameOption displayPackageNameOpt, PlantUMLDependencyDisplayNameOption displayNameOpt, PlantUMLDependencyBaseDirectoryOption baseDirOpt, int optionPriority) {
        super((OptionArgument)new ExistingOrNotFileOptionArgumentImpl(true), new StringBuilder("To specify the output file path where to generate the PlantUML description."), " ", OptionStatus.ACTIVE_OPTIONAL_OPTION_STATUS);
        this.setVerboseLevelOption(verboseLvlOpt);
        this.setProgrammingLanguageOption(programmingLanguageOpt);
        this.setIncludeOption(includeOpt);
        this.setExcludeOption(excludeOpt);
        this.setDisplayTypeOption(displayTypeOpt);
        this.setDisplayPackageNameOption(displayPackageNameOpt);
        this.setDisplayNameOption(displayNameOpt);
        this.setBaseDirOption(baseDirOpt);
        this.setPriority(optionPriority);
    }

    private PlantUMLDependencyBaseDirectoryOption getBaseDirOption() {
        return this.baseDirOption;
    }

    private PlantUMLDependencyDisplayNameOption getDisplayNameOption() {
        return this.displayNameOption;
    }

    private PlantUMLDependencyDisplayPackageNameOption getDisplayPackageNameOption() {
        return this.displayPackageNameOption;
    }

    private PlantUMLDependencyDisplayTypeOption getDisplayTypeOption() {
        return this.displayTypeOption;
    }

    private PlantUMLDependencyExcludeOption getExcludeOption() {
        return this.excludeOption;
    }

    private PlantUMLDependencyIncludeOption getIncludeOption() {
        return this.includeOption;
    }

    public int getPriority() {
        return this.priority;
    }

    private PlantUMLDependencyProgrammingLanguageOption getProgrammingLanguageOption() {
        return this.programmingLanguageOption;
    }

    private VerboseLevelOption getVerboseLevelOption() {
        return this.verboseLevelOption;
    }

    public OptionExecution parseCommandLine(CommandLine commandLine) throws CommandLineException {
        PlantUMLDependencyOutputOptionExecution optionExecution = null;
        Level verboseLevel = (Level)this.getVerboseLevelOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
        LogUtils.setLevelOfAllLoggersAndHandlers((Level)verboseLevel);
        if (commandLine.isOptionSpecified((Option)this)) {
            File outputFile = (File)this.findAndParseArgumentOrGetDefaultArgument(commandLine);
            String excludes = this.getExcludeOption().findAndParseArgumentAsStringOrGetDefaultArgument(commandLine);
            FileSet includesExcludes = (FileSet)this.getIncludeOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            includesExcludes.setExcludes(excludes);
            File baseDirectory = (File)this.getBaseDirOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            includesExcludes.setDir(baseDirectory);
            Set displayTypesOptions = (Set)this.getDisplayTypeOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            Pattern displayPackageNamePatternOpt = (Pattern)this.getDisplayPackageNameOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            Pattern displayNamePatternOpt = (Pattern)this.getDisplayNameOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            ProgrammingLanguage programmingLanguage = (ProgrammingLanguage)this.getProgrammingLanguageOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            optionExecution = new PlantUMLDependencyOutputOptionExecution(outputFile, programmingLanguage, includesExcludes, displayTypesOptions, displayPackageNamePatternOpt, displayNamePatternOpt, this.getPriority());
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-commoncli-012] : Option \"{0}\" is not specified, it won't be executed", (Object)this.getAllNames()));
        }
        return optionExecution;
    }

    private void setBaseDirOption(PlantUMLDependencyBaseDirectoryOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-001] : The base directory option is null");
        this.baseDirOption = value;
    }

    private void setDisplayNameOption(PlantUMLDependencyDisplayNameOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-006] : The display name option is null");
        this.displayNameOption = value;
    }

    private void setDisplayPackageNameOption(PlantUMLDependencyDisplayPackageNameOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-007] : The display package name option is null");
        this.displayPackageNameOption = value;
    }

    private void setDisplayTypeOption(PlantUMLDependencyDisplayTypeOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-008] : The display type option is null");
        this.displayTypeOption = value;
    }

    private void setExcludeOption(PlantUMLDependencyExcludeOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-009] : The exclude option is null");
        this.excludeOption = value;
    }

    private void setIncludeOption(PlantUMLDependencyIncludeOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-011] : The include option is null");
        this.includeOption = value;
    }

    private void setPriority(int value) {
        this.priority = value;
    }

    private void setProgrammingLanguageOption(PlantUMLDependencyProgrammingLanguageOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-031] : The programming language option is null");
        this.programmingLanguageOption = value;
    }

    private void setVerboseLevelOption(VerboseLevelOption value) {
        ParameterCheckerUtils.checkNull((Object)value, (String)"[error-plantuml-dependency-commoncli-048] : The verbose option is null");
        this.verboseLevelOption = value;
    }
}

