/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.display.type.argument;

import java.util.Arrays;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sourceforge.plantumldependency.cli.main.option.display.type.argument.DisplayType;
import net.sourceforge.plantumldependency.common.utils.collection.CollectionUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.argument.AbstractOptionArgument;

public class PlantUMLDependencyDisplayTypeOptionArgument
extends AbstractOptionArgument<Set<DisplayType>> {
    private static final long serialVersionUID = 4078671176887334895L;
    private static final String MAIN_USAGE = "DISPLAY_TYPES_OPTIONS";
    private static final String USAGE_DESCRIPTION = "DISPLAY_TYPES_OPTIONS specifies display types options when generating the plantUML output file, it is a separated comma list with these possible values : " + CollectionUtils.collectionToString(Arrays.asList(DisplayType.values()), (String)",") + ". " + DisplayType.getAllDisplayTypesOptionsFullUsageDescriptions() + ".";

    public PlantUMLDependencyDisplayTypeOptionArgument() {
        super(true, new StringBuilder(USAGE_DESCRIPTION));
    }

    protected String getMainUsageDescription() {
        return MAIN_USAGE;
    }

    public Set<DisplayType> parseArgument(String argument) throws CommandLineException {
        TreeSet<DisplayType> displayTypesArguments = null;
        if (StringUtils.isNotEmpty((String)argument)) {
            displayTypesArguments = new TreeSet<DisplayType>();
            StringTokenizer tokenizer = new StringTokenizer(argument, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    DisplayType displayTypeArgument = DisplayType.valueOf(token.toUpperCase());
                    if (displayTypesArguments.contains((Object)displayTypeArgument)) {
                        throw new CommandLineException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-033] : The display type argument \"{0}\" is defined several times", (Object)((Object)displayTypeArgument)));
                    }
                    displayTypesArguments.add(DisplayType.valueOf(token.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-028] : Can't parse option argument \"{0}\", it isn't a valid display type argument", (String)argument), (Throwable)e);
                }
            }
        } else {
            throw new CommandLineException("[error-plantuml-dependency-commoncli-009] : Can't parse option argument, it is empty");
        }
        return displayTypesArguments;
    }
}

