/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.display.name.argument;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.argument.AbstractOptionArgument;

public class PlantUMLDependencyDisplayNameOptionArgument
extends AbstractOptionArgument<Pattern> {
    private static final String MAIN_USAGE = "DISPLAY_NAME_PATTERN";
    private static final String USAGE_DESCRIPTION = "DISPLAY_NAME_PATTERN specifies display name pattern when generating the plantUML output file, it is a regular expression following the Java pattern (see http://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html for description).";
    private static final long serialVersionUID = -8804026254773622257L;

    public PlantUMLDependencyDisplayNameOptionArgument() {
        super(true, new StringBuilder(USAGE_DESCRIPTION));
    }

    protected String getMainUsageDescription() {
        return MAIN_USAGE;
    }

    public Pattern parseArgument(String argument) throws CommandLineException {
        Pattern displayNameArgument = null;
        if (StringUtils.isNotEmpty((String)argument)) {
            try {
                displayNameArgument = Pattern.compile(argument);
            }
            catch (PatternSyntaxException e) {
                throw new CommandLineException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-000] : Can't parse option argument \"{0}\", it isn't a valid pattern", (String)argument), (Throwable)e);
            }
        } else {
            throw new CommandLineException("[error-plantuml-dependency-commoncli-009] : Can't parse option argument, it is empty");
        }
        return displayNameArgument;
    }
}

