/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.main.program.PlantUMLDependencyProgram;
import net.sourceforge.plantumldependency.common.utils.exception.ExceptionUtils;
import net.sourceforge.plantumldependency.common.utils.map.MapUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PlantUMLDependencyProgramTask
extends Task {
    private final Map<String, String> argsMap = new HashMap<String, String>();

    private static String[] createArgs(Map<String, String> argumentsMap) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (Map.Entry<String, String> argument : argumentsMap.entrySet()) {
            String argumentSynopsis = argument.getKey();
            String argumentValue = argument.getValue();
            argsList.add(argumentSynopsis);
            argsList.add(argumentValue);
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    public void execute() {
        try {
            String[] args = PlantUMLDependencyProgramTask.createArgs(this.getArgsMap());
            PlantUMLDependencyProgram.processProgramArguments(args);
        }
        catch (PlantUMLDependencyException e) {
            this.log(ExceptionUtils.getStackTraceAsString((Throwable)e));
            throw new BuildException((Throwable)e);
        }
    }

    private Map<String, String> getArgsMap() {
        return this.argsMap;
    }

    public String getBaseDir() {
        return this.getArgsMap().get("-b");
    }

    public String getDisplayName() {
        return this.getArgsMap().get("-dn");
    }

    public String getDisplayPackageName() {
        return this.getArgsMap().get("-dp");
    }

    public String getDisplayType() {
        return this.getArgsMap().get("-dt");
    }

    public String getExcludes() {
        return this.getArgsMap().get("-e");
    }

    public String getIncludes() {
        return this.getArgsMap().get("-i");
    }

    public String getOutput() {
        return this.getArgsMap().get("-o");
    }

    public String getProgrammingLanguage() {
        return this.getArgsMap().get("-l");
    }

    public String getVerboseLevel() {
        return this.getArgsMap().get("-v");
    }

    public void setBaseDir(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-b", (String)value);
    }

    public void setDisplayName(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-dn", (String)value);
    }

    public void setDisplayPackageName(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-dp", (String)value);
    }

    public void setDisplayType(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-dt", (String)value);
    }

    public void setExcludes(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-e", (String)value);
    }

    public void setIncludes(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-i", (String)value);
    }

    public void setOutput(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-o", (String)value);
    }

    public void setProgrammingLanguage(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-l", (String)value);
    }

    public void setVerboseLevel(String value) {
        MapUtils.putNonEmptyStringToMap(this.getArgsMap(), (String)"-v", (String)value);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [output=" + this.getOutput() + ", verboseLevel=" + this.getVerboseLevel() + ", programmingLanguage=" + this.getProgrammingLanguage() + ", includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ", displayType=" + this.getDisplayType() + ", baseDir=" + this.getBaseDir() + ", displayName=" + this.getDisplayName() + ", displayPackageName=" + this.getDisplayPackageName() + "]";
    }
}

