/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.generic.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.type.DependencyType;
import net.sourceforge.plantumldependency.cli.generic.type.impl.stubimpl.StubDependencyTypeImpl;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;

public class GenericDependencyImpl
implements GenericDependency {
    private static final long serialVersionUID = 4512036274880797908L;
    private static final transient Logger LOGGER = Logger.getLogger(GenericDependencyImpl.class.getName());
    private DependencyType dependencyType;

    public GenericDependencyImpl(DependencyType type) {
        ParameterCheckerUtils.checkNull((Object)type, (String)"[error-plantuml-dependency-cli-005] : The dependency type is null");
        this.dependencyType = type;
    }

    public GenericDependencyImpl(String dependencyName, String dependencyPackageName) {
        this(new StubDependencyTypeImpl(dependencyName, dependencyPackageName));
    }

    @Override
    public int compareTo(GenericDependency a) {
        int comparison = ComparableResult.AFTER.getResult();
        comparison = this == a ? ComparableResult.EQUAL.getResult() : this.getDependencyType().compareTo(a.getDependencyType());
        return comparison;
    }

    public GenericDependency deepClone() {
        GenericDependencyImpl g = null;
        try {
            g = (GenericDependencyImpl)super.clone();
            g.dependencyType = (DependencyType)this.getDependencyType().deepClone();
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return g;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericDependencyImpl other = (GenericDependencyImpl)obj;
        return !(this.dependencyType == null ? other.dependencyType != null : !this.dependencyType.equals(other.dependencyType));
    }

    @Override
    public DependencyType getDependencyType() {
        return this.dependencyType;
    }

    @Override
    public String getFullName() {
        return this.getDependencyType().getFullName();
    }

    @Override
    public String getName() {
        return this.getDependencyType().getName();
    }

    @Override
    public String getPackageName() {
        return this.getDependencyType().getPackageName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependencyType == null ? 0 : this.dependencyType.hashCode());
        return result;
    }

    @Override
    public void setDependencyType(DependencyType value) {
        this.dependencyType = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [dependencyType=" + this.dependencyType + "]";
    }
}

