/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.program;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.main.option.basedirectory.PlantUMLDependencyBaseDirectoryOption;
import net.sourceforge.plantumldependency.cli.main.option.display.PlantUMLDependencyDisplayOption;
import net.sourceforge.plantumldependency.cli.main.option.exclude.PlantUMLDependencyExcludeOption;
import net.sourceforge.plantumldependency.cli.main.option.include.PlantUMLDependencyIncludeOption;
import net.sourceforge.plantumldependency.cli.main.option.output.PlantUMLDependencyOutputOption;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.PlantUMLDependencyProgrammingLanguageOption;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.commoncli.command.CommandLine;
import net.sourceforge.plantumldependency.commoncli.command.impl.CommandLineImpl;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.Option;
import net.sourceforge.plantumldependency.commoncli.option.impl.about.AboutOption;
import net.sourceforge.plantumldependency.commoncli.option.impl.help.HelpOption;
import net.sourceforge.plantumldependency.commoncli.option.impl.verbose.VerboseLevelOption;
import net.sourceforge.plantumldependency.commoncli.option.impl.version.VersionOption;
import net.sourceforge.plantumldependency.commoncli.program.JavaProgram;
import net.sourceforge.plantumldependency.commoncli.program.execution.JavaProgramExecution;
import net.sourceforge.plantumldependency.commoncli.program.impl.JavaProgramImpl;
import net.sourceforge.plantumldependency.commoncli.program.version.ProgramVersion;
import net.sourceforge.plantumldependency.commoncli.utils.version.ProgramVersionUtils;

public final class PlantUMLDependencyProgram
extends JavaProgramImpl {
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLDependencyProgram.class.getName());
    private static final long serialVersionUID = 8055066636525797910L;
    private static final String MAVEN_BUILD_TIMESTAMP_PATTERN = "yyyyMMdd-HHmm";

    public static void main(String[] args) throws PlantUMLDependencyException {
        try {
            LogUtils.readLoggerConfigurationFromResourceFromClassClassLoader((String)"net/sourceforge/plantumldependency/cli/log/logging.properties", PlantUMLDependencyProgram.class);
            PlantUMLDependencyProgram.processProgramArguments(args);
        }
        catch (PlantUMLDependencyException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            throw new PlantUMLDependencyException("[error-plantuml-dependency-cli-027] : An error has occured while running PlantUML Dependency, please check the log for more information", e);
        }
    }

    public static void processProgramArguments(String[] args) throws PlantUMLDependencyException {
        long start = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "[info-plantuml-dependency-cli-002] : Starting PlantUML Dependency");
        LOGGER.log(Level.INFO, LogUtils.buildLogString((String)"[info-plantuml-dependency-cli-001] : PlantUML Dependency arguments : \"{0}\"", (String)Arrays.toString(args)));
        try {
            PlantUMLDependencyProgram plantumlDependencyProgram = new PlantUMLDependencyProgram();
            JavaProgramExecution plantumlDependencyProgramExecution = plantumlDependencyProgram.parseCommandLine((CommandLine)new CommandLineImpl(args));
            plantumlDependencyProgramExecution.execute();
        }
        catch (CommandLineException e) {
            throw new PlantUMLDependencyException("[error-plantuml-dependency-cli-027] : An error has occured while running PlantUML Dependency, please check the log for more information", e);
        }
        catch (ParseException e) {
            throw new PlantUMLDependencyException("[error-plantuml-dependency-cli-027] : An error has occured while running PlantUML Dependency, please check the log for more information", e);
        }
        catch (IOException e) {
            throw new PlantUMLDependencyException("[error-plantuml-dependency-cli-027] : An error has occured while running PlantUML Dependency, please check the log for more information", e);
        }
        LOGGER.log(Level.INFO, LogUtils.buildLogString((String)"[info-plantuml-dependency-cli-000] : Executed in \"{0}\" ms", (Object)(System.currentTimeMillis() - start)));
    }

    public PlantUMLDependencyProgram() throws MalformedURLException, CommandLineException, ParseException {
        this(ProgramVersionUtils.createProgramVersionFromString((String)"1.3.0", (String)"\\.", (String)"20140119-1526", (String)MAVEN_BUILD_TIMESTAMP_PATTERN));
    }

    private PlantUMLDependencyProgram(ProgramVersion programVersion) throws MalformedURLException, CommandLineException {
        super("PlantUML Dependency", new URL("http://plantuml-depend.sourceforge.net"), "plantuml-dependency-cli-" + programVersion.getFullVersionNumber() + ".jar", Arrays.asList("GPL v3, 29 June 2007 (http://www.gnu.org/licenses/gpl-3.0.txt)", "LGPL v3, 29 June 2007 (http://www.gnu.org/licenses/lgpl-3.0.txt)"), Arrays.asList("Benjamin Croizet (graffity2199@yahoo.fr)"), programVersion, new StringBuilder("reverse engineering java source files to generate PlantUML description"));
        VerboseLevelOption verboseLevelOption = new VerboseLevelOption();
        this.addOption((Option)verboseLevelOption);
        AboutOption aboutOption = new AboutOption((JavaProgram)this, 2);
        this.addOption((Option)aboutOption);
        HelpOption helpOption = new HelpOption((JavaProgram)this, 1);
        this.addOption((Option)helpOption);
        VersionOption versionOption = new VersionOption((JavaProgram)this, 3);
        this.addOption((Option)versionOption);
        PlantUMLDependencyDisplayOption displayOption = new PlantUMLDependencyDisplayOption();
        this.addOption((Option)displayOption);
        PlantUMLDependencyProgrammingLanguageOption programmingLanguageOption = new PlantUMLDependencyProgrammingLanguageOption();
        this.addOption((Option)programmingLanguageOption);
        PlantUMLDependencyIncludeOption includeOption = new PlantUMLDependencyIncludeOption(programmingLanguageOption);
        this.addOption((Option)includeOption);
        PlantUMLDependencyExcludeOption excludeOption = new PlantUMLDependencyExcludeOption();
        this.addOption((Option)excludeOption);
        PlantUMLDependencyBaseDirectoryOption baseDirectoryOption = new PlantUMLDependencyBaseDirectoryOption();
        this.addOption((Option)baseDirectoryOption);
        PlantUMLDependencyOutputOption outputOption = new PlantUMLDependencyOutputOption(verboseLevelOption, programmingLanguageOption, includeOption, excludeOption, displayOption, baseDirectoryOption, 4);
        this.addOption((Option)outputOption);
        String[] example1 = new String[]{helpOption.getName()};
        String[] example2 = new String[]{versionOption.getName(), verboseLevelOption.getName()};
        String[] example3 = new String[]{outputOption.getName(), "plantuml.txt", baseDirectoryOption.getName(), "\"C:\\Users\\PlantUML test\"", includeOption.getName(), "**/*Test.java"};
        String[] example4 = new String[]{outputOption.getName(), "/home/test/plantuml.txt", "-b", ".", includeOption.getName(), "**/*.java", excludeOption.getName(), "**/*Test*.java", displayOption.getName(), "implementations,interfaces,extensions,imports,static_imports", verboseLevelOption.getName()};
        this.addExampleCommandLine((CommandLine)new CommandLineImpl(example1));
        this.addExampleCommandLine((CommandLine)new CommandLineImpl(example2));
        this.addExampleCommandLine((CommandLine)new CommandLineImpl(example3));
        this.addExampleCommandLine((CommandLine)new CommandLineImpl(example4));
        this.addKnownBugOrLimitation("- As PlantUML Dependency reads source files imports, it will generate object - imports relation even if the imports are not used within the object (usually, this raises a warning within the IDE)");
        this.addKnownBugOrLimitation("- Be careful, in order to correctly parse source files, it is better to have source code which compiles without any errors");
        this.addKnownBugOrLimitation("- Generated annotations (if used) are only supported by PlantUML 7972 and above");
        this.addKnownBugOrLimitation("- Import instructions \"import package_name.*\" are ignored because the dependencies are not explicitly defined, use precise imports instead");
        this.addKnownBugOrLimitation("- Links between dependencies are found out by parsing \"import\" instructions, so PlantUML Dependency won't display dependencies which are called using their full names in the source code");
        this.addKnownBugOrLimitation("- PlantUML Dependency can be run by JRE 1.6+");
        this.addKnownBugOrLimitation("- PlantUML Dependency is fully compliant up to Java 1.6 source files (and may work with Java 1.7 source files)");
        this.addKnownBugOrLimitation("- The generated output file is better when PlantUML Dependency is launched with a JRE matching the parsed source files");
    }
}

