/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.main.option.display.argument.Display;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context.ProgrammingLanguageContext;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.PlantUMLClassesDiagram;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.element.PlantUMLClassesDiagramElement;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.impl.PlantUMLClassesDiagramImpl;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.PlantUMLClassesDiagramRelation;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;

public abstract class AbstractProgrammingLanguageContext
implements ProgrammingLanguageContext {
    private static final transient Logger LOGGER = Logger.getLogger(AbstractProgrammingLanguageContext.class.getName());
    private static final long serialVersionUID = -2181655116426569842L;
    private Set<Display> displayOptions;
    private Map<String, GenericDependency> parsedAndSeenDependenciesMap;
    private Map<String, GenericDependency> potentialJavaLangSeenDependenciesMap;
    private Map<String, GenericDependency> parsedDependenciesMap;

    protected AbstractProgrammingLanguageContext() {
        this(new TreeSet<GenericDependency>(), new TreeSet<Display>());
    }

    protected AbstractProgrammingLanguageContext(Set<Display> displayOpt) {
        this(new TreeSet<GenericDependency>(), displayOpt);
    }

    protected AbstractProgrammingLanguageContext(Set<GenericDependency> parsedAndSeenDependencies, Set<Display> displayOpt) {
        this(parsedAndSeenDependencies, parsedAndSeenDependencies, new TreeSet<GenericDependency>(), displayOpt);
    }

    protected AbstractProgrammingLanguageContext(Set<GenericDependency> parsedAndSeenDependencies, Set<GenericDependency> parsedDependencies, Set<GenericDependency> potentialJavaLangSeenDependencies, Set<Display> displayOpt) {
        TreeMap<String, GenericDependency> firstDependenciesMap = new TreeMap<String, GenericDependency>();
        for (GenericDependency genericDependency : parsedAndSeenDependencies) {
            firstDependenciesMap.put(genericDependency.getFullName(), genericDependency);
        }
        this.setParsedAndSeenDependenciesMap(firstDependenciesMap);
        TreeMap<String, GenericDependency> secondDependenciesMap = new TreeMap<String, GenericDependency>();
        for (GenericDependency genericDependency : parsedDependencies) {
            secondDependenciesMap.put(genericDependency.getFullName(), genericDependency);
        }
        this.setParsedDependenciesMap(secondDependenciesMap);
        TreeMap<String, GenericDependency> thirdDependenciesMap = new TreeMap<String, GenericDependency>();
        for (GenericDependency genericDependency : potentialJavaLangSeenDependencies) {
            thirdDependenciesMap.put(genericDependency.getFullName(), genericDependency);
        }
        this.setPotentialJavaLangSeenDependenciesMap(thirdDependenciesMap);
        this.setDisplayOptions(new TreeSet<Display>(displayOpt));
    }

    @Override
    public void addParsedAndSeenDependencies(GenericDependency dependency) {
        ParameterCheckerUtils.checkNull((Object)dependency, (String)"[error-plantuml-dependency-cli-003] : The dependency is null");
        this.getParsedDependenciesMap().put(dependency.getFullName(), dependency);
        this.getParsedAndSeenDependenciesMap().put(dependency.getFullName(), dependency);
    }

    @Override
    public void addPotentialJavaLangSeenDependencies(GenericDependency dependency) {
        ParameterCheckerUtils.checkNull((Object)dependency, (String)"[error-plantuml-dependency-cli-003] : The dependency is null");
        this.getParsedAndSeenDependenciesMap().put(dependency.getFullName(), dependency);
        this.getPotentialJavaLangSeenDependenciesMap().put(dependency.getFullName(), dependency);
    }

    @Override
    public void addSeenDependencies(GenericDependency dependency) {
        ParameterCheckerUtils.checkNull((Object)dependency, (String)"[error-plantuml-dependency-cli-003] : The dependency is null");
        this.getParsedAndSeenDependenciesMap().put(dependency.getFullName(), dependency);
    }

    @Override
    public int compareTo(ProgrammingLanguageContext o) {
        int anotherSize;
        int thisSize = this.getParsedDependencies().size();
        return thisSize < (anotherSize = o.getParsedDependencies().size()) ? ComparableResult.BEFORE.getResult() : (thisSize == anotherSize ? ComparableResult.EQUAL.getResult() : ComparableResult.AFTER.getResult());
    }

    public ProgrammingLanguageContext deepClone() {
        AbstractProgrammingLanguageContext a = null;
        try {
            a = (AbstractProgrammingLanguageContext)super.clone();
            a.parsedAndSeenDependenciesMap = new TreeMap<String, GenericDependency>();
            for (GenericDependency genericDependency : this.getParsedAndSeenDependencies()) {
                a.parsedAndSeenDependenciesMap.put(genericDependency.getFullName(), (GenericDependency)genericDependency.deepClone());
            }
            a.potentialJavaLangSeenDependenciesMap = new TreeMap<String, GenericDependency>(a.potentialJavaLangSeenDependenciesMap);
            a.parsedDependenciesMap = new TreeMap<String, GenericDependency>(a.parsedDependenciesMap);
            a.displayOptions = new TreeSet<Display>(this.getDisplayOptions());
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return a;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProgrammingLanguageContext other = (AbstractProgrammingLanguageContext)obj;
        if (this.displayOptions == null ? other.displayOptions != null : !this.displayOptions.equals(other.displayOptions)) {
            return false;
        }
        if (this.parsedAndSeenDependenciesMap == null ? other.parsedAndSeenDependenciesMap != null : !this.parsedAndSeenDependenciesMap.equals(other.parsedAndSeenDependenciesMap)) {
            return false;
        }
        if (this.parsedDependenciesMap == null ? other.parsedDependenciesMap != null : !this.parsedDependenciesMap.equals(other.parsedDependenciesMap)) {
            return false;
        }
        return !(this.potentialJavaLangSeenDependenciesMap == null ? other.potentialJavaLangSeenDependenciesMap != null : !this.potentialJavaLangSeenDependenciesMap.equals(other.potentialJavaLangSeenDependenciesMap));
    }

    private Collection<GenericDependency> getDisplayableParsedAndSeenDependencies(Set<Display> displayOpts) {
        TreeSet<GenericDependency> displayableParsedAndSeenDependencies = new TreeSet<GenericDependency>();
        for (GenericDependency dependency : this.getParsedAndSeenDependencies()) {
            if (!dependency.getDependencyType().isDisplayable(displayOpts)) continue;
            displayableParsedAndSeenDependencies.add(dependency);
        }
        return displayableParsedAndSeenDependencies;
    }

    private Set<Display> getDisplayOptions() {
        return this.displayOptions;
    }

    @Override
    public Collection<GenericDependency> getParsedAndSeenDependencies() {
        return this.getParsedAndSeenDependenciesMap().values();
    }

    private Map<String, GenericDependency> getParsedAndSeenDependenciesMap() {
        return this.parsedAndSeenDependenciesMap;
    }

    @Override
    public Collection<GenericDependency> getParsedDependencies() {
        return this.getParsedDependenciesMap().values();
    }

    private Map<String, GenericDependency> getParsedDependenciesMap() {
        return this.parsedDependenciesMap;
    }

    @Override
    public GenericDependency getParsedDependency(String fullName) {
        ParameterCheckerUtils.checkNull((Object)fullName, (String)"[error-plantuml-dependency-cli-002] : The dependency name is null");
        return this.getParsedDependenciesMap().get(fullName);
    }

    @Override
    public GenericDependency getParsedOrSeenDependency(String fullName) {
        ParameterCheckerUtils.checkNull((Object)fullName, (String)"[error-plantuml-dependency-cli-002] : The dependency name is null");
        return this.getParsedAndSeenDependenciesMap().get(fullName);
    }

    @Override
    public PlantUMLClassesDiagram getPlantUMLClassesDiagram() {
        TreeSet<PlantUMLClassesDiagramElement> plantUMLClassesDiagramElements = new TreeSet<PlantUMLClassesDiagramElement>();
        TreeSet<PlantUMLClassesDiagramRelation> plantUMLClassesDiagramRelations = new TreeSet<PlantUMLClassesDiagramRelation>();
        for (GenericDependency genericDependency : this.getDisplayableParsedAndSeenDependencies(this.getDisplayOptions())) {
            plantUMLClassesDiagramElements.add(genericDependency.getDependencyType().getPlantUMLClassesDiagramElement());
            plantUMLClassesDiagramRelations.addAll(genericDependency.getDependencyType().getPlantUMLClassesDiagramRelations(this.getDisplayOptions()));
        }
        return new PlantUMLClassesDiagramImpl(plantUMLClassesDiagramElements, plantUMLClassesDiagramRelations);
    }

    @Override
    public Collection<GenericDependency> getPotentialJavaLangSeenDependencies() {
        return this.getPotentialJavaLangSeenDependenciesMap().values();
    }

    private Map<String, GenericDependency> getPotentialJavaLangSeenDependenciesMap() {
        return this.potentialJavaLangSeenDependenciesMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayOptions == null ? 0 : this.displayOptions.hashCode());
        result = 31 * result + (this.parsedAndSeenDependenciesMap == null ? 0 : this.parsedAndSeenDependenciesMap.hashCode());
        result = 31 * result + (this.parsedDependenciesMap == null ? 0 : this.parsedDependenciesMap.hashCode());
        result = 31 * result + (this.potentialJavaLangSeenDependenciesMap == null ? 0 : this.potentialJavaLangSeenDependenciesMap.hashCode());
        return result;
    }

    @Override
    public boolean hasToDisplay(Display display) {
        return this.getDisplayOptions().contains((Object)display);
    }

    @Override
    public void removeAllPotentialJavaLangSeenDependencyAndChangePackageToJavaLang() {
        for (GenericDependency dependency : this.getPotentialJavaLangSeenDependencies()) {
            this.getParsedAndSeenDependenciesMap().remove(dependency.getFullName());
            dependency.getDependencyType().setFullName("java.lang", dependency.getName());
            this.addSeenDependencies(dependency);
        }
        this.getPotentialJavaLangSeenDependenciesMap().clear();
    }

    @Override
    public void removePotentialJavaLangSeenDependency(String fullName) {
        ParameterCheckerUtils.checkNull((Object)fullName, (String)"[error-plantuml-dependency-cli-002] : The dependency name is null");
        this.getPotentialJavaLangSeenDependenciesMap().remove(fullName);
    }

    private void setDisplayOptions(Set<Display> value) {
        this.displayOptions = value;
    }

    private void setParsedAndSeenDependenciesMap(Map<String, GenericDependency> value) {
        this.parsedAndSeenDependenciesMap = value;
    }

    private void setParsedDependenciesMap(Map<String, GenericDependency> value) {
        this.parsedDependenciesMap = value;
    }

    private void setPotentialJavaLangSeenDependenciesMap(Map<String, GenericDependency> value) {
        this.potentialJavaLangSeenDependenciesMap = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [displayOptions=" + this.displayOptions + ", parsedAndSeenDependenciesMap=" + this.parsedAndSeenDependenciesMap + ", potentialJavaLangSeenDependenciesMap=" + this.potentialJavaLangSeenDependenciesMap + ", parsedDependenciesMap=" + this.parsedDependenciesMap + "]";
    }
}

