/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.main.option.display.argument.Display;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.CppProgrammingLanguage;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.JavaProgrammingLanguage;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context.ProgrammingLanguageContext;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;

public abstract class ProgrammingLanguage
implements Comparable<ProgrammingLanguage>,
Serializable {
    private static final long serialVersionUID = -4593346488847506817L;
    private static final transient Logger LOGGER = Logger.getLogger(ProgrammingLanguage.class.getName());
    public static final ProgrammingLanguage JAVA = new JavaProgrammingLanguage("java");
    public static final ProgrammingLanguage CPP = new CppProgrammingLanguage("cpp");
    private static final Map<String, ProgrammingLanguage> PROGRAMMING_LANGUAGE_MAP = ProgrammingLanguage.createProgrammingLanguageMap();
    private String name;

    private static Map<String, ProgrammingLanguage> createProgrammingLanguageMap() {
        TreeMap<String, ProgrammingLanguage> programmingLanguageMap = new TreeMap<String, ProgrammingLanguage>();
        programmingLanguageMap.put(CPP.getName(), CPP);
        programmingLanguageMap.put(JAVA.getName(), JAVA);
        return Collections.unmodifiableMap(programmingLanguageMap);
    }

    public static Collection<ProgrammingLanguage> getProgrammingLanguageCollection() {
        return PROGRAMMING_LANGUAGE_MAP.values();
    }

    public static Set<String> getProgrammingLanguageNamesSet() {
        TreeSet<String> names = new TreeSet<String>();
        for (ProgrammingLanguage programmingLanguage : ProgrammingLanguage.getProgrammingLanguageCollection()) {
            names.add(programmingLanguage.getName());
        }
        return names;
    }

    public static ProgrammingLanguage valueOfIgnoringCase(String programmingLanguageName) {
        ParameterCheckerUtils.checkNullOrEmpty((String)programmingLanguageName, (String)"[error-plantuml-dependency-cli-028] : The programming language name is null");
        ProgrammingLanguage programmingLanguage = null;
        programmingLanguage = PROGRAMMING_LANGUAGE_MAP.get(programmingLanguageName.toLowerCase());
        if (programmingLanguage == null) {
            throw new IllegalArgumentException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-032] : The programming language \"{0}\" is unknown", (String)programmingLanguageName));
        }
        LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-013] : Programming language \"{0}\" has been found", (Object)programmingLanguage));
        return programmingLanguage;
    }

    protected ProgrammingLanguage(String programmingLanguageName) {
        this.setName(programmingLanguageName);
    }

    @Override
    public int compareTo(ProgrammingLanguage o) {
        if (this == o) {
            return ComparableResult.EQUAL.getResult();
        }
        return this.getName().compareTo(o.getName());
    }

    public abstract ProgrammingLanguageContext createNewContext(Set<Display> var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgrammingLanguage other = (ProgrammingLanguage)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public abstract GenericDependency readDependencyFromFile(String var1, ProgrammingLanguageContext var2) throws PlantUMLDependencyException;

    private void setName(String value) {
        ParameterCheckerUtils.checkNullOrEmpty((String)value, (String)"[error-plantuml-dependency-cli-028] : The programming language name is null");
        this.name = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + "]";
    }
}

