/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument;

import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantumldependency.cli.constants.PlantUMLDependencyConstants;
import net.sourceforge.plantumldependency.cli.constants.RegularExpressionConstants;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.impl.GenericDependencyImpl;
import net.sourceforge.plantumldependency.cli.generic.type.DependencyType;
import net.sourceforge.plantumldependency.cli.generic.type.ImportDependenciesCollection;
import net.sourceforge.plantumldependency.cli.generic.type.ImportType;
import net.sourceforge.plantumldependency.cli.generic.type.impl.DependencyTypeImpl;
import net.sourceforge.plantumldependency.cli.generic.type.impl.ImportDependenciesCollectionImpl;
import net.sourceforge.plantumldependency.cli.main.option.display.argument.Display;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.ProgrammingLanguage;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.JavaRawDependency;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaParentType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.java.type.JavaType;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context.ProgrammingLanguageContext;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context.impl.JavaProgrammingLanguageContext;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;

class JavaProgrammingLanguage
extends ProgrammingLanguage {
    private static final transient Logger LOGGER = Logger.getLogger(JavaProgrammingLanguage.class.getName());
    private static final long serialVersionUID = 62105384573195242L;

    private static GenericDependency createDependencyFromRaw(JavaRawDependency javaRawDependency, String sourceFileContent, ProgrammingLanguageContext programmingLanguageContext) throws PlantUMLDependencyException {
        ImportDependenciesCollection importDependenciesCollection = JavaProgrammingLanguage.extractImportDependencies(sourceFileContent, programmingLanguageContext);
        Set<GenericDependency> annotationsDependencies = JavaProgrammingLanguage.extractAnnotationsDependencies(sourceFileContent, javaRawDependency.getType(), importDependenciesCollection, programmingLanguageContext, javaRawDependency.getPackageName());
        boolean hasNativeMethods = javaRawDependency.hasNativeMethods();
        if (hasNativeMethods) {
            importDependenciesCollection.addImportDependencies(ImportType.NATIVE, PlantUMLDependencyConstants.NATIVE_DEPENDENCY);
            programmingLanguageContext.addSeenDependencies(PlantUMLDependencyConstants.NATIVE_DEPENDENCY);
        }
        Set<GenericDependency> parentImplementationsDependencies = JavaProgrammingLanguage.extractParentDependencies(javaRawDependency.getType(), JavaParentType.IMPLEMENTATION, javaRawDependency.getParentImplementations(), importDependenciesCollection, programmingLanguageContext, javaRawDependency.getPackageName());
        Set<GenericDependency> parentExtentionsDependencies = JavaProgrammingLanguage.extractParentDependencies(javaRawDependency.getType(), JavaParentType.EXTENSION, javaRawDependency.getParentExtensions(), importDependenciesCollection, programmingLanguageContext, javaRawDependency.getPackageName());
        DependencyType dependencyType = javaRawDependency.getType().createDependencyType(javaRawDependency.getName(), javaRawDependency.getPackageName(), javaRawDependency.isAbstract(), importDependenciesCollection, parentExtentionsDependencies, parentImplementationsDependencies, annotationsDependencies);
        return JavaProgrammingLanguage.createOrUpdateAbstractDependency(javaRawDependency, dependencyType, programmingLanguageContext);
    }

    private static GenericDependency createOrUpdateAbstractDependency(JavaRawDependency javaRawDependency, DependencyType dependencyType, ProgrammingLanguageContext programmingLanguageContext) {
        GenericDependency dependency = programmingLanguageContext.getParsedOrSeenDependency(javaRawDependency.getFullName());
        if (dependency == null) {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-000] : Creating the dependency \"{0}\" with the type \"{1}\"", (Object[])new Object[]{javaRawDependency.getFullName(), dependencyType}));
            dependency = new GenericDependencyImpl(dependencyType);
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-014] : Updating the dependency \"{0}\" with the type \"{1}\"", (Object[])new Object[]{javaRawDependency.getFullName(), dependencyType}));
            programmingLanguageContext.removePotentialJavaLangSeenDependency(javaRawDependency.getFullName());
            dependency.setDependencyType(dependencyType);
        }
        return dependency;
    }

    private static boolean extractAbstract(String group) {
        return !StringUtils.isEmpty((String)group);
    }

    private static Set<GenericDependency> extractAnnotationsDependencies(String javaSourceFileContent, JavaType type, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext, String currentPackageName) throws PlantUMLDependencyException {
        TreeSet<GenericDependency> annotationDependenciesSet = new TreeSet<GenericDependency>();
        Matcher matcher = RegularExpressionConstants.ANNOTATIONS_REGEXP.matcher(javaSourceFileContent);
        while (matcher.find()) {
            String annotationNameOrFullName = matcher.group(1);
            if ("interface".equals(annotationNameOrFullName)) continue;
            GenericDependency dependency = JavaProgrammingLanguage.getOrCreateAnnotationDependency(annotationNameOrFullName, currentPackageName, type, importDependencies, programmingLanguageContext);
            annotationDependenciesSet.add(dependency);
        }
        return annotationDependenciesSet;
    }

    private static ImportDependenciesCollection extractImportDependencies(String javaSourceFileContent, ProgrammingLanguageContext programmingLanguageContext) {
        ImportDependenciesCollectionImpl importDependenciesCollection = new ImportDependenciesCollectionImpl();
        Set<GenericDependency> standardImportDependenciesSet = JavaProgrammingLanguage.extractImportDependenciesSet(javaSourceFileContent, RegularExpressionConstants.STANDARD_IMPORT_REGEXP, programmingLanguageContext);
        importDependenciesCollection.addImportDependenciesSet(ImportType.STANDARD, standardImportDependenciesSet);
        Set<GenericDependency> staticImportDependenciesSet = JavaProgrammingLanguage.extractImportDependenciesSet(javaSourceFileContent, RegularExpressionConstants.STATIC_IMPORT_REGEXP, programmingLanguageContext);
        importDependenciesCollection.addImportDependenciesSet(ImportType.STATIC, staticImportDependenciesSet);
        return importDependenciesCollection;
    }

    private static Set<GenericDependency> extractImportDependenciesSet(String javaSourceFileContent, Pattern importRegExp, ProgrammingLanguageContext programmingLanguageContext) {
        TreeSet<GenericDependency> importDependenciesSet = new TreeSet<GenericDependency>();
        Matcher matcher = importRegExp.matcher(javaSourceFileContent);
        while (matcher.find()) {
            String name;
            String packageName = matcher.group(1).replace(" ", "");
            String fullName = DependencyTypeImpl.generateDependencyFullName(packageName, name = matcher.group(2).trim());
            GenericDependency dependency = programmingLanguageContext.getParsedOrSeenDependency(fullName);
            if (dependency == null) {
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-002] : The dependency \"{0}\" has not been seen yet, creating it with default type", (String)fullName));
                dependency = new GenericDependencyImpl(name, packageName);
                programmingLanguageContext.addSeenDependencies(dependency);
            } else {
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)fullName));
            }
            importDependenciesSet.add(dependency);
        }
        return importDependenciesSet;
    }

    private static String extractName(String group) throws PlantUMLDependencyException {
        if (StringUtils.isEmpty((String)group)) {
            throw new PlantUMLDependencyException("[error-plantuml-dependency-cli-002] : The dependency name is null");
        }
        return group;
    }

    private static String extractPackageName(String javaSourceFileContent) {
        String packageName = "";
        Matcher matcher = RegularExpressionConstants.PACKAGE_REGEXP.matcher(javaSourceFileContent);
        if (matcher.find()) {
            packageName = matcher.group(1).replace(" ", "");
        } else {
            LOGGER.log(Level.FINE, "[fine-plantuml-dependency-cli-012] : No package name has been found");
        }
        return packageName;
    }

    private static Set<GenericDependency> extractParentDependencies(JavaType type, JavaParentType parentType, Set<String> parents, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext, String currentPackageName) throws PlantUMLDependencyException {
        TreeSet<GenericDependency> parentsSet = new TreeSet<GenericDependency>();
        for (String parentNameOrFullName : parents) {
            GenericDependency dependency = JavaProgrammingLanguage.getOrCreateParentDependency(type, parentType, parentNameOrFullName, currentPackageName, importDependencies, programmingLanguageContext);
            parentsSet.add(dependency);
        }
        return parentsSet;
    }

    private static int getNextEndOfCharContent(int beginningIndex, String str) {
        int index;
        boolean found = false;
        for (index = beginningIndex; index < str.length() && !found; ++index) {
            char currentCharacter = str.charAt(index);
            if (currentCharacter == "\\".charAt(0)) {
                char nextCharacter = str.charAt(index + 1);
                if (nextCharacter != "\\".charAt(0) && nextCharacter != "'".charAt(0)) continue;
                ++index;
                continue;
            }
            if (currentCharacter != "'".charAt(0)) continue;
            found = true;
        }
        if (!found) {
            index = beginningIndex;
        }
        return index;
    }

    private static int getNextEndOfGenericIndex(int beginningIndex, String str) {
        int index = beginningIndex;
        int numberOfGenerics = 1;
        boolean stopSearch = false;
        while (index < str.length() && numberOfGenerics != 0 && !stopSearch) {
            char currentCharacter = str.charAt(index);
            if (currentCharacter == "/".charAt(0)) {
                if (index + 1 < str.length()) {
                    char nextCharacter = str.charAt(index + 1);
                    if (nextCharacter == "/".charAt(0)) {
                        stopSearch = true;
                        continue;
                    }
                    if (nextCharacter == "*".charAt(0)) {
                        stopSearch = true;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ++index;
                continue;
            }
            if (currentCharacter == "'".charAt(0)) {
                stopSearch = true;
                continue;
            }
            if (currentCharacter == "\"".charAt(0)) {
                stopSearch = true;
                continue;
            }
            if (currentCharacter == "@".charAt(0)) {
                stopSearch = true;
                continue;
            }
            if (currentCharacter == "<".charAt(0)) {
                ++numberOfGenerics;
                ++index;
                continue;
            }
            if (currentCharacter == ">".charAt(0)) {
                --numberOfGenerics;
                ++index;
                continue;
            }
            ++index;
        }
        if (numberOfGenerics != 0 || stopSearch) {
            index = beginningIndex;
        }
        return index;
    }

    private static int getNextEndOfMultiLineCommentIndex(int beginningIndex, String str) {
        int index = beginningIndex;
        boolean found = false;
        while (index < str.length() && !found) {
            char currentCharacter = str.charAt(index);
            if (currentCharacter == "*".charAt(0)) {
                if (index + 1 < str.length()) {
                    char nextCharacter = str.charAt(index + 1);
                    if (nextCharacter == "/".charAt(0)) {
                        index += 2;
                        found = true;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ++index;
                continue;
            }
            ++index;
        }
        if (!found) {
            index = beginningIndex;
        }
        return index;
    }

    private static int getNextEndOfSimpleLineCommentIndex(int beginningIndex, String str) {
        int index = beginningIndex;
        boolean found = false;
        while (index < str.length() && !found) {
            char currentCharacter = str.charAt(index);
            if (currentCharacter == "\n".charAt(0) || currentCharacter == "\r".charAt(0)) {
                ++index;
                found = true;
                continue;
            }
            ++index;
        }
        return index;
    }

    private static int getNextEndOfStringContent(int beginningIndex, String str) {
        int index;
        boolean found = false;
        for (index = beginningIndex; index < str.length() && !found; ++index) {
            char currentCharacter = str.charAt(index);
            if (currentCharacter == "\\".charAt(0)) {
                char nextCharacter = str.charAt(index + 1);
                if (nextCharacter != "\\".charAt(0) && nextCharacter != "\"".charAt(0)) continue;
                ++index;
                continue;
            }
            if (currentCharacter != "\"".charAt(0)) continue;
            found = true;
        }
        if (!found) {
            index = beginningIndex;
        }
        return index;
    }

    private static GenericDependency getOrCreateAnnotationDependency(String annotationNameOrFullName, String currentPackageName, JavaType type, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext) throws PlantUMLDependencyException {
        GenericDependency dependency = null;
        int packageSeparatorIndex = annotationNameOrFullName.lastIndexOf(".");
        dependency = packageSeparatorIndex == -1 ? JavaProgrammingLanguage.getOrCreateAnnotationDependencyWithName(annotationNameOrFullName, currentPackageName, type, importDependencies, programmingLanguageContext) : JavaProgrammingLanguage.getOrCreateAnnotationDependencyWithFullName(annotationNameOrFullName, type, importDependencies, programmingLanguageContext, packageSeparatorIndex);
        return dependency;
    }

    private static GenericDependency getOrCreateAnnotationDependencyWithFullName(String annotationFullName, JavaType type, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext, int packageSeparatorIndex) throws PlantUMLDependencyException {
        String parentPackageName;
        String parentName = annotationFullName.substring(packageSeparatorIndex + 1);
        GenericDependency dependency = importDependencies.findDependency(parentName, parentPackageName = annotationFullName.substring(0, packageSeparatorIndex));
        if (dependency == null) {
            dependency = programmingLanguageContext.getParsedOrSeenDependency(annotationFullName);
            if (dependency == null) {
                DependencyType dependencyType = type.createAnnotationDependencyType(parentName, parentPackageName);
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-003] : The dependency \"{0}\" has not been seen yet, creating it with type \"{1}\"", (Object[])new Object[]{annotationFullName, dependencyType}));
                dependency = new GenericDependencyImpl(dependencyType);
                programmingLanguageContext.addSeenDependencies(dependency);
            } else {
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)annotationFullName));
            }
        } else {
            dependency = JavaProgrammingLanguage.getOrCreateAnnotationDependencyWithImportDependency(type, programmingLanguageContext, dependency);
        }
        return dependency;
    }

    private static GenericDependency getOrCreateAnnotationDependencyWithImportDependency(JavaType type, ProgrammingLanguageContext programmingLanguageContext, GenericDependency importDependency) throws PlantUMLDependencyException {
        GenericDependency dependency = importDependency;
        GenericDependency parsedDependency = programmingLanguageContext.getParsedDependency(importDependency.getFullName());
        if (parsedDependency == null) {
            DependencyType dependencyType = type.createAnnotationDependencyType(importDependency.getName(), importDependency.getPackageName());
            dependency.setDependencyType(dependencyType);
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)dependency.getFullName()));
            dependency = parsedDependency;
        }
        return dependency;
    }

    private static GenericDependency getOrCreateAnnotationDependencyWithName(String annotationName, String currentPackageName, JavaType type, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext) throws PlantUMLDependencyException {
        GenericDependency dependency = importDependencies.findDependency(annotationName);
        if (dependency == null) {
            String annotationFullNameWithSamePackage = DependencyTypeImpl.generateDependencyFullName(currentPackageName, annotationName);
            dependency = programmingLanguageContext.getParsedOrSeenDependency(annotationFullNameWithSamePackage);
            if (dependency == null) {
                dependency = JavaProgrammingLanguage.getOrCreateAnnotationDependencyWithNameFromJavaLangOrSamePackage(currentPackageName, type, programmingLanguageContext, annotationName, annotationFullNameWithSamePackage);
            } else {
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)annotationFullNameWithSamePackage));
            }
        } else {
            dependency = JavaProgrammingLanguage.getOrCreateAnnotationDependencyWithImportDependency(type, programmingLanguageContext, dependency);
        }
        return dependency;
    }

    private static GenericDependency getOrCreateAnnotationDependencyWithNameFromJavaLangOrSamePackage(String currentPackageName, JavaType type, ProgrammingLanguageContext programmingLanguageContext, String annotationName, String annotationFullNameWithSamePackage) throws PlantUMLDependencyException {
        DependencyType dependencyType = type.createAnnotationDependencyType(annotationName, currentPackageName);
        LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-003] : The dependency \"{0}\" has not been seen yet, creating it with type \"{1}\"", (Object[])new Object[]{annotationFullNameWithSamePackage, dependencyType}));
        GenericDependencyImpl dependency = new GenericDependencyImpl(dependencyType);
        try {
            String potentialJavaLangAnnotationFullName = DependencyTypeImpl.generateDependencyFullName("java.lang", annotationName);
            Class.forName(potentialJavaLangAnnotationFullName);
            programmingLanguageContext.addPotentialJavaLangSeenDependencies(dependency);
        }
        catch (ClassNotFoundException e) {
            programmingLanguageContext.addSeenDependencies(dependency);
        }
        return dependency;
    }

    private static GenericDependency getOrCreateParentDependency(JavaType type, JavaParentType parentType, String parentNameOrFullName, String currentPackageName, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext) throws PlantUMLDependencyException {
        GenericDependency dependency = null;
        int packageSeparatorIndex = parentNameOrFullName.lastIndexOf(".");
        dependency = packageSeparatorIndex == -1 ? JavaProgrammingLanguage.getOrCreateParentDependencyWithName(type, parentType, currentPackageName, importDependencies, programmingLanguageContext, parentNameOrFullName) : JavaProgrammingLanguage.getOrCreateParentDependencyWithFullName(type, parentType, parentNameOrFullName, importDependencies, programmingLanguageContext, packageSeparatorIndex);
        return dependency;
    }

    private static GenericDependency getOrCreateParentDependencyWithFullName(JavaType type, JavaParentType parentType, String parentFullName, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext, int packageSeparatorIndex) throws PlantUMLDependencyException {
        String parentPackageName;
        String parentName = parentFullName.substring(packageSeparatorIndex + 1);
        GenericDependency dependency = importDependencies.findDependency(parentName, parentPackageName = parentFullName.substring(0, packageSeparatorIndex));
        if (dependency == null) {
            dependency = programmingLanguageContext.getParsedOrSeenDependency(parentFullName);
            if (dependency == null) {
                DependencyType dependencyType = type.createParentDependencyType(parentType, parentName, parentPackageName);
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-003] : The dependency \"{0}\" has not been seen yet, creating it with type \"{1}\"", (Object[])new Object[]{parentFullName, dependencyType}));
                dependency = new GenericDependencyImpl(dependencyType);
                programmingLanguageContext.addSeenDependencies(dependency);
            } else {
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)parentFullName));
            }
        } else {
            dependency = JavaProgrammingLanguage.getOrCreateParentDependencyWithImportDependency(type, parentType, programmingLanguageContext, dependency);
        }
        return dependency;
    }

    private static GenericDependency getOrCreateParentDependencyWithImportDependency(JavaType type, JavaParentType parentType, ProgrammingLanguageContext programmingLanguageContext, GenericDependency importDependency) throws PlantUMLDependencyException {
        GenericDependency dependency = importDependency;
        GenericDependency parsedDependency = programmingLanguageContext.getParsedDependency(importDependency.getFullName());
        if (parsedDependency == null) {
            DependencyType dependencyType = type.createParentDependencyType(parentType, dependency.getName(), dependency.getPackageName());
            dependency.setDependencyType(dependencyType);
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)dependency.getFullName()));
            dependency = parsedDependency;
        }
        return dependency;
    }

    private static GenericDependency getOrCreateParentDependencyWithName(JavaType type, JavaParentType parentType, String currentPackageName, ImportDependenciesCollection importDependencies, ProgrammingLanguageContext programmingLanguageContext, String parentName) throws PlantUMLDependencyException {
        GenericDependency dependency = importDependencies.findDependency(parentName);
        if (dependency == null) {
            String parentFullNameWithSamePackage = DependencyTypeImpl.generateDependencyFullName(currentPackageName, parentName);
            dependency = programmingLanguageContext.getParsedOrSeenDependency(parentFullNameWithSamePackage);
            if (dependency == null) {
                dependency = JavaProgrammingLanguage.getOrCreateParentDependencyWithNameFromJavaLangOrSamePackage(type, parentType, currentPackageName, programmingLanguageContext, parentName, parentFullNameWithSamePackage);
            } else {
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-001] : The dependency \"{0}\" has already been seen, don't have to add it to the seen object Map", (String)parentFullNameWithSamePackage));
            }
        } else {
            dependency = JavaProgrammingLanguage.getOrCreateParentDependencyWithImportDependency(type, parentType, programmingLanguageContext, dependency);
        }
        return dependency;
    }

    private static GenericDependency getOrCreateParentDependencyWithNameFromJavaLangOrSamePackage(JavaType type, JavaParentType parentType, String currentPackageName, ProgrammingLanguageContext programmingLanguageContext, String parentName, String parentFullNameWithSamePackage) throws PlantUMLDependencyException {
        DependencyType dependencyType = type.createParentDependencyType(parentType, parentName, currentPackageName);
        LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-003] : The dependency \"{0}\" has not been seen yet, creating it with type \"{1}\"", (Object[])new Object[]{parentFullNameWithSamePackage, dependencyType}));
        GenericDependencyImpl dependency = new GenericDependencyImpl(dependencyType);
        try {
            String potentialJavaLangParentFullName = DependencyTypeImpl.generateDependencyFullName("java.lang", parentName);
            Class.forName(potentialJavaLangParentFullName);
            programmingLanguageContext.addPotentialJavaLangSeenDependencies(dependency);
        }
        catch (ClassNotFoundException e) {
            programmingLanguageContext.addSeenDependencies(dependency);
        }
        return dependency;
    }

    private static GenericDependency readDependencyFromPreparedFile(String javaSourceFileContent, ProgrammingLanguageContext programmingLanguageContext) throws PlantUMLDependencyException {
        JavaRawDependency javaRawDependency = JavaProgrammingLanguage.readJavaRawDependencyFromPreparedFile(javaSourceFileContent);
        return JavaProgrammingLanguage.createDependencyFromRaw(javaRawDependency, javaSourceFileContent, programmingLanguageContext);
    }

    private static JavaRawDependency readJavaRawDependencyFromPreparedFile(String javaSourceFileContent) throws PlantUMLDependencyException {
        JavaRawDependency javaRawDependency = new JavaRawDependency();
        Matcher matcher = RegularExpressionConstants.JAVA_TYPE_REGEXP.matcher(javaSourceFileContent);
        if (!matcher.find()) {
            throw new PlantUMLDependencyException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-017] : The java type can't be extracted from the content \"{0}\"", (String)javaSourceFileContent));
        }
        String packageName = JavaProgrammingLanguage.extractPackageName(javaSourceFileContent);
        javaRawDependency.setPackageName(packageName);
        boolean isAbstract = JavaProgrammingLanguage.extractAbstract(matcher.group(1));
        javaRawDependency.setAbstract(isAbstract);
        JavaType type = JavaType.valueOfIgnoringCase(matcher.group(2));
        javaRawDependency.setType(type);
        String name = JavaProgrammingLanguage.extractName(matcher.group(3));
        javaRawDependency.setName(name);
        Set<String> parentImplementations = type.extractParentImplementations(matcher.group(5));
        javaRawDependency.setParentImplementations(parentImplementations);
        Set<String> parentExtensions = type.extractParentExtensions(matcher.group(4));
        javaRawDependency.setParentExtensions(parentExtensions);
        boolean nativeMethods = type.extractNativeMethods(javaSourceFileContent);
        javaRawDependency.setNativeMethods(nativeMethods);
        return javaRawDependency;
    }

    private static String removeSourceFileCommentsAndGenerics(String javaSourceFileContent) {
        StringBuilder buffer = new StringBuilder();
        int cursor = 0;
        while (cursor < javaSourceFileContent.length()) {
            char currentCharacter = javaSourceFileContent.charAt(cursor);
            if (currentCharacter == "\n".charAt(0) || currentCharacter == "\r".charAt(0) || currentCharacter == "\t".charAt(0)) {
                buffer.append(" ");
                ++cursor;
                continue;
            }
            if (currentCharacter == "/".charAt(0)) {
                if (cursor + 1 < javaSourceFileContent.length()) {
                    char nextCharacter = javaSourceFileContent.charAt(cursor + 1);
                    if (nextCharacter == "/".charAt(0)) {
                        cursor = JavaProgrammingLanguage.getNextEndOfSimpleLineCommentIndex(cursor + 2, javaSourceFileContent);
                        continue;
                    }
                    if (nextCharacter == "*".charAt(0)) {
                        buffer.append(" ");
                        cursor = JavaProgrammingLanguage.getNextEndOfMultiLineCommentIndex(cursor + 2, javaSourceFileContent);
                        continue;
                    }
                    buffer.append(currentCharacter);
                    ++cursor;
                    continue;
                }
                buffer.append(currentCharacter);
                ++cursor;
                continue;
            }
            if (currentCharacter == "<".charAt(0)) {
                if (cursor + 1 < javaSourceFileContent.length()) {
                    cursor = JavaProgrammingLanguage.getNextEndOfGenericIndex(cursor + 1, javaSourceFileContent);
                    continue;
                }
                buffer.append(currentCharacter);
                ++cursor;
                continue;
            }
            if (currentCharacter == "'".charAt(0)) {
                if (cursor + 1 < javaSourceFileContent.length()) {
                    cursor = JavaProgrammingLanguage.getNextEndOfCharContent(cursor + 1, javaSourceFileContent);
                    buffer.append("'");
                    buffer.append("'");
                    continue;
                }
                buffer.append(currentCharacter);
                ++cursor;
                continue;
            }
            if (currentCharacter == "\"".charAt(0)) {
                if (cursor + 1 < javaSourceFileContent.length()) {
                    cursor = JavaProgrammingLanguage.getNextEndOfStringContent(cursor + 1, javaSourceFileContent);
                    buffer.append("\"");
                    buffer.append("\"");
                    continue;
                }
                buffer.append(currentCharacter);
                ++cursor;
                continue;
            }
            buffer.append(currentCharacter);
            ++cursor;
        }
        return buffer.toString().trim();
    }

    protected JavaProgrammingLanguage(String programmingLanguageName) {
        super(programmingLanguageName);
    }

    @Override
    public ProgrammingLanguageContext createNewContext(Set<Display> displayOpt) {
        return new JavaProgrammingLanguageContext(displayOpt);
    }

    @Override
    public GenericDependency readDependencyFromFile(String sourceFileContent, ProgrammingLanguageContext programmingLanguageContext) throws PlantUMLDependencyException {
        String preparedSourceFileContent = JavaProgrammingLanguage.removeSourceFileCommentsAndGenerics(sourceFileContent);
        GenericDependency genericDependency = JavaProgrammingLanguage.readDependencyFromPreparedFile(preparedSourceFileContent, programmingLanguageContext);
        programmingLanguageContext.addParsedAndSeenDependencies(genericDependency);
        return genericDependency;
    }
}

