/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.output;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.exception.PlantUMLDependencyException;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.main.option.display.argument.Display;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.ProgrammingLanguage;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.context.ProgrammingLanguageContext;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.PlantUMLClassesDiagram;
import net.sourceforge.plantumldependency.common.utils.file.FileUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.execution.AbstractOptionExecution;
import net.sourceforge.plantumldependency.commoncli.option.execution.OptionExecution;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

public class PlantUMLDependencyOutputOptionExecution
extends AbstractOptionExecution {
    private static final long serialVersionUID = 2237748681247499173L;
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLDependencyOutputOptionExecution.class.getName());
    private File outputFile;
    private transient FileSet inputFileSet;
    private ProgrammingLanguage programmingLanguage;
    private Set<Display> displayOptions;

    private static ProgrammingLanguageContext readDependenciesContextFromFiles(ProgrammingLanguage language, FileSet includeExcludeFiles, Set<Display> displayOpt) {
        ProgrammingLanguageContext programmingLanguageContext = language.createNewContext(displayOpt);
        for (FileResource fileResource : includeExcludeFiles) {
            try {
                PlantUMLDependencyOutputOptionExecution.readDependencyFromFile(fileResource.getFile(), programmingLanguageContext, language);
            }
            catch (PlantUMLDependencyException e) {
                LOGGER.log(Level.SEVERE, LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-030] : Severe parsing errors have occurred while reading the source file \"{0}\", the file will be ignored", (Object)fileResource.getFile()));
                LOGGER.log(Level.INFO, e.getMessage(), e);
            }
        }
        programmingLanguageContext.removeAllPotentialJavaLangSeenDependencyAndChangePackageToJavaLang();
        return programmingLanguageContext;
    }

    private static GenericDependency readDependencyFromFile(File file, ProgrammingLanguageContext programmingLanguageContext, ProgrammingLanguage language) throws PlantUMLDependencyException {
        String sourceFileContent = FileUtils.readFileIntoString((File)file);
        return language.readDependencyFromFile(sourceFileContent, programmingLanguageContext);
    }

    public PlantUMLDependencyOutputOptionExecution(File file, ProgrammingLanguage language, FileSet includeExcludeFiles, Set<Display> displayOpt, int optionPriority) {
        super(optionPriority);
        this.setOutputFile(file);
        this.setInputFileSet(includeExcludeFiles);
        this.setProgrammingLanguage(language);
        this.setDisplayOptions(displayOpt);
    }

    public OptionExecution deepClone() {
        PlantUMLDependencyOutputOptionExecution p = (PlantUMLDependencyOutputOptionExecution)super.deepClone();
        p.outputFile = new File(this.outputFile.getAbsolutePath());
        p.inputFileSet = (FileSet)this.inputFileSet.clone();
        p.displayOptions = new TreeSet<Display>(this.displayOptions);
        return p;
    }

    public void execute() throws CommandLineException {
        ProgrammingLanguageContext programmingLanguageContext = PlantUMLDependencyOutputOptionExecution.readDependenciesContextFromFiles(this.getProgrammingLanguage(), this.getInputFileSet(), this.getDisplayOptions());
        PlantUMLClassesDiagram plantUMLDiagram = programmingLanguageContext.getPlantUMLClassesDiagram();
        FileUtils.writeIntoFile((String)plantUMLDiagram.getPlantUMLTextDescription(), (File)this.getOutputFile());
        LOGGER.log(Level.INFO, LogUtils.buildLogString((String)"[info-plantuml-dependency-cli-003] : Number of processed dependencies : \"{0}\"", (Object)programmingLanguageContext.getParsedDependencies().size()));
    }

    private Set<Display> getDisplayOptions() {
        return this.displayOptions;
    }

    private FileSet getInputFileSet() {
        return this.inputFileSet;
    }

    private File getOutputFile() {
        return this.outputFile;
    }

    private ProgrammingLanguage getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    private void setDisplayOptions(Set<Display> value) {
        this.displayOptions = value;
    }

    private void setInputFileSet(FileSet value) {
        this.inputFileSet = value;
    }

    private void setOutputFile(File value) {
        this.outputFile = value;
    }

    private void setProgrammingLanguage(ProgrammingLanguage value) {
        this.programmingLanguage = value;
    }
}

