/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.output;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.main.option.basedirectory.PlantUMLDependencyBaseDirectoryOption;
import net.sourceforge.plantumldependency.cli.main.option.display.PlantUMLDependencyDisplayOption;
import net.sourceforge.plantumldependency.cli.main.option.exclude.PlantUMLDependencyExcludeOption;
import net.sourceforge.plantumldependency.cli.main.option.include.PlantUMLDependencyIncludeOption;
import net.sourceforge.plantumldependency.cli.main.option.output.PlantUMLDependencyOutputOptionExecution;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.PlantUMLDependencyProgrammingLanguageOption;
import net.sourceforge.plantumldependency.cli.main.option.programminglanguage.argument.ProgrammingLanguage;
import net.sourceforge.plantumldependency.common.utils.check.ParameterCheckerUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.commoncli.command.CommandLine;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.Option;
import net.sourceforge.plantumldependency.commoncli.option.OptionWithArgument;
import net.sourceforge.plantumldependency.commoncli.option.argument.OptionArgument;
import net.sourceforge.plantumldependency.commoncli.option.argument.impl.file.ExistingOrNotFileOptionArgumentImpl;
import net.sourceforge.plantumldependency.commoncli.option.execution.ExecutableOption;
import net.sourceforge.plantumldependency.commoncli.option.execution.OptionExecution;
import net.sourceforge.plantumldependency.commoncli.option.impl.output.OutputOption;
import net.sourceforge.plantumldependency.commoncli.option.impl.verbose.VerboseLevelOption;
import net.sourceforge.plantumldependency.commoncli.option.status.OptionStatus;
import org.apache.tools.ant.types.FileSet;

public class PlantUMLDependencyOutputOption
extends OutputOption
implements ExecutableOption {
    private static final long serialVersionUID = -1629517125349614965L;
    private static final transient Logger LOGGER = Logger.getLogger(PlantUMLDependencyOutputOption.class.getName());
    private VerboseLevelOption verboseLevelOption;
    private PlantUMLDependencyProgrammingLanguageOption programmingLanguageOption;
    private PlantUMLDependencyIncludeOption includeOption;
    private PlantUMLDependencyExcludeOption excludeOption;
    private PlantUMLDependencyDisplayOption displayOption;
    private PlantUMLDependencyBaseDirectoryOption baseDirOption;
    private int priority;

    public PlantUMLDependencyOutputOption(VerboseLevelOption verboseLvlOpt, PlantUMLDependencyProgrammingLanguageOption programmingLanguageOpt, PlantUMLDependencyIncludeOption includeOpt, PlantUMLDependencyExcludeOption excludeOpt, PlantUMLDependencyDisplayOption displayOpt, PlantUMLDependencyBaseDirectoryOption baseDirOpt, int optionPriority) {
        super((OptionArgument)new ExistingOrNotFileOptionArgumentImpl(true), new StringBuilder("To specify the output file path where to generate the PlantUML description."), " ", OptionStatus.ACTIVE_OPTIONAL_OPTION_STATUS);
        this.setVerboseLevelOption(verboseLvlOpt);
        this.setProgrammingLanguageOption(programmingLanguageOpt);
        this.setIncludeOption(includeOpt);
        this.setExcludeOption(excludeOpt);
        this.setDisplayOption(displayOpt);
        this.setBaseDirOption(baseDirOpt);
        this.setPriority(optionPriority);
    }

    private PlantUMLDependencyBaseDirectoryOption getBaseDirOption() {
        return this.baseDirOption;
    }

    private PlantUMLDependencyDisplayOption getDisplayOption() {
        return this.displayOption;
    }

    private PlantUMLDependencyExcludeOption getExcludeOption() {
        return this.excludeOption;
    }

    private PlantUMLDependencyIncludeOption getIncludeOption() {
        return this.includeOption;
    }

    public int getPriority() {
        return this.priority;
    }

    private PlantUMLDependencyProgrammingLanguageOption getProgrammingLanguageOption() {
        return this.programmingLanguageOption;
    }

    private VerboseLevelOption getVerboseLevelOption() {
        return this.verboseLevelOption;
    }

    public OptionExecution parseCommandLine(CommandLine commandLine) throws CommandLineException {
        PlantUMLDependencyOutputOptionExecution optionExecution = null;
        Level verboseLevel = (Level)this.getVerboseLevelOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
        LogUtils.setLevelOfAllLoggersAndHandlers((Level)verboseLevel);
        if (commandLine.isOptionSpecified((Option)this)) {
            File outputFile = (File)this.findAndParseArgumentOrGetDefaultArgument(commandLine);
            String excludes = commandLine.findOptionArgument((OptionWithArgument)this.getExcludeOption());
            FileSet includesExcludes = (FileSet)this.getIncludeOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            includesExcludes.setExcludes(excludes);
            File baseDirectory = (File)this.getBaseDirOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            includesExcludes.setDir(baseDirectory);
            Set displayOptions = (Set)this.getDisplayOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            ProgrammingLanguage programmingLanguage = (ProgrammingLanguage)this.getProgrammingLanguageOption().findAndParseArgumentOrGetDefaultArgument(commandLine);
            optionExecution = new PlantUMLDependencyOutputOptionExecution(outputFile, programmingLanguage, includesExcludes, displayOptions, this.getPriority());
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-commoncli-012] : Option \"{0}\" is not specified, it won't be executed", (Object)this.getAllNames()));
        }
        return optionExecution;
    }

    private void setBaseDirOption(PlantUMLDependencyBaseDirectoryOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-000] : The base directory option is null");
        this.baseDirOption = value;
    }

    private void setDisplayOption(PlantUMLDependencyDisplayOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-005] : The display option is null");
        this.displayOption = value;
    }

    private void setExcludeOption(PlantUMLDependencyExcludeOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-006] : The exclude option is null");
        this.excludeOption = value;
    }

    private void setIncludeOption(PlantUMLDependencyIncludeOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-008] : The include option is null");
        this.includeOption = value;
    }

    private void setPriority(int value) {
        this.priority = value;
    }

    private void setProgrammingLanguageOption(PlantUMLDependencyProgrammingLanguageOption value) {
        ParameterCheckerUtils.checkNull((Object)((Object)value), (String)"[error-plantuml-dependency-cli-029] : The programming language option is null");
        this.programmingLanguageOption = value;
    }

    private void setVerboseLevelOption(VerboseLevelOption value) {
        ParameterCheckerUtils.checkNull((Object)value, (String)"[error-plantuml-dependency-commoncli-048] : The verbose option is null");
        this.verboseLevelOption = value;
    }
}

