/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.display.argument;

import java.util.Arrays;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sourceforge.plantumldependency.cli.main.option.display.argument.Display;
import net.sourceforge.plantumldependency.common.utils.collection.CollectionUtils;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;
import net.sourceforge.plantumldependency.commoncli.exception.CommandLineException;
import net.sourceforge.plantumldependency.commoncli.option.argument.AbstractOptionArgument;

public class PlantUMLDependencyDisplayOptionArgument
extends AbstractOptionArgument<Set<Display>> {
    private static final long serialVersionUID = 4078671176887334895L;
    private static final String MAIN_USAGE = "DISPLAY_OPTIONS";
    private static final String USAGE_DESCRIPTION = "DISPLAY_OPTIONS specifies display options when generating the plantuml output file, it is a separated comma list with these possible values : " + CollectionUtils.collectionToString(Arrays.asList(Display.values()), (String)",") + ". " + Display.getAllDisplayOptionsFullUsageDescriptions() + ".";

    public PlantUMLDependencyDisplayOptionArgument(boolean optionArgumentIsMandatory) {
        super(optionArgumentIsMandatory, new StringBuilder(USAGE_DESCRIPTION));
    }

    protected String getMainUsageDescription() {
        return MAIN_USAGE;
    }

    public Set<Display> parseArgument(String argument) throws CommandLineException {
        TreeSet<Display> displayArguments = null;
        if (StringUtils.isNotEmpty((String)argument)) {
            displayArguments = new TreeSet<Display>();
            StringTokenizer tokenizer = new StringTokenizer(argument, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    Display displayArgument = Display.valueOf(token.toUpperCase());
                    if (displayArguments.contains((Object)displayArgument)) {
                        throw new CommandLineException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-026] : The display argument \"{0}\" is defined several times", (Object)((Object)displayArgument)));
                    }
                    displayArguments.add(Display.valueOf(token.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineException(LogUtils.buildLogString((String)"[error-plantuml-dependency-cli-025] : Can't parse option argument \"{0}\", it isn't a valid display argument", (String)argument), (Throwable)e);
                }
            }
        } else {
            throw new CommandLineException("[error-plantuml-dependency-commoncli-009] : Can't parse option argument, it is empty");
        }
        return displayArguments;
    }
}

