/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.main.option.display.argument;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public enum Display {
    ABSTRACT_CLASSES("displays parsed source files which are abstract classes and relations to abstract classes"),
    ANNOTATIONS("displays parsed source files which are annotations, annotations (upon classes and methods) of all parsed source files and relations to annotations"),
    CLASSES("displays parsed source files which are classes (not abstract), dependencies which are considered as classes (because they are imported or extended but not parsed) and relations to classes"),
    ENUMS("displays parsed source files which are enums and relations to enums"),
    EXTENSIONS("displays relations between dependencies which are extended by parsed source files (i.e. classes or interfaces) if their type is displayed"),
    IMPLEMENTATIONS("displays relations between dependencies which are implemented by parsed source files (i.e. interfaces) if their type is displayed"),
    IMPORTS("displays relations from parsed source files to import dependencies (not static) if their type is displayed"),
    INTERFACES("displays parsed source files which are interfaces, dependencies which are considered as interfaces (because they are implemented but not parsed) and relations to interfaces"),
    NATIVE_METHODS("displays relations from parsed source files to the native dependency if they use native methods"),
    STATIC_IMPORTS("displays relations from parsed source files to import dependencies (only static) if their type is displayed");

    public static final Set<Display> DISPLAY_OPTIONS;
    private String usageDescription;

    public static String getAllDisplayOptionsFullUsageDescriptions() {
        return Display.getFullUsageDescriptions(DISPLAY_OPTIONS);
    }

    public static String getFullUsageDescriptions(Set<Display> displayOptions) {
        StringBuilder buffer = new StringBuilder();
        Iterator<Display> iterator = displayOptions.iterator();
        while (iterator.hasNext()) {
            Display display = iterator.next();
            buffer.append(display.getFullUsageDescription());
            if (!iterator.hasNext()) continue;
            buffer.append(",");
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private Display(String usageDesc) {
        this.setUsageDescription(usageDesc);
    }

    public String getFullUsageDescription() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"");
        buffer.append(this.toString());
        buffer.append("\"");
        buffer.append(" ");
        buffer.append(":");
        buffer.append(" ");
        buffer.append(this.getUsageDescription());
        return buffer.toString();
    }

    public String getUsageDescription() {
        return this.usageDescription;
    }

    private void setUsageDescription(String value) {
        this.usageDescription = value;
    }

    public String toString() {
        String str = super.toString();
        return str.toLowerCase();
    }

    static {
        DISPLAY_OPTIONS = new TreeSet<Display>(Arrays.asList(Display.values()));
    }
}

