/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.generic.type.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.type.ImportDependenciesCollection;
import net.sourceforge.plantumldependency.cli.generic.type.ImportType;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;

public class ImportDependenciesCollectionImpl
implements ImportDependenciesCollection {
    private static final transient Logger LOGGER = Logger.getLogger(ImportDependenciesCollectionImpl.class.getName());
    private static final long serialVersionUID = -5520264467935038385L;
    private Map<ImportType, Set<GenericDependency>> importDependenciesMap;

    private static String printDependencyMap(Map<ImportType, Set<GenericDependency>> dependenciesMap) {
        TreeMap printableMap = new TreeMap();
        for (Map.Entry<ImportType, Set<GenericDependency>> entry : dependenciesMap.entrySet()) {
            ImportType importType = entry.getKey();
            Set<GenericDependency> dependenciesSet = entry.getValue();
            TreeSet<String> importDependencies = (TreeSet<String>)printableMap.get(importType);
            if (importDependencies == null) {
                importDependencies = new TreeSet<String>();
                printableMap.put(importType, importDependencies);
            }
            for (GenericDependency dependency : dependenciesSet) {
                importDependencies.add(dependency.getFullName());
            }
        }
        return ((Object)printableMap).toString();
    }

    public ImportDependenciesCollectionImpl() {
        this.importDependenciesMap = new TreeMap<ImportType, Set<GenericDependency>>();
        for (ImportType importType : ImportType.IMPORT_TYPES) {
            this.importDependenciesMap.put(importType, new TreeSet());
        }
    }

    public ImportDependenciesCollectionImpl(ImportType importType, Set<GenericDependency> dependenciesSet) {
        this();
        this.addImportDependenciesSet(importType, dependenciesSet);
    }

    public ImportDependenciesCollectionImpl(Map<ImportType, Set<GenericDependency>> dependenciesMap) {
        this.importDependenciesMap = new TreeMap<ImportType, Set<GenericDependency>>(dependenciesMap);
        for (ImportType importType : ImportType.IMPORT_TYPES) {
            if (this.importDependenciesMap.containsKey(importType)) continue;
            this.importDependenciesMap.put(importType, new TreeSet());
        }
    }

    @Override
    public void addImportDependencies(ImportType importType, GenericDependency importDependency) {
        this.getImportDependenciesMap().get(importType).add(importDependency);
    }

    @Override
    public void addImportDependenciesSet(ImportType importType, Set<GenericDependency> importDependenciesSet) {
        this.getImportDependenciesMap().get(importType).addAll(importDependenciesSet);
    }

    public ImportDependenciesCollection deepClone() {
        ImportDependenciesCollectionImpl i = null;
        try {
            i = (ImportDependenciesCollectionImpl)super.clone();
            i.importDependenciesMap = new TreeMap<ImportType, Set<GenericDependency>>(this.getImportDependenciesMap());
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportDependenciesCollectionImpl other = (ImportDependenciesCollectionImpl)obj;
        return !(this.importDependenciesMap == null ? other.importDependenciesMap != null : !this.importDependenciesMap.equals(other.importDependenciesMap));
    }

    @Override
    public GenericDependency findDependency(String dependencyName) {
        GenericDependency dependency = null;
        Iterator<GenericDependency> iter = this.getAllImportDependencies().iterator();
        while (dependency == null && iter.hasNext()) {
            GenericDependency abstractImportDependency = iter.next();
            if (!abstractImportDependency.getName().equals(dependencyName)) continue;
            dependency = abstractImportDependency;
        }
        return dependency;
    }

    @Override
    public GenericDependency findDependency(String dependencyName, String dependencyPackageName) {
        GenericDependency dependency = null;
        Iterator<GenericDependency> iter = this.getAllImportDependencies().iterator();
        while (dependency == null && iter.hasNext()) {
            GenericDependency abstractImportDependency = iter.next();
            if (!abstractImportDependency.getName().equals(dependencyName) || !abstractImportDependency.getPackageName().equals(dependencyPackageName)) continue;
            dependency = abstractImportDependency;
        }
        return dependency;
    }

    @Override
    public Set<GenericDependency> getAllImportDependencies() {
        return this.getImportDependenciesWithTypes(ImportType.IMPORT_TYPES);
    }

    private Map<ImportType, Set<GenericDependency>> getImportDependenciesMap() {
        return this.importDependenciesMap;
    }

    @Override
    public Set<GenericDependency> getImportDependenciesWithType(ImportType importType) {
        TreeSet<ImportType> importTypeSet = new TreeSet<ImportType>();
        importTypeSet.add(importType);
        return this.getImportDependenciesWithTypes(importTypeSet);
    }

    @Override
    public Set<GenericDependency> getImportDependenciesWithTypes(Set<ImportType> importTypesSet) {
        TreeSet<GenericDependency> dependenciesSet = new TreeSet<GenericDependency>();
        for (Map.Entry<ImportType, Set<GenericDependency>> importDependenciesEntry : this.getImportDependenciesMap().entrySet()) {
            ImportType importType = importDependenciesEntry.getKey();
            Set<GenericDependency> importDependencies = importDependenciesEntry.getValue();
            if (importTypesSet.contains(importType)) {
                dependenciesSet.addAll(importDependencies);
                continue;
            }
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-009] : Import type \"{0}\" not found in the import collection, skipping it...", (Object)importType));
        }
        return dependenciesSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.importDependenciesMap == null ? 0 : this.importDependenciesMap.hashCode());
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [importDependenciesMap=" + ImportDependenciesCollectionImpl.printDependencyMap(this.importDependenciesMap) + "]";
    }
}

