/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantumldependency.cli.generic.type.impl;

import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantumldependency.cli.generic.GenericDependency;
import net.sourceforge.plantumldependency.cli.generic.type.DependencyType;
import net.sourceforge.plantumldependency.cli.generic.type.ImportDependenciesCollection;
import net.sourceforge.plantumldependency.cli.generic.type.ImportType;
import net.sourceforge.plantumldependency.cli.generic.type.impl.ImportDependenciesCollectionImpl;
import net.sourceforge.plantumldependency.cli.main.option.display.argument.Display;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.element.PlantUMLClassesDiagramElement;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.PlantUMLClassesDiagramRelation;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.impl.PlantUMLClassesDiagramExtendRelationImpl;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.impl.PlantUMLClassesDiagramImplementRelationImpl;
import net.sourceforge.plantumldependency.cli.plantumldiagram.classes.relation.impl.PlantUMLClassesDiagramUseRelationImpl;
import net.sourceforge.plantumldependency.common.utils.comparable.ComparableResult;
import net.sourceforge.plantumldependency.common.utils.log.LogUtils;
import net.sourceforge.plantumldependency.common.utils.string.StringUtils;

public abstract class DependencyTypeImpl
implements DependencyType {
    private static final transient Logger LOGGER = Logger.getLogger(DependencyTypeImpl.class.getName());
    private static final long serialVersionUID = -233142953615737115L;
    private String fullName;
    private ImportDependenciesCollection importDependenciesCollection;
    private String name;
    private String packageName;
    private Set<GenericDependency> parentExtensionsDependencies;
    private Set<GenericDependency> parentImplementationsDependencies;
    private Set<GenericDependency> annotationsDependencies;
    private PlantUMLClassesDiagramElement plantUMLClassesDiagramElement;
    private Set<PlantUMLClassesDiagramRelation> plantUMLClassesDiagramRelationSet;
    private boolean isToStringResursiveCall = false;

    public static String generateDependencyFullName(String dependencyPackageName, String dependencyName) {
        String fullName = null;
        fullName = StringUtils.isNotEmpty((String)dependencyPackageName) ? dependencyPackageName + "." + dependencyName : dependencyName;
        return fullName;
    }

    protected DependencyTypeImpl(String dependencyName, String dependencyPackageName) {
        this(dependencyName, dependencyPackageName, new ImportDependenciesCollectionImpl(), new TreeSet<GenericDependency>(), new TreeSet<GenericDependency>(), new TreeSet<GenericDependency>());
    }

    protected DependencyTypeImpl(String dependencyName, String dependencyPackageName, ImportDependenciesCollection importDependencies, Set<GenericDependency> parentExtensionsDependenciesSet, Set<GenericDependency> parentImplementationsDependenciesSet, Set<GenericDependency> annotationsDependenciesSet) {
        this.setFullName(dependencyPackageName, dependencyName);
        this.importDependenciesCollection = importDependencies;
        this.parentExtensionsDependencies = parentExtensionsDependenciesSet;
        this.parentImplementationsDependencies = parentImplementationsDependenciesSet;
        this.annotationsDependencies = annotationsDependenciesSet;
    }

    @Override
    public int compareTo(DependencyType d) {
        int comparison = ComparableResult.AFTER.getResult();
        comparison = this == d ? ComparableResult.EQUAL.getResult() : this.getFullName().compareTo(d.getFullName());
        return comparison;
    }

    public DependencyType deepClone() {
        DependencyTypeImpl d = null;
        try {
            d = (DependencyTypeImpl)super.clone();
            d.importDependenciesCollection = (ImportDependenciesCollection)this.getImportDependenciesCollection().deepClone();
            d.parentExtensionsDependencies = new TreeSet<GenericDependency>(this.getParentExtensionsDependencies());
            d.parentImplementationsDependencies = new TreeSet<GenericDependency>(this.getParentImplementationsDependencies());
            d.annotationsDependencies = new TreeSet<GenericDependency>(this.getAnnotationsDependencies());
        }
        catch (CloneNotSupportedException cnse) {
            LOGGER.log(Level.SEVERE, "[error-plantuml-dependency-common-006] : A severe and unexpected error has occurred", cnse);
        }
        return d;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyTypeImpl other = (DependencyTypeImpl)obj;
        return !(this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName));
    }

    protected abstract PlantUMLClassesDiagramElement generatePlantUMLClassesDiagramElement();

    private Set<PlantUMLClassesDiagramRelation> generatePlantUMLClassesDiagramRelations(Set<Display> displayOptions) {
        TreeSet<PlantUMLClassesDiagramRelation> linkSet = new TreeSet<PlantUMLClassesDiagramRelation>();
        for (GenericDependency importDependency : this.getImportDependenciesToGeneratePlantUML(displayOptions)) {
            linkSet.add(new PlantUMLClassesDiagramUseRelationImpl(this.getPlantUMLClassesDiagramElement(), importDependency.getDependencyType().getPlantUMLClassesDiagramElement()));
        }
        for (GenericDependency parentImplementationsDependency : this.getParentImplementationsToGeneratePlantUML(displayOptions)) {
            linkSet.add(new PlantUMLClassesDiagramImplementRelationImpl(this.getPlantUMLClassesDiagramElement(), parentImplementationsDependency.getDependencyType().getPlantUMLClassesDiagramElement()));
        }
        for (GenericDependency parentExtensionsDependency : this.getParentExtensionsToGeneratePlantUML(displayOptions)) {
            linkSet.add(new PlantUMLClassesDiagramExtendRelationImpl(this.getPlantUMLClassesDiagramElement(), parentExtensionsDependency.getDependencyType().getPlantUMLClassesDiagramElement()));
        }
        for (GenericDependency annotationDependency : this.getAnnotationsToGeneratePlantUML(displayOptions)) {
            linkSet.add(new PlantUMLClassesDiagramUseRelationImpl(this.getPlantUMLClassesDiagramElement(), annotationDependency.getDependencyType().getPlantUMLClassesDiagramElement()));
        }
        return linkSet;
    }

    @Override
    public Set<GenericDependency> getAnnotationsDependencies() {
        return this.annotationsDependencies;
    }

    private Set<GenericDependency> getAnnotationsToGeneratePlantUML(Set<Display> displayOptions) {
        TreeSet<GenericDependency> annotationsDependenciesDisplayable = new TreeSet<GenericDependency>();
        if (displayOptions.contains((Object)Display.ANNOTATIONS)) {
            for (GenericDependency genericDependency : this.getAnnotationsDependencies()) {
                if (genericDependency.getDependencyType().isDisplayable(displayOptions)) {
                    annotationsDependenciesDisplayable.add(genericDependency);
                    continue;
                }
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-008] : Dependency \"{0}\" is not displayable, UML relation doesn't have to be generated", (Object)genericDependency));
            }
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-005] : Display option \"{0}\" isn't managed, UML relations don't have to be generated", (Object)((Object)Display.ANNOTATIONS)));
        }
        return annotationsDependenciesDisplayable;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public ImportDependenciesCollection getImportDependenciesCollection() {
        return this.importDependenciesCollection;
    }

    private Set<GenericDependency> getImportDependenciesToGeneratePlantUML(Set<Display> displayOptions) {
        TreeSet<GenericDependency> importDependenciesNotImplementedNorExtendedNorAnnonatedAndDisplayable = new TreeSet<GenericDependency>();
        for (ImportType importType : ImportType.IMPORT_TYPES) {
            if (displayOptions.contains((Object)importType.getDisplayOption())) {
                for (GenericDependency genericDependency : this.getImportDependenciesCollection().getImportDependenciesWithType(importType)) {
                    if (!this.isDependencyInExtensionsImplementationsOrAnnotationsDependencies(genericDependency)) {
                        if (genericDependency.getDependencyType().isDisplayable(displayOptions)) {
                            importDependenciesNotImplementedNorExtendedNorAnnonatedAndDisplayable.add(genericDependency);
                            continue;
                        }
                        LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-008] : Dependency \"{0}\" is not displayable, UML relation doesn't have to be generated", (Object)genericDependency));
                        continue;
                    }
                    LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-007] : Import \"{0}\" is either an implementation, an extension or an annotation, skipping UML use relation generation here", (Object)genericDependency));
                }
                continue;
            }
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-005] : Display option \"{0}\" isn't managed, UML relations don't have to be generated", (Object)((Object)importType.getDisplayOption())));
        }
        return importDependenciesNotImplementedNorExtendedNorAnnonatedAndDisplayable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Set<GenericDependency> getParentExtensionsDependencies() {
        return this.parentExtensionsDependencies;
    }

    private Set<GenericDependency> getParentExtensionsToGeneratePlantUML(Set<Display> displayOptions) {
        TreeSet<GenericDependency> extensionsDependenciesDisplayable = new TreeSet<GenericDependency>();
        if (displayOptions.contains((Object)Display.EXTENSIONS)) {
            for (GenericDependency genericDependency : this.getParentExtensionsDependencies()) {
                if (genericDependency.getDependencyType().isDisplayable(displayOptions)) {
                    extensionsDependenciesDisplayable.add(genericDependency);
                    continue;
                }
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-008] : Dependency \"{0}\" is not displayable, UML relation doesn't have to be generated", (Object)genericDependency));
            }
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-005] : Display option \"{0}\" isn't managed, UML relations don't have to be generated", (Object)((Object)Display.EXTENSIONS)));
        }
        return extensionsDependenciesDisplayable;
    }

    @Override
    public Set<GenericDependency> getParentImplementationsDependencies() {
        return this.parentImplementationsDependencies;
    }

    private Set<GenericDependency> getParentImplementationsToGeneratePlantUML(Set<Display> displayOptions) {
        TreeSet<GenericDependency> implementationsDependenciesDisplayable = new TreeSet<GenericDependency>();
        if (displayOptions.contains((Object)Display.IMPLEMENTATIONS)) {
            for (GenericDependency genericDependency : this.getParentImplementationsDependencies()) {
                if (genericDependency.getDependencyType().isDisplayable(displayOptions)) {
                    implementationsDependenciesDisplayable.add(genericDependency);
                    continue;
                }
                LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-008] : Dependency \"{0}\" is not displayable, UML relation doesn't have to be generated", (Object)genericDependency));
            }
        } else {
            LOGGER.log(Level.FINE, LogUtils.buildLogString((String)"[fine-plantuml-dependency-cli-005] : Display option \"{0}\" isn't managed, UML relations don't have to be generated", (Object)((Object)Display.IMPLEMENTATIONS)));
        }
        return implementationsDependenciesDisplayable;
    }

    @Override
    public PlantUMLClassesDiagramElement getPlantUMLClassesDiagramElement() {
        if (this.plantUMLClassesDiagramElement == null) {
            this.plantUMLClassesDiagramElement = this.generatePlantUMLClassesDiagramElement();
        }
        return this.plantUMLClassesDiagramElement;
    }

    @Override
    public Set<PlantUMLClassesDiagramRelation> getPlantUMLClassesDiagramRelations() {
        if (this.plantUMLClassesDiagramRelationSet == null) {
            this.plantUMLClassesDiagramRelationSet = this.getPlantUMLClassesDiagramRelations(Display.DISPLAY_OPTIONS);
        }
        return this.plantUMLClassesDiagramRelationSet;
    }

    @Override
    public Set<PlantUMLClassesDiagramRelation> getPlantUMLClassesDiagramRelations(Set<Display> displayOptions) {
        return this.generatePlantUMLClassesDiagramRelations(displayOptions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        return result;
    }

    private boolean isDependencyInExtensionsImplementationsOrAnnotationsDependencies(GenericDependency genericDependency) {
        return this.getParentImplementationsDependencies().contains(genericDependency) || this.getParentExtensionsDependencies().contains(genericDependency) || this.getAnnotationsDependencies().contains(genericDependency);
    }

    @Override
    public void setFullName(String dependencyPackageName, String dependencyName) {
        this.name = dependencyName;
        this.packageName = dependencyPackageName;
        this.fullName = DependencyTypeImpl.generateDependencyFullName(this.packageName, this.name);
    }

    public String toString() {
        String result = this.getClass().getSimpleName() + " [fullName=" + this.fullName;
        if (this.isToStringResursiveCall) {
            result = result + "....]";
        } else {
            this.isToStringResursiveCall = true;
            result = result + ", importDependenciesCollection=" + this.importDependenciesCollection + ", name=" + this.name + ", packageName=" + this.packageName + ", parentExtensionsDependencies=" + this.parentExtensionsDependencies + ", parentImplementationsDependencies=" + this.parentImplementationsDependencies + ", annotations=" + this.annotationsDependencies + ", plantUMLClassesDiagramElement=" + this.plantUMLClassesDiagramElement + ", plantUMLClassesDiagramRelationSet=" + this.plantUMLClassesDiagramRelationSet + "]";
            this.isToStringResursiveCall = false;
        }
        return result;
    }
}

