/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.pagesdialect.PagesDialect;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;

public class SortLinkCommand {
    protected Arguments arguments;
    protected Element element;
    protected String attributeName;
    protected PagesDialect dialect;
    protected IWebContext context;
    private String sortParam = "sort";
    private String sortTypeParam = "sortType";

    public SortLinkCommand(Arguments arguments, Element element, String string, PagesDialect pagesDialect) {
        this.arguments = arguments;
        this.element = element;
        this.attributeName = string;
        this.dialect = pagesDialect;
        if (pagesDialect.getProperties().containsKey("sortParameter")) {
            this.sortParam = pagesDialect.getProperties().get("sortParameter");
        }
        if (pagesDialect.getProperties().containsKey("sortTypeParameter")) {
            this.sortTypeParam = pagesDialect.getProperties().get("sortTypeParameter");
        }
        this.context = (IWebContext)arguments.getContext();
    }

    public void execute() {
        String string = this.element.getAttributeValue(this.attributeName).trim();
        Boolean bl = this.getSortType(string);
        this.addSortLink(string, bl);
        this.element.removeAttribute(this.attributeName);
    }

    protected Boolean getSortType(String string) {
        String string2;
        if (this.context.getRequestParameters().containsKey((Object)this.sortParam) && (string2 = ((String[])this.context.getRequestParameters().get((Object)this.sortParam))[0]) != null && string.equals(string2) && this.context.getRequestParameters().containsKey((Object)this.sortTypeParam)) {
            return "desc".equals(((String[])this.context.getRequestParameters().get((Object)this.sortTypeParam))[0]);
        }
        return null;
    }

    protected void addSortLink(String string, Boolean bl) {
        HttpServletRequest httpServletRequest = ((IWebContext)this.arguments.getContext()).getHttpServletRequest();
        String string2 = httpServletRequest.getRequestURL().toString().split("\\?")[0];
        String string3 = httpServletRequest.getQueryString();
        if (string3 != null) {
            string3 = string3.replaceAll("&?" + this.sortParam + "=[^&]*", "");
            string3 = string3.replaceAll("&?" + this.sortTypeParam + "=[^&]*", "");
        }
        string3 = string3 != null && !"".equals(string3) ? string3 + "&" : "";
        string3 = string3 + this.sortParam + "=" + string + "&" + this.sortTypeParam + "=" + (bl == null || bl != false ? "asc" : "desc");
        String string4 = string2 + "?" + string3;
        Element element = this.element.cloneElementNodeWithNewName((NestableNode)this.element, "a", false);
        for (String string5 : element.getAttributeMap().keySet()) {
            element.removeAttribute(string5);
        }
        element.setAttribute("href", string4);
        if (bl == null) {
            element.setAttribute("class", "sort-sortable");
        } else if (bl.booleanValue()) {
            element.setAttribute("class", "sort-desc");
        } else {
            element.setAttribute("class", "sort-asc");
        }
        for (String string5 : this.element.getChildren()) {
            this.element.removeChild((Node)string5);
        }
        this.element.addChild((Node)element);
    }
}

