/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import net.sourceforge.pagesdialect.IterationListPreparer;
import net.sourceforge.pagesdialect.NavigationBarRenderer;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import org.springframework.beans.support.PagedListHolder;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;

public class PaginateCommand {
    private Arguments arguments;
    private Element element;
    private String attributeName;
    private PagesDialect dialect;
    private int pageSize;
    private PagedListHolder pagedList;

    public PaginateCommand(Arguments arguments, Element element, String string, PagesDialect pagesDialect) {
        this.arguments = arguments;
        this.element = element;
        this.attributeName = string;
        this.dialect = pagesDialect;
    }

    public void execute() {
        this.parseArguments();
        this.setCurrentPage();
        this.addNavigationBar();
        this.element.removeAttribute(this.attributeName);
    }

    private void parseArguments() {
        String string = this.element.getAttributeValue(this.attributeName);
        String string2 = PagesDialectUtil.expressionValue(this.arguments, string).toString();
        this.pageSize = Integer.parseInt(string2);
    }

    private void setCurrentPage() {
        IterationListPreparer iterationListPreparer = new IterationListPreparer(this.arguments, this.element);
        this.pagedList = iterationListPreparer.findOrCreateIterationList();
        this.pagedList.setPageSize(this.pageSize);
        IWebContext iWebContext = (IWebContext)this.arguments.getContext();
        String string = this.dialect.getPageParameter();
        if (iWebContext.getRequestParameters().containsKey((Object)string)) {
            this.pagedList.setPage(Integer.parseInt(((String[])iWebContext.getRequestParameters().get((Object)string))[0]));
        }
    }

    private void addNavigationBar() {
        NavigationBarRenderer navigationBarRenderer = new NavigationBarRenderer(this.arguments, this.element, this.dialect, this.pagedList);
        navigationBarRenderer.addNavigationBar();
    }
}

