/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.data.domain.Page;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;

public class NavigationBarRenderer {
    private Arguments arguments;
    private Element element;
    private PagesDialect dialect;
    private Element container;
    private int pageCount;
    private int page;
    private long nrOfElements;
    private int firstElementOnPage;
    private int lastElementOnPage;
    private boolean firstPage;
    private boolean lastPage;

    public NavigationBarRenderer(Arguments arguments, Element element, PagesDialect pagesDialect, PagedListHolder pagedListHolder) {
        this.arguments = arguments;
        this.element = element;
        this.dialect = pagesDialect;
        this.pageCount = pagedListHolder.getPageCount();
        this.page = pagedListHolder.getPage();
        this.nrOfElements = pagedListHolder.getNrOfElements();
        this.firstElementOnPage = pagedListHolder.getFirstElementOnPage();
        this.lastElementOnPage = pagedListHolder.getLastElementOnPage();
        this.firstPage = pagedListHolder.isFirstPage();
        this.lastPage = pagedListHolder.isLastPage();
    }

    public NavigationBarRenderer(Arguments arguments, Element element, PagesDialect pagesDialect, Page page) {
        this.arguments = arguments;
        this.element = element;
        this.dialect = pagesDialect;
        this.pageCount = page.getTotalPages();
        this.page = page.getNumber();
        this.nrOfElements = page.getTotalElements();
        this.firstElementOnPage = page.getNumber() * page.getSize();
        this.lastElementOnPage = page.getNumber() * page.getSize() + page.getNumberOfElements() - 1;
        this.firstPage = page.isFirstPage();
        this.lastPage = page.isLastPage();
    }

    void addNavigationBar() {
        this.addNavigationLinksIfNeeded();
        this.addNumberOfResultsText();
    }

    private void addNavigationLinksIfNeeded() {
        this.container = PagesDialectUtil.getContainerElement(this.element);
        if (this.pageCount > 1) {
            this.addNavigationLinks();
        }
    }

    private void addNumberOfResultsText() {
        if (this.nrOfElements > 0L) {
            this.addResultCount();
        } else {
            this.addNoResult();
        }
    }

    private void addResultCount() {
        String string;
        Element element = new Element("span");
        element.setAttribute("class", "paginate-count");
        if (this.nrOfElements == 1L) {
            string = this.getMessageOrDefault(this.arguments, "1 result", "pagesdialect.oneResult", new String[0]);
        } else {
            String[] stringArray = new String[]{this.firstElementOnPage + 1 + "", this.lastElementOnPage + 1 + "", this.nrOfElements + ""};
            string = this.getMessageOrDefault(this.arguments, "{0} results", "pagesdialect.results", stringArray);
        }
        element.addChild((Node)new Text(string));
        this.container.getParent().insertAfter((Node)this.container, (Node)element);
    }

    private void addNoResult() {
        Element element = new Element("span");
        element.setAttribute("class", "paginate-no-result");
        String string = this.getMessageOrDefault(this.arguments, "No result found", "pagesdialect.none", new String[0]);
        element.addChild((Node)new Text(string));
        this.container.getParent().insertAfter((Node)this.container, (Node)element);
    }

    private String getPageUrl(int n) {
        HttpServletRequest httpServletRequest = ((IWebContext)this.arguments.getContext()).getHttpServletRequest();
        String string = httpServletRequest.getRequestURL().toString().split("\\?")[0];
        String string2 = httpServletRequest.getQueryString();
        String string3 = this.dialect.getPageParameter();
        string2 = string2 == null ? string3 + "=" + n : (string2.contains(string3 + "=") ? string2.replaceAll(string3 + "=[0-9]+", string3 + "=" + n) : string2 + "&" + string3 + "=" + n);
        return string + "?" + string2;
    }

    private void addNavigationLinks() {
        Element element = new Element("div");
        element.setAttribute("class", "paginate");
        if (!this.firstPage) {
            this.addLinkToDiv(element, 0, "paginate-first", "First", "pagesdialect.first");
            this.addLinkToDiv(element, this.page - 1, "paginate-previous", "Previous", "pagesdialect.previous");
        }
        Element element2 = new Element("span");
        element2.setAttribute("class", "paginate-page");
        String[] stringArray = new String[]{this.page + 1 + "", this.pageCount + ""};
        String string = this.getMessageOrDefault(this.arguments, "Page {0} of {1}", "pagesdialect.page", stringArray);
        element2.addChild((Node)new Text(string));
        element.addChild((Node)element2);
        element.addChild((Node)new Text(" "));
        if (!this.lastPage) {
            this.addLinkToDiv(element, this.page + 1, "paginate-next", "Next", "pagesdialect.next");
            this.addLinkToDiv(element, this.pageCount - 1, "paginate-last", "Last", "pagesdialect.last");
        }
        this.container.getParent().insertAfter((Node)this.container, (Node)element);
    }

    private void addLinkToDiv(Element element, int n, String string, String string2, String string3) {
        Element element2 = new Element("a");
        element2.setAttribute("class", string);
        element2.setAttribute("href", this.getPageUrl(n));
        String string4 = this.getMessageOrDefault(this.arguments, string2, string3, new String[0]);
        element2.addChild((Node)new Text(string4));
        element.addChild((Node)element2);
        Text text = new Text(" ");
        element.addChild((Node)text);
    }

    private String getMessageOrDefault(Arguments arguments, String string, String string2, String ... stringArray) {
        String string3 = this.dialect.getProperties().containsKey(string2) ? this.dialect.getProperties().get(string2) : string2;
        String string4 = PagesDialectUtil.templateMessage(arguments, string3, stringArray);
        if (string4.startsWith("??" + string3)) {
            MessageFormat messageFormat = new MessageFormat(string);
            return messageFormat.format(stringArray);
        }
        return string4;
    }
}

