/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterRegistration;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.pagesdialect.ExportFilter;
import net.sourceforge.pagesdialect.IterationListFinder;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.RecoverablePagedListHolder;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.util.MessageResolutionUtils;

public class ExportCommand {
    private Arguments arguments;
    private Element element;
    private String attributeName;
    private PagesDialect dialect;
    private String exportParam = "export";
    private String exportDivId = "exportlinkcontainer";
    private String format;
    private String exportLinkClass;
    private String i18Export;

    public ExportCommand(Arguments arguments, Element element, String string, PagesDialect pagesDialect, String string2) {
        this.arguments = arguments;
        this.element = element;
        this.attributeName = string;
        this.dialect = pagesDialect;
        if (pagesDialect.getProperties().containsKey("exportDivId")) {
            this.exportDivId = pagesDialect.getProperties().get("exportDivId");
        }
        this.format = string2;
        if ("pdf".equals(string2)) {
            this.exportLinkClass = "export-pdf";
            this.i18Export = "pagesdialect.exportPdf";
        } else if ("excel".equals(string2)) {
            this.exportLinkClass = "export-excel";
            this.i18Export = "pagesdialect.exportExcel";
        } else {
            throw new IllegalArgumentException("Export format not recognized");
        }
        HttpServletRequest httpServletRequest = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        this.readExportParam(httpServletRequest);
    }

    public void execute() {
        HttpServletRequest httpServletRequest = ((IWebContext)this.arguments.getContext()).getHttpServletRequest();
        Collection collection = this.findOriginalList(httpServletRequest);
        if (!collection.isEmpty()) {
            if (this.format.equals(httpServletRequest.getParameter(this.exportParam))) {
                Element element;
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportTypeFormatters", this.dialect.getTypeFormatters());
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportListAttr", (Object)collection);
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportListFormat", (Object)this.format);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                boolean bl = false;
                Element element2 = this.element.getAttributeValue(this.attributeName).split(",");
                int n = ((String[])element2).length;
                for (int i = 0; i < n; ++i) {
                    String string = element2[i];
                    if (string.contains(":")) {
                        String string2;
                        String string3;
                        arrayList.add(string.split(":")[0].trim());
                        String string4 = string.split(":")[1].trim();
                        if (!string4.startsWith("$")) {
                            string4 = "'" + string4 + "'";
                        }
                        if ((string3 = MessageResolutionUtils.resolveMessageForTemplate((Arguments)this.arguments, (String)(string2 = PagesDialectUtil.expressionValue(this.arguments, string4).toString()), null, (boolean)false)) == null) {
                            string3 = string2;
                        }
                        arrayList2.add(string3);
                        bl = true;
                        continue;
                    }
                    arrayList.add(string.trim());
                    arrayList2.add("");
                }
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportFields", arrayList);
                if (bl) {
                    httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportHeaders", arrayList2);
                }
                if ("table".equals((element2 = PagesDialectUtil.getContainerElement(this.element)).getOriginalName()) && "caption".equals((element = (Element)element2.getElementChildren().get(0)).getOriginalName())) {
                    Text text = (Text)element.getFirstChild();
                    httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportTitle", (Object)text.getContent());
                }
            } else {
                Element element = PagesDialectUtil.getContainerElement(this.element);
                this.addExportLink(element);
            }
        }
        this.element.removeAttribute(this.attributeName);
    }

    private Collection findOriginalList(HttpServletRequest httpServletRequest) {
        Collection collection;
        if (httpServletRequest.getAttribute("net_sourceforge_pagesdialect_PagesDialect_pagedListHolder") != null) {
            RecoverablePagedListHolder recoverablePagedListHolder = (RecoverablePagedListHolder)((Object)httpServletRequest.getAttribute("net_sourceforge_pagesdialect_PagesDialect_pagedListHolder"));
            collection = recoverablePagedListHolder.getOriginalList();
        } else {
            IterationListFinder iterationListFinder = new IterationListFinder(this.arguments, this.element);
            collection = (Collection)iterationListFinder.getIterationObject();
        }
        return collection;
    }

    private void addExportLink(Element element) {
        Element element2;
        HttpServletRequest httpServletRequest = ((IWebContext)this.arguments.getContext()).getHttpServletRequest();
        String string = httpServletRequest.getRequestURL().toString().split("\\?")[0];
        String string2 = httpServletRequest.getQueryString();
        String string3 = string + "?" + (string2 != null ? string2 + "&" : "") + this.exportParam + "=" + this.format;
        Element element3 = new Element("a");
        element3.setAttribute("class", this.exportLinkClass);
        element3.setAttribute("href", string3);
        String string4 = this.dialect.getProperties().containsKey(this.i18Export) ? PagesDialectUtil.templateMessage(this.arguments, this.dialect.getProperties().get(this.i18Export), new String[0]) : this.format;
        element3.addChild((Node)new Text(string4));
        DOMSelector dOMSelector = new DOMSelector("//div[@id=\"" + this.exportDivId + "\"]");
        List list = dOMSelector.select(element.getParent().getElementChildren());
        if (list.isEmpty()) {
            element2 = new Element("div");
            element2.setAttribute("id", this.exportDivId);
            element.getParent().insertAfter((Node)element, (Node)element2);
        } else {
            element2 = (Element)list.iterator().next();
        }
        element2.addChild((Node)element3);
    }

    private void readExportParam(HttpServletRequest httpServletRequest) {
        for (FilterRegistration filterRegistration : httpServletRequest.getServletContext().getFilterRegistrations().values()) {
            if (!filterRegistration.getClassName().equals(ExportFilter.class.getName())) continue;
            this.exportParam = filterRegistration.getInitParameter("exportRequestParameterName");
        }
    }
}

