/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import net.sourceforge.pagesdialect.PagesDialectUtil;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;

public class IterationListFinder {
    private Arguments arguments;
    private Element element;
    private String iterationExpression;
    private String itemName;
    private String iterationObjectName;
    private Object iterationObject;

    public IterationListFinder(Arguments arguments, Element element) {
        this.arguments = arguments;
        this.element = element;
        this.findIterationExpression();
        this.parseComponents();
    }

    private String findIterationExpression() {
        this.iterationExpression = PagesDialectUtil.getStandardDialectPrefix(this.arguments) + ":" + "each";
        if (!this.element.hasAttribute(this.iterationExpression)) {
            throw new TemplateProcessingException("Standard iteration attribute not found");
        }
        return this.iterationExpression;
    }

    private void parseComponents() {
        String[] stringArray = this.element.getAttributeValue(this.iterationExpression).split(":");
        this.itemName = stringArray[0].trim();
        this.iterationObjectName = stringArray[1].trim();
        this.iterationObject = PagesDialectUtil.expressionValue(this.arguments, this.iterationObjectName);
    }

    public String getIterationExpression() {
        return this.iterationExpression;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getIterationObjectName() {
        return this.iterationObjectName;
    }

    public Object getIterationObject() {
        return this.iterationObject;
    }
}

