/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sourceforge.pagesdialect.DRIDataTypeAdapter;
import net.sourceforge.pagesdialect.DynamicReportsHelper;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.TypeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPerformer {
    public static final String PDF_FORMAT = "pdf";
    public static final String EXCEL_FORMAT = "excel";
    public static final String EXPORT_LIST = "org.thymeleaf.pagesdialect.exportListAttr";
    public static final String EXPORT_LIST_FORMAT = "org.thymeleaf.pagesdialect.exportListFormat";
    public static final String EXPORT_FIELDS = "org.thymeleaf.pagesdialect.exportFields";
    public static final String EXPORT_HEADERS = "org.thymeleaf.pagesdialect.exportHeaders";
    public static final String EXPORT_TITLE = "org.thymeleaf.pagesdialect.exportTitle";
    public static final String EXPORT_TYPE_FORMATTERS = "org.thymeleaf.pagesdialect.exportTypeFormatters";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String exportParam;

    public ExportPerformer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.exportParam = string;
    }

    public boolean notExportingInProcess() {
        return this.request.getParameter(this.exportParam) == null;
    }

    public void performExport() {
        Set set = (Set)this.request.getAttribute(EXPORT_TYPE_FORMATTERS);
        String string = (String)this.request.getAttribute(EXPORT_LIST_FORMAT);
        List list = (List)this.request.getAttribute(EXPORT_FIELDS);
        List list2 = (List)this.request.getAttribute(EXPORT_HEADERS);
        List list3 = (List)this.request.getAttribute(EXPORT_LIST);
        String string2 = (String)this.request.getAttribute(EXPORT_TITLE);
        String string3 = string2 != null ? PagesDialectUtil.simplifyString(string2) : "export";
        DynamicReportsHelper dynamicReportsHelper = new DynamicReportsHelper(string, string2, string3, this.response);
        ColumnBuilder[] columnBuilderArray = new ColumnBuilder[list.size()];
        if (list3 == null || list3.isEmpty()) {
            throw new IllegalArgumentException("Export list is empty");
        }
        Object e = list3.get(0);
        for (int i = 0; i < list.size(); ++i) {
            String string4 = ((String)list.get(i)).trim();
            DRIDataType dRIDataType = this.detectType(e, string4, set, this.request);
            columnBuilderArray[i] = list2 != null ? DynamicReports.col.column((String)list2.get(i), string4, dRIDataType) : DynamicReports.col.column(string4, dRIDataType);
        }
        dynamicReportsHelper.export(list3, columnBuilderArray);
    }

    private DRIDataType detectType(Object object, String string, Set<TypeFormatter> set, HttpServletRequest httpServletRequest) {
        Class clazz = PagesDialectUtil.getPropertyClass(object.getClass(), string);
        if (clazz != null && set != null) {
            for (TypeFormatter typeFormatter : set) {
                if (!typeFormatter.getValueClass().isAssignableFrom(clazz)) continue;
                return new DRIDataTypeAdapter(typeFormatter, httpServletRequest);
            }
        }
        try {
            return DynamicReports.type.detectType(clazz);
        }
        catch (DRException dRException) {
            throw new IllegalArgumentException("Type of field -" + string + "- unknown", dRException);
        }
    }
}

