/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sourceforge.pagesdialect.IterationListPreparer;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.SortLinkCommand;
import net.sourceforge.pagesdialect.TypeFormatter;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;

public class SortCommand
extends SortLinkCommand {
    public SortCommand(Arguments arguments, Element element, String string, PagesDialect pagesDialect) {
        super(arguments, element, string, pagesDialect);
    }

    public void execute() {
        String string = this.element.getAttributeValue(this.attributeName).trim();
        Boolean bl = this.getSortType(string);
        if (bl != null) {
            List list = this.getIterableList();
            Collections.sort(list, this.getFieldComparator(string, bl));
        }
        this.addSortLink(string, bl);
        this.element.removeAttribute(this.attributeName);
    }

    private List getIterableList() {
        Element element = null;
        Element element2 = PagesDialectUtil.getContainerElement(this.element);
        String string = PagesDialectUtil.getStandardDialectPrefix(this.arguments) + ":" + "each";
        block0: for (Element element3 : element2.getElementChildren()) {
            if (element3.hasAttribute(string)) {
                element = element3;
                break;
            }
            for (Element element4 : element3.getElementChildren()) {
                if (!element4.hasAttribute(string)) continue;
                element = element4;
                break block0;
            }
        }
        if (element == null) {
            throw new TemplateProcessingException("Iteration object not found");
        }
        IterationListPreparer iterationListPreparer = new IterationListPreparer(this.arguments, element);
        return iterationListPreparer.findOrCreateIterationList().getOriginalList();
    }

    private Comparator getFieldComparator(final String string, final Boolean bl) {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Object object3 = PagesDialectUtil.getProperty(object, string);
                Object object4 = PagesDialectUtil.getProperty(object2, string);
                int n2 = n = bl != null && bl != false ? -1 : 1;
                if (object3 == null) {
                    return n * -1;
                }
                if (object4 == null) {
                    return n * 1;
                }
                if (object3 instanceof Comparable && object4 instanceof Comparable) {
                    return n * ((Comparable)object3).compareTo(object4);
                }
                if (SortCommand.this.thereIsTypeFormatterForObject(object3)) {
                    TypeFormatter typeFormatter = SortCommand.this.getTypeFormatterForObject(object3);
                    HttpServletRequest httpServletRequest = SortCommand.this.context.getHttpServletRequest();
                    DRIValueFormatter dRIValueFormatter = typeFormatter.getDRIValueFormatter(httpServletRequest);
                    String string3 = dRIValueFormatter.format(object3, null).toString();
                    String string2 = dRIValueFormatter.format(object4, null).toString();
                    Collator collator = Collator.getInstance(SortCommand.this.context.getLocale());
                    return n * collator.compare(string3, string2);
                }
                throw new TemplateProcessingException("Field does not implement Comparable");
            }
        };
    }

    private boolean thereIsTypeFormatterForObject(Object object) {
        if (this.dialect.getTypeFormatters() != null) {
            for (TypeFormatter typeFormatter : this.dialect.getTypeFormatters()) {
                Class clazz = typeFormatter.getValueClass();
                if (!clazz.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    private TypeFormatter getTypeFormatterForObject(Object object) {
        if (this.dialect.getTypeFormatters() != null) {
            for (TypeFormatter typeFormatter : this.dialect.getTypeFormatters()) {
                Class clazz = typeFormatter.getValueClass();
                if (!clazz.isInstance(object)) continue;
                return typeFormatter;
            }
        }
        throw new IllegalStateException("TypeFormatter not found for class " + object.getClass().getName());
    }
}

