/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import net.sourceforge.pagesdialect.IterationListFinder;
import net.sourceforge.pagesdialect.NavigationBarRenderer;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import org.springframework.data.domain.Page;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

public class PaginatedCommand {
    private Arguments arguments;
    private Element element;
    private String attributeName;
    private PagesDialect dialect;
    private boolean executeProcessor;
    private Page pagedList;

    public PaginatedCommand(Arguments arguments, Element element, String string, PagesDialect pagesDialect) {
        this.arguments = arguments;
        this.element = element;
        this.attributeName = string;
        this.dialect = pagesDialect;
    }

    public void execute() {
        this.parseArguments();
        if (this.executeProcessor) {
            this.findIterationObject();
            this.addNavigationBar();
        }
        this.element.removeAttribute(this.attributeName);
    }

    private void parseArguments() {
        String string = this.element.getAttributeValue(this.attributeName);
        String string2 = PagesDialectUtil.expressionValue(this.arguments, string).toString();
        this.executeProcessor = "true".equals(string2);
    }

    private void findIterationObject() {
        IterationListFinder iterationListFinder = new IterationListFinder(this.arguments, this.element);
        this.pagedList = (Page)iterationListFinder.getIterationObject();
    }

    private void addNavigationBar() {
        NavigationBarRenderer navigationBarRenderer = new NavigationBarRenderer(this.arguments, this.element, this.dialect, this.pagedList);
        navigationBarRenderer.addNavigationBar();
    }
}

