/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.pagesdialect.ExportPerformer;
import net.sourceforge.pagesdialect.IgnorableHttpServletResponse;

@WebFilter(filterName="exportFilter", urlPatterns={"/*"}, dispatcherTypes={DispatcherType.REQUEST}, initParams={@WebInitParam(name="exportRequestParameterName", value="export")})
public class ExportFilter
implements Filter {
    public static final String EXPORT_INIT_PARAMETER = "exportRequestParameterName";
    private String exportParam;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter(EXPORT_INIT_PARAMETER) == null) {
            throw new IllegalArgumentException("exportRequestParameterName init parameter in web.xml is required for ExportFilter filter.");
        }
        this.exportParam = filterConfig.getInitParameter(EXPORT_INIT_PARAMETER);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ExportPerformer exportPerformer = new ExportPerformer(httpServletRequest, httpServletResponse, this.exportParam);
        if (exportPerformer.notExportingInProcess()) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter(servletRequest, (ServletResponse)new IgnorableHttpServletResponse(httpServletResponse));
            servletResponse.reset();
            exportPerformer.performExport();
        }
    }

    public void destroy() {
    }
}

