/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.pagesdialect.IterationListPreparer;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.RecoverablePagedListHolder;
import org.springframework.beans.support.PagedListHolder;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class PaginateAttrProcessor
extends AbstractAttrProcessor {
    private PagesDialect dialect;
    private String pageParam = "page";

    public PaginateAttrProcessor(IAttributeNameProcessorMatcher iAttributeNameProcessorMatcher) {
        super(iAttributeNameProcessorMatcher);
    }

    public PaginateAttrProcessor(String string) {
        super(string);
    }

    public void setDialect(PagesDialect pagesDialect) {
        this.dialect = pagesDialect;
        if (pagesDialect.getProperties().containsKey("pageParameter")) {
            this.pageParam = pagesDialect.getProperties().get("pageParameter");
        }
    }

    public int getPrecedence() {
        return 199;
    }

    private void addResultCount(Arguments arguments, Element element, PagedListHolder pagedListHolder) {
        String string;
        Element element2 = new Element("span");
        element2.setAttribute("class", "paginate-count");
        if (pagedListHolder.getNrOfElements() == 1) {
            string = this.dialect.getProperties().containsKey("pagesdialect.oneResult") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.oneResult"), null) : "1 result";
        } else if (this.dialect.getProperties().containsKey("pagesdialect.results")) {
            Object[] objectArray = new String[]{pagedListHolder.getFirstElementOnPage() + 1 + "", pagedListHolder.getLastElementOnPage() + 1 + "", pagedListHolder.getNrOfElements() + ""};
            string = this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.results"), objectArray);
        } else {
            string = pagedListHolder.getNrOfElements() + " results";
        }
        element2.addChild((Node)new Text(string));
        element.getParent().insertAfter((Node)element, (Node)element2);
    }

    private void addNoResult(Arguments arguments, Element element) {
        Element element2 = new Element("span");
        element2.setAttribute("class", "paginate-no-result");
        String string = this.dialect.getProperties().containsKey("pagesdialect.none") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.none"), null) : "No result found";
        element2.addChild((Node)new Text(string));
        element.getParent().insertAfter((Node)element, (Node)element2);
    }

    private String getPageUrl(Arguments arguments, int n) {
        HttpServletRequest httpServletRequest = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        String string = httpServletRequest.getRequestURL().toString().split("\\?")[0];
        String string2 = httpServletRequest.getQueryString();
        string2 = string2 == null ? this.pageParam + "=" + n : (string2.contains(this.pageParam + "=") ? string2.replaceAll(this.pageParam + "=[0-9]+", this.pageParam + "=" + n) : string2 + "&" + this.pageParam + "=" + n);
        return string + "?" + string2;
    }

    private void addNavigationLinks(Arguments arguments, Element element, PagedListHolder pagedListHolder) {
        Element element2;
        String string;
        Element element3;
        Element element4 = new Element("div");
        element4.setAttribute("class", "paginate");
        if (!pagedListHolder.isFirstPage()) {
            element3 = new Element("a");
            element3.setAttribute("class", "paginate-first");
            element3.setAttribute("href", this.getPageUrl(arguments, 0));
            string = this.dialect.getProperties().containsKey("pagesdialect.first") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.first"), null) : "First";
            element3.addChild((Node)new Text(string));
            element4.addChild((Node)element3);
        }
        if (!pagedListHolder.isFirstPage()) {
            element3 = new Element("a");
            element3.setAttribute("class", "paginate-previous");
            element3.setAttribute("href", this.getPageUrl(arguments, pagedListHolder.getPage() - 1));
            string = this.dialect.getProperties().containsKey("pagesdialect.previous") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.previous"), null) : "Previous";
            element3.addChild((Node)new Text(string));
            element4.addChild((Node)element3);
        }
        element3 = new Element("span");
        element3.setAttribute("class", "paginate-page");
        Object[] objectArray = new String[]{pagedListHolder.getPage() + 1 + "", pagedListHolder.getPageCount() + ""};
        string = this.dialect.getProperties().containsKey("pagesdialect.page") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.page"), objectArray) : "Page " + objectArray[0] + " of " + (String)objectArray[1];
        element3.addChild((Node)new Text(string));
        element4.addChild((Node)element3);
        if (!pagedListHolder.isLastPage()) {
            element2 = new Element("a");
            element2.setAttribute("class", "paginate-next");
            element2.setAttribute("href", this.getPageUrl(arguments, pagedListHolder.getPage() + 1));
            string = this.dialect.getProperties().containsKey("pagesdialect.next") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.next"), null) : "Next";
            element2.addChild((Node)new Text(string));
            element4.addChild((Node)element2);
        }
        if (!pagedListHolder.isLastPage()) {
            element2 = new Element("a");
            element2.setAttribute("class", "paginate-last");
            element2.setAttribute("href", this.getPageUrl(arguments, pagedListHolder.getPageCount() - 1));
            string = this.dialect.getProperties().containsKey("pagesdialect.last") ? this.getMessage(arguments, this.dialect.getProperties().get("pagesdialect.last"), null) : "Last";
            element2.addChild((Node)new Text(string));
            element4.addChild((Node)element2);
        }
        element.getParent().insertAfter((Node)element, (Node)element4);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String string) {
        String string2 = element.getAttributeValue(string);
        int n = Integer.parseInt(StandardExpressionProcessor.processExpression((Arguments)arguments, (String)string2).toString());
        IterationListPreparer iterationListPreparer = new IterationListPreparer(arguments, element);
        RecoverablePagedListHolder recoverablePagedListHolder = iterationListPreparer.findOrCreateIterationList();
        recoverablePagedListHolder.setPageSize(n);
        IWebContext iWebContext = (IWebContext)arguments.getContext();
        if (iWebContext.getRequestParameters().containsKey((Object)this.pageParam)) {
            recoverablePagedListHolder.setPage(Integer.parseInt(((String[])iWebContext.getRequestParameters().get((Object)this.pageParam))[0]));
        }
        Element element2 = PagesDialectUtil.getContainerElement(element);
        if (recoverablePagedListHolder.getPageCount() > 1) {
            this.addNavigationLinks(arguments, element2, recoverablePagedListHolder);
        }
        if (recoverablePagedListHolder.getNrOfElements() > 0) {
            this.addResultCount(arguments, element2, recoverablePagedListHolder);
        } else {
            this.addNoResult(arguments, element2);
        }
        element.removeAttribute(string);
        return ProcessorResult.OK;
    }
}

