/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.RecoverablePagedListHolder;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class IterationListPreparer {
    public static final String PAGED_LIST_HOLDER_ATTR = "net_sourceforge_pagesdialect_PagesDialect_pagedListHolder";
    private Arguments arguments;
    private Element elementContainingIteration;

    public IterationListPreparer(Arguments arguments, Element element) {
        this.arguments = arguments;
        this.elementContainingIteration = element;
    }

    public RecoverablePagedListHolder findOrCreateIterationList() {
        String string = this.findIterationExpression(this.arguments, this.elementContainingIteration);
        String[] stringArray = this.elementContainingIteration.getAttributeValue(string).split(":");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        IWebContext iWebContext = (IWebContext)this.arguments.getContext();
        if (iWebContext.getRequestAttributes().containsKey((Object)PAGED_LIST_HOLDER_ATTR)) {
            return (RecoverablePagedListHolder)((Object)iWebContext.getRequestAttributes().get((Object)PAGED_LIST_HOLDER_ATTR));
        }
        Object object = StandardExpressionProcessor.processExpression((Arguments)this.arguments, (String)string3);
        RecoverablePagedListHolder recoverablePagedListHolder = new RecoverablePagedListHolder(this.convertToList(object));
        iWebContext.getRequestAttributes().put((Object)PAGED_LIST_HOLDER_ATTR, (Object)recoverablePagedListHolder);
        this.elementContainingIteration.setAttribute(string, string2 + " : ${#ctx.requestAttributes." + PAGED_LIST_HOLDER_ATTR + ".pageList}");
        return recoverablePagedListHolder;
    }

    private String findIterationExpression(Arguments arguments, Element element) {
        String string = PagesDialectUtil.getStandardDialectPrefix(arguments) + ":" + "each";
        if (!element.hasAttribute(string)) {
            throw new TemplateProcessingException("Standard iteration attribute not found");
        }
        return string;
    }

    private List convertToList(Object object) {
        List<Object> list;
        if (object instanceof List) {
            list = (ArrayList)object;
        } else if (object instanceof Collection) {
            list = new ArrayList((Collection)object);
        } else if (object.getClass().isArray()) {
            list = Arrays.asList(object);
        } else {
            throw new TemplateProcessingException("Iteration object not recognized");
        }
        return list;
    }
}

