/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sourceforge.pagesdialect.DRIDataTypeAdapter;
import net.sourceforge.pagesdialect.DynamicReportsHelper;
import net.sourceforge.pagesdialect.IgnorableHttpServletResponse;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.TypeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebFilter(filterName="exportFilter", urlPatterns={"/*"}, dispatcherTypes={DispatcherType.REQUEST}, initParams={@WebInitParam(name="exportRequestParameterName", value="export")})
public class ExportFilter
implements Filter {
    public static final String PDF_FORMAT = "pdf";
    public static final String EXCEL_FORMAT = "excel";
    public static final String EXPORT_INIT_PARAMETER = "exportRequestParameterName";
    public static final String EXPORT_LIST = "org.thymeleaf.pagesdialect.exportListAttr";
    public static final String EXPORT_LIST_FORMAT = "org.thymeleaf.pagesdialect.exportListFormat";
    public static final String EXPORT_FIELDS = "org.thymeleaf.pagesdialect.exportFields";
    public static final String EXPORT_HEADERS = "org.thymeleaf.pagesdialect.exportHeaders";
    public static final String EXPORT_TITLE = "org.thymeleaf.pagesdialect.exportTitle";
    public static final String EXPORT_TYPE_FORMATTERS = "org.thymeleaf.pagesdialect.exportTypeFormatters";
    private String exportParam;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter(EXPORT_INIT_PARAMETER) == null) {
            throw new IllegalArgumentException("exportRequestParameterName init parameter in web.xml is required for ExportFilter filter.");
        }
        this.exportParam = filterConfig.getInitParameter(EXPORT_INIT_PARAMETER);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.notExportingInProcess(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            filterChain.doFilter(servletRequest, (ServletResponse)new IgnorableHttpServletResponse(httpServletResponse));
            httpServletResponse.reset();
            Set set = (Set)httpServletRequest.getAttribute(EXPORT_TYPE_FORMATTERS);
            String string = (String)httpServletRequest.getAttribute(EXPORT_LIST_FORMAT);
            List list = (List)httpServletRequest.getAttribute(EXPORT_FIELDS);
            List list2 = (List)httpServletRequest.getAttribute(EXPORT_HEADERS);
            List list3 = (List)httpServletRequest.getAttribute(EXPORT_LIST);
            String string2 = (String)httpServletRequest.getAttribute(EXPORT_TITLE);
            String string3 = string2 != null ? PagesDialectUtil.simplifyString(string2) : "export";
            DynamicReportsHelper dynamicReportsHelper = new DynamicReportsHelper(string, string2, string3, httpServletResponse);
            ColumnBuilder[] columnBuilderArray = new ColumnBuilder[list.size()];
            if (list3 == null || list3.isEmpty()) {
                throw new IllegalArgumentException("Export list is empty");
            }
            Object e = list3.get(0);
            for (int i = 0; i < list.size(); ++i) {
                String string4 = ((String)list.get(i)).trim();
                DRIDataType dRIDataType = this.detectType(e, string4, set, httpServletRequest);
                columnBuilderArray[i] = list2 != null ? DynamicReports.col.column((String)list2.get(i), string4, dRIDataType) : DynamicReports.col.column(string4, dRIDataType);
            }
            dynamicReportsHelper.export(list3, columnBuilderArray);
        }
    }

    private DRIDataType detectType(Object object, String string, Set<TypeFormatter> set, HttpServletRequest httpServletRequest) {
        Class clazz = PagesDialectUtil.getPropertyClass(object.getClass(), string);
        if (clazz != null && set != null) {
            for (TypeFormatter typeFormatter : set) {
                if (!typeFormatter.getValueClass().isAssignableFrom(clazz)) continue;
                return new DRIDataTypeAdapter(typeFormatter, httpServletRequest);
            }
        }
        try {
            return DynamicReports.type.detectType(clazz);
        }
        catch (DRException dRException) {
            throw new IllegalArgumentException("Type of field -" + string + "- unknown", dRException);
        }
    }

    private boolean notExportingInProcess(ServletRequest servletRequest) {
        return servletRequest.getParameter(this.exportParam) == null;
    }

    public void destroy() {
    }
}

