/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sourceforge.pagesdialect.IterationListPreparer;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import net.sourceforge.pagesdialect.TypeFormatter;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

public class SortAttrProcessor
extends AbstractAttrProcessor {
    private PagesDialect dialect;
    private String sortParam = "sort";
    private String sortTypeParam = "sortType";

    public SortAttrProcessor(IAttributeNameProcessorMatcher iAttributeNameProcessorMatcher) {
        super(iAttributeNameProcessorMatcher);
    }

    public SortAttrProcessor(String string) {
        super(string);
    }

    public void setDialect(PagesDialect pagesDialect) {
        this.dialect = pagesDialect;
        if (pagesDialect.getProperties().containsKey("sortParameter")) {
            this.sortParam = pagesDialect.getProperties().get("sortParameter");
        }
        if (pagesDialect.getProperties().containsKey("sortTypeParameter")) {
            this.sortTypeParam = pagesDialect.getProperties().get("sortTypeParameter");
        }
    }

    public int getPrecedence() {
        return 1301;
    }

    private List getIterableList(Arguments arguments, Element element) {
        Element element2 = null;
        Element element3 = PagesDialectUtil.getContainerElement(element);
        String string = PagesDialectUtil.getStandardDialectPrefix(arguments) + ":" + "each";
        block0: for (Element element4 : element3.getElementChildren()) {
            if (element4.hasAttribute(string)) {
                element2 = element4;
                break;
            }
            for (Element element5 : element4.getElementChildren()) {
                if (!element5.hasAttribute(string)) continue;
                element2 = element5;
                break block0;
            }
        }
        if (element2 == null) {
            throw new TemplateProcessingException("Iteration object not found");
        }
        IterationListPreparer iterationListPreparer = new IterationListPreparer(arguments, element2);
        return iterationListPreparer.findOrCreateIterationList().getPageList();
    }

    private Comparator getFieldComparator(final IContext iContext, final String string, final Boolean bl) {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Object object3 = PagesDialectUtil.getProperty(object, string);
                Object object4 = PagesDialectUtil.getProperty(object2, string);
                int n2 = n = bl != null && bl != false ? -1 : 1;
                if (object3 == null) {
                    return n * -1;
                }
                if (object4 == null) {
                    return n * 1;
                }
                if (object3 instanceof Comparable && object4 instanceof Comparable) {
                    return n * ((Comparable)object3).compareTo(object4);
                }
                if (SortAttrProcessor.this.thereIsTypeFormatterForObject(object3)) {
                    TypeFormatter typeFormatter = SortAttrProcessor.this.getTypeFormatterForObject(object3);
                    HttpServletRequest httpServletRequest = ((IWebContext)iContext).getHttpServletRequest();
                    DRIValueFormatter dRIValueFormatter = typeFormatter.getDRIValueFormatter(httpServletRequest);
                    String string3 = dRIValueFormatter.format(object3, null).toString();
                    String string2 = dRIValueFormatter.format(object4, null).toString();
                    Collator collator = Collator.getInstance(iContext.getLocale());
                    return n * collator.compare(string3, string2);
                }
                throw new TemplateProcessingException("Field does not implement Comparable");
            }
        };
    }

    private boolean thereIsTypeFormatterForObject(Object object) {
        if (this.dialect.getTypeFormatters() != null) {
            for (TypeFormatter typeFormatter : this.dialect.getTypeFormatters()) {
                Class clazz = typeFormatter.getValueClass();
                if (!clazz.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    private TypeFormatter getTypeFormatterForObject(Object object) {
        if (this.dialect.getTypeFormatters() != null) {
            for (TypeFormatter typeFormatter : this.dialect.getTypeFormatters()) {
                Class clazz = typeFormatter.getValueClass();
                if (!clazz.isInstance(object)) continue;
                return typeFormatter;
            }
        }
        throw new IllegalStateException("TypeFormatter not found for class " + object.getClass().getName());
    }

    private void addSortLink(Arguments arguments, Element element, String string, String string2, Boolean bl) {
        HttpServletRequest httpServletRequest = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        String string3 = httpServletRequest.getRequestURL().toString().split("\\?")[0];
        String string4 = httpServletRequest.getQueryString();
        if (string4 != null) {
            string4 = string4.replaceAll("&?" + this.sortParam + "=[^&]*", "");
            string4 = string4.replaceAll("&?" + this.sortTypeParam + "=[^&]*", "");
        }
        string4 = string4 != null && !"".equals(string4) ? string4 + "&" : "";
        string4 = string4 + this.sortParam + "=" + string2 + "&" + this.sortTypeParam + "=" + (bl == null || bl != false ? "asc" : "desc");
        String string5 = string3 + "?" + string4;
        Element element2 = element.cloneElementNodeWithNewName((NestableNode)element, "a", false);
        element2.removeAttribute(string);
        element2.setAttribute("href", string5);
        if (bl == null) {
            element2.setAttribute("class", "sort-sortable");
        } else if (bl.booleanValue()) {
            element2.setAttribute("class", "sort-desc");
        } else {
            element2.setAttribute("class", "sort-asc");
        }
        for (String string6 : element.getAttributeMap().keySet()) {
            element.removeAttribute(string6);
        }
        for (String string6 : element.getChildren()) {
            element.removeChild((Node)string6);
        }
        element.addChild((Node)element2);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String string) {
        String string2;
        String string3 = element.getAttributeValue(string).trim();
        Boolean bl = null;
        IWebContext iWebContext = (IWebContext)arguments.getContext();
        if (iWebContext.getRequestParameters().containsKey((Object)this.sortParam) && (string2 = ((String[])iWebContext.getRequestParameters().get((Object)this.sortParam))[0]) != null && string3.equals(string2)) {
            if (iWebContext.getRequestParameters().containsKey((Object)this.sortTypeParam)) {
                bl = "desc".equals(((String[])iWebContext.getRequestParameters().get((Object)this.sortTypeParam))[0]);
            }
            List list = this.getIterableList(arguments, element);
            Collections.sort(list, this.getFieldComparator((IContext)iWebContext, string3, bl));
        }
        this.addSortLink(arguments, element, string, string3, bl);
        return ProcessorResult.OK;
    }
}

