/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pagesdialect;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterRegistration;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.pagesdialect.ExportFilter;
import net.sourceforge.pagesdialect.IterationListPreparer;
import net.sourceforge.pagesdialect.PagesDialect;
import net.sourceforge.pagesdialect.PagesDialectUtil;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.util.MessageResolutionUtils;

public class ExportAttrProcessor
extends AbstractAttrProcessor {
    private PagesDialect dialect;
    private String exportParam;
    private String exportDivId = "exportlinkcontainer";
    private String format;
    private String exportLinkClass;
    private String i18Export;

    public ExportAttrProcessor(IAttributeNameProcessorMatcher iAttributeNameProcessorMatcher) {
        super(iAttributeNameProcessorMatcher);
    }

    public ExportAttrProcessor(String string) {
        super(string);
    }

    public void setDialect(PagesDialect pagesDialect) {
        this.dialect = pagesDialect;
        if (pagesDialect.getProperties().containsKey("exportDivId")) {
            this.exportDivId = pagesDialect.getProperties().get("exportDivId");
        }
    }

    public void setFormat(String string) {
        this.format = string;
        if ("pdf".equals(string)) {
            this.exportLinkClass = "export-pdf";
            this.i18Export = "pagesdialect.exportPdf";
        } else if ("excel".equals(string)) {
            this.exportLinkClass = "export-excel";
            this.i18Export = "pagesdialect.exportExcel";
        } else {
            throw new IllegalArgumentException("Export format not recognized");
        }
    }

    public int getPrecedence() {
        return 198;
    }

    private void addExportLink(Arguments arguments, Element element) {
        Element element2;
        HttpServletRequest httpServletRequest = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        String string = httpServletRequest.getRequestURL().toString().split("\\?")[0];
        String string2 = httpServletRequest.getQueryString();
        String string3 = string + "?" + (string2 != null ? string2 + "&" : "") + this.getExportParam(httpServletRequest) + "=" + this.format;
        Element element3 = new Element("a");
        element3.setAttribute("class", this.exportLinkClass);
        element3.setAttribute("href", string3);
        String string4 = this.dialect.getProperties().containsKey(this.i18Export) ? this.getMessage(arguments, this.dialect.getProperties().get(this.i18Export), null) : this.format;
        element3.addChild((Node)new Text(string4));
        DOMSelector dOMSelector = new DOMSelector("//div[@id=\"" + this.exportDivId + "\"]");
        List list = dOMSelector.select(element.getParent().getElementChildren());
        if (list.isEmpty()) {
            element2 = new Element("div");
            element2.setAttribute("id", this.exportDivId);
            element.getParent().insertAfter((Node)element, (Node)element2);
        } else {
            element2 = (Element)list.iterator().next();
        }
        element2.addChild((Node)element3);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String string) {
        HttpServletRequest httpServletRequest = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        IterationListPreparer iterationListPreparer = new IterationListPreparer(arguments, element);
        List list = iterationListPreparer.findOrCreateIterationList().getPageList();
        if (!list.isEmpty()) {
            if (this.format.equals(httpServletRequest.getParameter(this.exportParam))) {
                Element element2;
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportTypeFormatters", this.dialect.getTypeFormatters());
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportListAttr", (Object)list);
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportListFormat", (Object)this.format);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                boolean bl = false;
                Element element3 = element.getAttributeValue(string).split(",");
                int n = ((String[])element3).length;
                for (int i = 0; i < n; ++i) {
                    String string2 = element3[i];
                    if (string2.contains(":")) {
                        arrayList.add(string2.split(":")[0].trim());
                        String string3 = string2.split(":")[1].trim();
                        String string4 = MessageResolutionUtils.resolveMessageForTemplate((Arguments)arguments, (String)string3, null, (boolean)false);
                        if (string4 == null) {
                            string4 = string3;
                        }
                        arrayList2.add(string4);
                        bl = true;
                        continue;
                    }
                    arrayList.add(string2.trim());
                    arrayList2.add("");
                }
                httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportFields", arrayList);
                if (bl) {
                    httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportHeaders", arrayList2);
                }
                if ("table".equals((element3 = PagesDialectUtil.getContainerElement(element)).getOriginalName()) && "caption".equals((element2 = (Element)element3.getElementChildren().get(0)).getOriginalName())) {
                    Text text = (Text)element2.getFirstChild();
                    httpServletRequest.setAttribute("org.thymeleaf.pagesdialect.exportTitle", (Object)text.getContent());
                }
            } else {
                Element element4 = PagesDialectUtil.getContainerElement(element);
                this.addExportLink(arguments, element4);
            }
        }
        element.removeAttribute(string);
        return ProcessorResult.OK;
    }

    private String getExportParam(HttpServletRequest httpServletRequest) {
        if (this.exportParam == null) {
            for (FilterRegistration filterRegistration : httpServletRequest.getServletContext().getFilterRegistrations().values()) {
                if (!filterRegistration.getClassName().equals(ExportFilter.class.getName())) continue;
                this.exportParam = filterRegistration.getInitParameter("exportRequestParameterName");
            }
        }
        return this.exportParam;
    }
}

