/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import java.io.Writer;
import java.util.ArrayList;

public class TextBlockWriter
extends BlockWriter {
    private ArrayList<Integer> blockColumns = new ArrayList();
    private int column = 0;

    public TextBlockWriter(Writer out) {
        super(out, " ");
    }

    @Override
    protected void startNewLine() {
        if (this.newLine) {
            this.newLine = false;
            if (!this.blockColumns.isEmpty()) {
                int blockStart = this.blockColumns.get(this.blockColumns.size() - 1);
                this.indent(blockStart);
                this.column = blockStart;
            } else {
                this.column = 0;
            }
        }
    }

    @Override
    public void println() {
        super.println();
        this.column = 0;
    }

    @Override
    public void printSpace() {
        super.print(" ");
    }

    public void indent(int count) {
        for (int i = 0; i < count; ++i) {
            this.print(this.pad);
        }
    }

    @Override
    public void clearBlocks() {
        this.blockColumns.clear();
    }

    @Override
    public void startBlock() {
        this.blockColumns.add(this.column);
    }

    @Override
    public void endBlock() {
        if (this.blockColumns.isEmpty()) {
            throw new IllegalStateException("No block to end!");
        }
        this.blockColumns.remove(this.blockColumns.size() - 1);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
        this.column += len;
    }

    @Override
    public void write(int c) {
        super.write(c);
        ++this.column;
    }

    @Override
    public void write(String s, int off, int len) {
        super.write(s, off, len);
        this.column += len;
    }
}

