/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.laconic.LaconicExplanationGenerator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class LaconicExplanationGeneratorFactory<E>
implements ExplanationGeneratorFactory<E> {
    private ExplanationGeneratorFactory<E> explanationGeneratorFactory;

    public LaconicExplanationGeneratorFactory(ExplanationGeneratorFactory<E> explanationGeneratorFactory) {
        this.explanationGeneratorFactory = explanationGeneratorFactory;
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(OWLOntology ontology) {
        return this.createExplanationGenerator(ontology, null);
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(OWLOntology ontology, ExplanationProgressMonitor<E> progressMonitor) {
        HashSet axioms = new HashSet(ontology.getLogicalAxiomCount());
        for (OWLOntology ont : ontology.getImportsClosure()) {
            axioms.addAll(ont.getLogicalAxioms());
        }
        return this.createExplanationGenerator(axioms, progressMonitor);
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(Set<? extends OWLAxiom> axioms) {
        return this.createExplanationGenerator(axioms, null);
    }

    @Override
    public ExplanationGenerator<E> createExplanationGenerator(Set<? extends OWLAxiom> axioms, ExplanationProgressMonitor<E> progressMonitor) {
        return new LaconicExplanationGenerator<E>(axioms, this.explanationGeneratorFactory, progressMonitor);
    }
}

