/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.api.ExplanationTelemetryWrapper;
import org.semanticweb.owl.explanation.api.NullExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.IsLaconicChecker;
import org.semanticweb.owl.explanation.impl.laconic.LaconicCheckerMode;
import org.semanticweb.owl.explanation.impl.laconic.LaconicExplanationGeneratorBasedOnDeltaPlus;
import org.semanticweb.owl.explanation.impl.laconic.OPlusGenerator;
import org.semanticweb.owl.explanation.impl.laconic.OPlusSplitting;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.SimpleRenderer;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class LaconicExplanationGeneratorBasedOnIncrementalOPlusWithDeltaPlusFiltering
implements ExplanationGenerator<OWLAxiom> {
    private Set<OWLAxiom> inputAxioms;
    private ExplanationGeneratorFactory<OWLAxiom> delegate;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private OWLDataFactory dataFactory = new OWLDataFactoryImpl();
    private ExplanationProgressMonitor<OWLAxiom> progressMonitor = new NullExplanationProgressMonitor<OWLAxiom>();
    private int numberOfOPlusJustificationsFound;

    public LaconicExplanationGeneratorBasedOnIncrementalOPlusWithDeltaPlusFiltering(Set<OWLAxiom> inputAxioms, EntailmentCheckerFactory<OWLAxiom> cf, ExplanationGeneratorFactory<OWLAxiom> delegate, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        this.inputAxioms = new HashSet<OWLAxiom>(inputAxioms.size());
        for (OWLAxiom in : inputAxioms) {
            this.inputAxioms.add(in.getAxiomWithoutAnnotations());
        }
        this.delegate = delegate;
        this.entailmentCheckerFactory = cf;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment, int limit) throws ExplanationException {
        final HashSet<Explanation<OWLAxiom>> preferredLaconicExplanations = new HashSet<Explanation<OWLAxiom>>();
        TelemetryTimer computeOplusTimer = new TelemetryTimer();
        TelemetryTimer computeOplusJustificationsTimer = new TelemetryTimer();
        TelemetryTimer islaconicTimer = new TelemetryTimer();
        TelemetryTimer reconstituteTimer = new TelemetryTimer();
        TelemetryTimer ispreferredCheckTimer = new TelemetryTimer();
        TelemetryTimer regularJustificationsTimer = new TelemetryTimer();
        DefaultTelemetryInfo info = new DefaultTelemetryInfo(this.getClass().getSimpleName(), new TelemetryTimer[]{computeOplusTimer, computeOplusJustificationsTimer, islaconicTimer, reconstituteTimer, ispreferredCheckTimer});
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        HashSet<Explanation<OWLAxiom>> regularJustifications = new HashSet<Explanation<OWLAxiom>>();
        try {
            boolean foundExternal;
            boolean foundNew;
            transmitter.beginTransmission((TelemetryInfo)info);
            HashSet<Object> computedExplanations = new HashSet<Object>();
            Set<Object> tmp = new HashSet();
            OPlusGenerator transformation = new OPlusGenerator(this.dataFactory, OPlusSplitting.TOP_LEVEL);
            computeOplusJustificationsTimer.start();
            int rounds = 0;
            boolean foundExternallyMaskedJustifications = false;
            do {
                if (this.progressMonitor.isCancelled()) {
                    throw new ExplanationGeneratorInterruptedException();
                }
                ++rounds;
                HashSet<OWLAxiom> lastRoundAxioms = new HashSet<OWLAxiom>();
                for (Explanation explanation : computedExplanations) {
                    for (OWLAxiom oWLAxiom : explanation.getAxioms()) {
                        if (!this.inputAxioms.contains(oWLAxiom)) continue;
                        lastRoundAxioms.add(oWLAxiom);
                    }
                }
                HashSet<OWLAxiom> workingAxioms = new HashSet<OWLAxiom>(this.inputAxioms);
                Set<OWLAxiom> set = transformation.transform(lastRoundAxioms);
                for (OWLAxiom oWLAxiom : lastRoundAxioms) {
                    if (set.contains(oWLAxiom)) continue;
                    workingAxioms.remove(oWLAxiom);
                }
                workingAxioms.addAll(set);
                Iterator gen = this.delegate.createExplanationGenerator(workingAxioms, (ExplanationProgressMonitor<OWLAxiom>)new MediatingProgresssMonitor());
                if (rounds == 1) {
                    regularJustificationsTimer.start();
                }
                tmp = gen.getExplanations((OWLAxiom)entailment);
                if (rounds == 1) {
                    regularJustificationsTimer.stop();
                }
                if (rounds == 1) {
                    System.out.println("Found " + tmp.size() + " regular justifications");
                    transmitter.recordMeasurement((TelemetryInfo)info, "number of regular justifications", (Number)tmp.size());
                    regularJustifications.addAll(tmp);
                    transmitter.recordTiming((TelemetryInfo)info, "time to find regular justifications", regularJustificationsTimer);
                }
                foundNew = computedExplanations.addAll(tmp);
                foundExternal = false;
                foundExternallyMaskedJustifications = false;
                if (foundNew) {
                    for (Explanation expl : computedExplanations) {
                        for (OWLAxiom ax2 : expl.getAxioms()) {
                            if (!this.inputAxioms.contains(ax2) || lastRoundAxioms.contains(ax2)) continue;
                            foundExternal = true;
                            if (rounds <= 1) break;
                            foundExternallyMaskedJustifications = true;
                            break;
                        }
                        if (!foundExternal) continue;
                        break;
                    }
                }
                if (!foundNew || foundExternal) continue;
                System.out.println("Early termination.");
                transmitter.recordMeasurement((TelemetryInfo)info, "early round termination", true);
                transmitter.recordMeasurement((TelemetryInfo)info, "found externally masked justifications", foundExternallyMaskedJustifications);
            } while (foundNew && foundExternal);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of compute oplus justifications rounds", (Number)rounds);
            computeOplusJustificationsTimer.stop();
            transmitter.recordTiming((TelemetryInfo)info, "time to compute oplus justifications", computeOplusJustificationsTimer);
            HashSet oplusExpls = new HashSet(computedExplanations);
            IsLaconicChecker checker = new IsLaconicChecker(this.dataFactory, this.entailmentCheckerFactory, LaconicCheckerMode.EARLY_TERMINATING);
            HashSet<Explanation<OWLAxiom>> hashSet = new HashSet<Explanation<OWLAxiom>>();
            islaconicTimer.start();
            for (Explanation explanation : oplusExpls) {
                if (this.progressMonitor.isCancelled()) {
                    throw new ExplanationGeneratorInterruptedException();
                }
                if (!checker.isLaconic(explanation)) continue;
                hashSet.add(explanation);
            }
            islaconicTimer.stop();
            transmitter.recordTiming((TelemetryInfo)info, "time to check laconic oplus justifications", islaconicTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of laconic oplus justifications", (Number)hashSet.size());
            if (hashSet.isEmpty()) {
                System.out.println("I didn't find any oplus explanations that were laconic!!!");
                System.out.println("Here's what I found:");
                ToStringRenderer.getInstance().setRenderer((OWLObjectRenderer)new DLSyntaxObjectRenderer());
                for (Explanation explanation : oplusExpls) {
                    System.out.println(explanation);
                }
                ToStringRenderer.getInstance().setRenderer((OWLObjectRenderer)new SimpleRenderer());
            }
            reconstituteTimer.start();
            Set<Explanation<OWLAxiom>> reconstitutedLaconicExpls = this.getReconstitutedExplanations(this.dataFactory, transformation, hashSet);
            reconstituteTimer.stop();
            transmitter.recordTiming((TelemetryInfo)info, "time to reconstitute justifications", reconstituteTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of reconstituted justifications", (Number)reconstitutedLaconicExpls.size());
            HashMap<Explanation, Set<OWLAxiom>> hashMap = new HashMap<Explanation, Set<OWLAxiom>>();
            ispreferredCheckTimer.start();
            HashSet<Explanation> toFilter = new HashSet<Explanation>();
            ArrayList<Explanation<OWLAxiom>> explsList = new ArrayList<Explanation<OWLAxiom>>(reconstitutedLaconicExpls);
            for (int i = 0; i < explsList.size(); ++i) {
                for (int j = i + 1; j < explsList.size(); ++j) {
                    Object oplusJ;
                    Explanation explanation = (Explanation)explsList.get(i);
                    Explanation explJ = (Explanation)explsList.get(j);
                    Set<OWLAxiom> oplusI = (Set<OWLAxiom>)hashMap.get(explanation);
                    if (oplusI == null) {
                        OPlusGenerator generator = new OPlusGenerator(this.dataFactory, OPlusSplitting.NONE);
                        oplusI = generator.transform(explanation.getAxioms());
                        hashMap.put(explanation, oplusI);
                    }
                    if ((oplusJ = (Set<OWLAxiom>)hashMap.get(explJ)) == null) {
                        OPlusGenerator oPlusGenerator = new OPlusGenerator(this.dataFactory, OPlusSplitting.NONE);
                        oplusJ = oPlusGenerator.transform(explJ.getAxioms());
                        hashMap.put(explJ, (Set<OWLAxiom>)oplusJ);
                    }
                    if (oplusI.equals(oplusJ) || !oplusI.containsAll((Collection<?>)oplusJ) && !oplusJ.containsAll(oplusI)) continue;
                    toFilter.add(explanation);
                    toFilter.add(explJ);
                }
            }
            preferredLaconicExplanations.addAll(reconstitutedLaconicExpls);
            preferredLaconicExplanations.removeAll(toFilter);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of non-check preferred laconic justifications", (Number)preferredLaconicExplanations.size());
            transmitter.recordMeasurement((TelemetryInfo)info, "number of check laconic justifications", (Number)toFilter.size());
            for (final Explanation laconicExpl : toFilter) {
                Set<OWLAxiom> set = this.getSourceAxioms(laconicExpl, transformation);
                ExplanationGenerator<OWLAxiom> explanationGenerator = this.delegate.createExplanationGenerator(set);
                Set<Explanation<OWLAxiom>> regularExpls = explanationGenerator.getExplanations((OWLAxiom)laconicExpl.getEntailment());
                try {
                    for (Explanation explanation : regularExpls) {
                        int size = preferredLaconicExplanations.size();
                        LaconicExplanationGeneratorBasedOnDeltaPlus lacGen = new LaconicExplanationGeneratorBasedOnDeltaPlus(explanation.getAxioms(), this.entailmentCheckerFactory, this.delegate, new ExplanationProgressMonitor<OWLAxiom>(){
                            private boolean cancelled = false;

                            @Override
                            public void foundExplanation(ExplanationGenerator<OWLAxiom> owlAxiomExplanationGenerator, Explanation<OWLAxiom> owlAxiomExplanation, Set<Explanation<OWLAxiom>> allFoundExplanations) {
                                System.out.println(owlAxiomExplanation);
                                if (owlAxiomExplanation.equals(laconicExpl)) {
                                    preferredLaconicExplanations.add(laconicExpl);
                                    this.cancelled = true;
                                }
                            }

                            @Override
                            public boolean isCancelled() {
                                return this.cancelled;
                            }
                        });
                        Set<Explanation<OWLAxiom>> deltaPlusGeneratedExpls = lacGen.getExplanations((OWLAxiom)laconicExpl.getEntailment());
                        if (preferredLaconicExplanations.size() == size) continue;
                    }
                }
                catch (ExplanationGeneratorInterruptedException e) {
                    System.out.println("Early termination");
                }
            }
            ispreferredCheckTimer.stop();
            HashSet<Explanation<Explanation>> progressFound = new HashSet<Explanation<Explanation>>();
            for (Explanation explanation : preferredLaconicExplanations) {
                progressFound.add(explanation);
                this.progressMonitor.foundExplanation(this, explanation, progressFound);
            }
            transmitter.recordTiming((TelemetryInfo)info, "time to check preferred laconic justifications", ispreferredCheckTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of preferred laconic justifications", (Number)preferredLaconicExplanations.size());
        }
        finally {
            transmitter.recordMeasurement((TelemetryInfo)info, "number of oplus justifications", (Number)this.numberOfOPlusJustificationsFound);
            transmitter.endTransmission((TelemetryInfo)info);
        }
        this.recordJustifications(regularJustifications, "regularjustifications");
        return preferredLaconicExplanations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordJustifications(Set<Explanation<OWLAxiom>> expls, String name) {
        DefaultTelemetryInfo info = new DefaultTelemetryInfo(name, new TelemetryTimer[0]);
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        try {
            transmitter.beginTransmission((TelemetryInfo)info);
            for (Explanation<OWLAxiom> expl : expls) {
                transmitter.recordObject((TelemetryInfo)info, "justification", "", (Object)new ExplanationTelemetryWrapper(expl));
            }
        }
        finally {
            transmitter.endTransmission((TelemetryInfo)info);
        }
    }

    private Set<Explanation<OWLAxiom>> getReconstitutedExplanations(OWLDataFactory dataFactory, OPlusGenerator transformation, Set<Explanation<OWLAxiom>> laconicExplanations) {
        HashSet<Explanation<OWLAxiom>> reconstitutedLaconicExpls = new HashSet<Explanation<OWLAxiom>>();
        for (Explanation<OWLAxiom> expl : laconicExplanations) {
            reconstitutedLaconicExpls.addAll(this.getReconstitutedExplanations(expl, transformation, dataFactory));
        }
        return reconstitutedLaconicExpls;
    }

    private Set<OWLAxiom> getSourceAxioms(Explanation<OWLAxiom> expl, OPlusGenerator oPlusGenerator) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : expl.getAxioms()) {
            Set<OWLAxiom> sourceAxioms = oPlusGenerator.getAxiom2SourceMap().get(ax);
            if (sourceAxioms == null) continue;
            result.addAll(sourceAxioms);
        }
        return result;
    }

    private Set<Explanation<OWLAxiom>> getReconstitutedExplanations(Explanation<OWLAxiom> expl, OPlusGenerator oPlusGenerator, OWLDataFactory dataFactory) {
        HashSet<OWLAxiom> nonSubClassOfAxioms = new HashSet<OWLAxiom>();
        HashSet<OWLSubClassOfAxiom> uniqueSourceSubClassAxioms = new HashSet<OWLSubClassOfAxiom>();
        HashSet<OWLSubClassOfAxiom> reconstitutedAxioms = new HashSet<OWLSubClassOfAxiom>();
        HashSet<OWLAxiom> reconstitutedAxiomSourcesWithMultipleSources = new HashSet<OWLAxiom>();
        HashSet sameSourceAxiomSources = new HashSet();
        OPlusGenerator strictOPlusGenerator = new OPlusGenerator(dataFactory, OPlusSplitting.NONE);
        Set<OWLAxiom> strictOPlus = strictOPlusGenerator.transform(this.getSourceAxioms(expl, oPlusGenerator));
        for (OWLAxiom explAx : expl.getAxioms()) {
            if (explAx instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)explAx;
                Set<OWLAxiom> sameSourceAxioms = oPlusGenerator.getSameSourceAxioms((OWLAxiom)sca, expl.getAxioms());
                if (!sameSourceAxioms.isEmpty()) {
                    HashSet<OWLClassExpression> superClassConjuncts = new HashSet<OWLClassExpression>();
                    HashSet<OWLClassExpression> subClassDisjuncts = new HashSet<OWLClassExpression>();
                    for (OWLAxiom ax : sameSourceAxioms) {
                        if (!(ax instanceof OWLSubClassOfAxiom)) continue;
                        OWLSubClassOfAxiom sameSourceSCA = (OWLSubClassOfAxiom)ax;
                        superClassConjuncts.addAll(sameSourceSCA.getSuperClass().asConjunctSet());
                        subClassDisjuncts.addAll(sameSourceSCA.getSubClass().asDisjunctSet());
                        if (!oPlusGenerator.hasMultipleSources(ax)) continue;
                        reconstitutedAxiomSourcesWithMultipleSources.add(ax);
                    }
                    subClassDisjuncts.addAll(sca.getSubClass().asDisjunctSet());
                    superClassConjuncts.addAll(sca.getSuperClass().asConjunctSet());
                    OWLSubClassOfAxiom mergedAxiom = this.createSubClassAxiom(dataFactory, subClassDisjuncts, superClassConjuncts);
                    if (!strictOPlus.contains(mergedAxiom)) continue;
                    reconstitutedAxioms.add(mergedAxiom);
                    oPlusGenerator.addSources((OWLAxiom)mergedAxiom, oPlusGenerator.getSources(explAx));
                    continue;
                }
                uniqueSourceSubClassAxioms.add(sca);
                continue;
            }
            nonSubClassOfAxioms.add(explAx);
        }
        if (reconstitutedAxioms.isEmpty()) {
            return Collections.singleton(expl);
        }
        HashSet<OWLAxiom> pool = new HashSet<OWLAxiom>();
        pool.addAll(nonSubClassOfAxioms);
        pool.addAll(uniqueSourceSubClassAxioms);
        pool.addAll(reconstitutedAxioms);
        pool.addAll(reconstitutedAxiomSourcesWithMultipleSources);
        if (reconstitutedAxiomSourcesWithMultipleSources.isEmpty()) {
            return Collections.singleton(new Explanation<OWLAxiom>(expl.getEntailment(), pool));
        }
        ExplanationGenerator<OWLAxiom> expGen = this.delegate.createExplanationGenerator(pool);
        return expGen.getExplanations(expl.getEntailment());
    }

    private OWLSubClassOfAxiom createSubClassAxiom(OWLDataFactory dataFactory, Set<OWLClassExpression> subClassDisjuncts, Set<OWLClassExpression> superClassConjuncts) {
        Object mergedSubClass = subClassDisjuncts.size() == 1 ? subClassDisjuncts.iterator().next() : dataFactory.getOWLObjectUnionOf(subClassDisjuncts);
        Object mergedSuperClass = superClassConjuncts.size() == 1 ? superClassConjuncts.iterator().next() : dataFactory.getOWLObjectIntersectionOf(superClassConjuncts);
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)mergedSubClass, (OWLClassExpression)mergedSuperClass);
    }

    private class MediatingProgresssMonitor
    implements ExplanationProgressMonitor<OWLAxiom> {
        private MediatingProgresssMonitor() {
        }

        @Override
        public void foundExplanation(ExplanationGenerator<OWLAxiom> owlAxiomExplanationGenerator, Explanation<OWLAxiom> owlAxiomExplanation, Set<Explanation<OWLAxiom>> allFoundExplanations) {
            System.out.println("\tFound " + allFoundExplanations.size() + " OPlus Justifications");
            LaconicExplanationGeneratorBasedOnIncrementalOPlusWithDeltaPlusFiltering.this.numberOfOPlusJustificationsFound = allFoundExplanations.size();
            if (this.isCancelled()) {
                throw new ExplanationGeneratorInterruptedException();
            }
        }

        @Override
        public boolean isCancelled() {
            return LaconicExplanationGeneratorBasedOnIncrementalOPlusWithDeltaPlusFiltering.this.progressMonitor.isCancelled();
        }
    }
}

