/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.hst;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTree;
import org.semanticweb.owlapi.model.OWLAxiom;

public class HittingSetTreeNode<E> {
    private OWLAxiom parentEdgeLabel;
    private HittingSetTreeNode<E> parentNode;
    private Explanation<E> explanation;
    private List<HittingSetTreeNode<E>> children = new ArrayList<HittingSetTreeNode<E>>();
    private List<OWLAxiom> edgeLabels = new ArrayList<OWLAxiom>();
    private boolean reuse;

    public HittingSetTreeNode(HittingSetTree<E> tree, OWLAxiom parentEdgeLabel, HittingSetTreeNode<E> parentNode, Explanation<E> explanation, boolean reuse) {
        this.parentEdgeLabel = parentEdgeLabel;
        this.parentNode = parentNode;
        this.explanation = explanation;
        this.reuse = reuse;
    }

    public HittingSetTreeNode(HittingSetTree<E> tree, Explanation<E> explanation) {
        this.explanation = explanation;
    }

    public HittingSetTreeNode(HittingSetTree<E> tree, OWLAxiom parentEdgeLabel, HittingSetTreeNode<E> parentNode, boolean reuse) {
        this.parentEdgeLabel = parentEdgeLabel;
        this.parentNode = parentNode;
        this.reuse = reuse;
    }

    public boolean isReuse() {
        return this.reuse;
    }

    public Explanation<E> getExplanation() {
        return this.explanation;
    }

    public List<HittingSetTreeNode<E>> getChildren() {
        return this.children;
    }

    public void addChild(OWLAxiom edgeLabel, HittingSetTreeNode<E> node) {
        this.edgeLabels.add(edgeLabel);
        this.children.add(node);
    }

    public List<OWLAxiom> getPathToRoot() {
        ArrayList<OWLAxiom> path = new ArrayList<OWLAxiom>();
        this.getPathToRoot(this, path);
        return path;
    }

    private void getPathToRoot(HittingSetTreeNode<E> node, List<OWLAxiom> path) {
        OWLAxiom parentLabel = node.parentEdgeLabel;
        if (parentLabel != null) {
            path.add(0, parentLabel);
            this.getPathToRoot(node.parentNode, path);
        }
    }

    public Object getParentEdgeLabel() {
        return this.parentEdgeLabel;
    }
}

