/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.hst;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.impl.blackbox.hst.ExplanationGeneratorMediator;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTree;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTreeConstructionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTreeNode;
import org.semanticweb.owlapi.model.OWLAxiom;

public class BreadthFirstStrategy<E>
implements HittingSetTreeConstructionStrategy<E> {
    private boolean rebuilt = false;

    public void start(HittingSetTree<E> hittingSetTree) {
    }

    @Override
    public void constructTree(HittingSetTree<E> hittingSetTree, int limit, ExplanationGeneratorMediator<E> handler) {
        if (hittingSetTree.getProgressMonitor().isCancelled()) {
            throw new ExplanationGeneratorInterruptedException();
        }
        ArrayList<HittingSetTreeNode<HittingSetTreeNode<E>>> queue = new ArrayList<HittingSetTreeNode<HittingSetTreeNode<E>>>();
        queue.add(hittingSetTree.getRoot());
        boolean b = true;
        while (b) {
            b = this.buildHittingSetTree(hittingSetTree, limit, handler, queue);
            if (!hittingSetTree.getProgressMonitor().isCancelled()) continue;
            throw new ExplanationGeneratorInterruptedException();
        }
    }

    public boolean buildHittingSetTree(HittingSetTree<E> hittingSetTree, int limit, ExplanationGeneratorMediator<E> handler, List<HittingSetTreeNode<E>> queue) {
        while (!queue.isEmpty()) {
            if (hittingSetTree.getProgressMonitor().isCancelled()) {
                throw new ExplanationGeneratorInterruptedException();
            }
            HittingSetTreeNode<E> currentNode = queue.remove(0);
            Set<OWLAxiom> nodeAxioms = currentNode.getExplanation().getAxioms();
            for (OWLAxiom ax : nodeAxioms) {
                if (hittingSetTree.getProgressMonitor().isCancelled()) {
                    throw new ExplanationGeneratorInterruptedException();
                }
                HashSet<OWLAxiom> pathContents = new HashSet<OWLAxiom>(currentNode.getPathToRoot());
                pathContents.add(ax);
                if (hittingSetTree.containsClosedPath(pathContents) || !hittingSetTree.addExploredPath(pathContents)) continue;
                for (OWLAxiom pathAx : pathContents) {
                    handler.removeAxiom(pathAx);
                }
                Explanation<E> expl = this.getNonIntersectingExplanation(hittingSetTree, pathContents, queue);
                boolean reuse = true;
                if (expl == null) {
                    reuse = false;
                    hittingSetTree.incrementNumberOfNodesWithCallsToFindOne();
                    expl = handler.generateExplanation(currentNode.getExplanation().getEntailment());
                    hittingSetTree.addExplanation(expl);
                    if (hittingSetTree.getExplanations().size() == limit) {
                        return false;
                    }
                } else {
                    hittingSetTree.incrementNumberOfNodesWithReusedJustifications();
                }
                if (!expl.isEmpty()) {
                    HittingSetTreeNode<E> hittingSetTreeNode = new HittingSetTreeNode<E>(hittingSetTree, ax, currentNode, expl, reuse);
                    currentNode.addChild(ax, hittingSetTreeNode);
                    queue.add(hittingSetTreeNode);
                } else {
                    hittingSetTree.addClosedPath(new HashSet<OWLAxiom>(pathContents));
                }
                for (OWLAxiom pathAx : pathContents) {
                    handler.addAxiom(pathAx);
                }
            }
        }
        return false;
    }

    private Explanation<E> getNonIntersectingExplanation(HittingSetTree<E> hittingSetTree, Set<OWLAxiom> pathContents, List<HittingSetTreeNode<E>> queue) {
        List<Explanation<E>> explanations = hittingSetTree.getSortedExplanations();
        int pathsToExploreMinimum = Integer.MAX_VALUE;
        Explanation<E> currentCandidate = null;
        for (Explanation<E> existingExpl : explanations) {
            boolean overlaps = false;
            for (OWLAxiom pathAx : pathContents) {
                if (!existingExpl.contains(pathAx)) continue;
                overlaps = true;
                break;
            }
            if (overlaps) continue;
            return existingExpl;
        }
        return currentCandidate;
    }

    public void finish(HittingSetTree<E> hittingSetTree) {
    }
}

