/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owlapi.model.OWLAxiom;

public class DynamicSlidingWindowContractionStrategy
implements ContractionStrategy {
    private final int windowSize;
    private int count;

    public DynamicSlidingWindowContractionStrategy() {
        this.windowSize = 20;
    }

    @Override
    public Set<OWLAxiom> doPruning(Set<OWLAxiom> axioms, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        int roundWindowSize;
        this.count = 0;
        HashSet<OWLAxiom> contraction = new HashSet<OWLAxiom>(axioms);
        int lastContractionSize = -1;
        while ((roundWindowSize = contraction.size() / 20) >= this.windowSize) {
            if (lastContractionSize == contraction.size()) {
                roundWindowSize = contraction.size() / 40;
            }
            lastContractionSize = contraction.size();
            this.doFastPruning(checker, contraction, roundWindowSize);
        }
        this.doFastPruning(checker, contraction, this.windowSize);
        HashSet<OWLAxiom> contractionCopy = new HashSet<OWLAxiom>(contraction);
        for (OWLAxiom ax : contractionCopy) {
            contraction.remove(ax);
            ++this.count;
            if (checker.isEntailed(contraction)) continue;
            contraction.add(ax);
        }
        return contraction;
    }

    @Override
    public int getNumberOfSteps() {
        return this.count;
    }

    private void doFastPruning(EntailmentChecker checker, Set<OWLAxiom> contraction, int roundWindowSize) {
        ArrayList<OWLAxiom> axiomList = new ArrayList<OWLAxiom>(contraction);
        int windowCount = axiomList.size() / roundWindowSize;
        for (int windowIndex = 0; windowIndex < windowCount; ++windowIndex) {
            int start = windowIndex * roundWindowSize;
            int end = start + roundWindowSize;
            List cur = axiomList.subList(start, end);
            contraction.removeAll(cur);
            ++this.count;
            if (checker.isEntailed(contraction)) continue;
            contraction.addAll(cur);
        }
    }
}

