/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class OptimisedModuleExtractor {
    private OWLOntology ontology;
    Set<OWLAxiom> workingAxioms;
    private int initialSize;

    public OptimisedModuleExtractor(OWLOntology ontology) {
        this.ontology = ontology;
        this.initialSize = ontology.getLogicalAxiomCount();
    }

    public Set<OWLAxiom> getModule(Set<OWLEntity> sig) {
        this.workingAxioms = new HashSet<OWLAxiom>(this.initialSize);
        for (AxiomType axiomType : AxiomType.AXIOM_TYPES) {
            if (!axiomType.isLogical()) continue;
            this.workingAxioms.addAll(this.ontology.getAxioms(axiomType));
        }
        LocalityClass localityClass = LocalityClass.BOTTOM_BOTTOM;
        int size = 0;
        int count = 0;
        SyntacticLocalityEvaluator sle;
        Set<OWLAxiom> module;
        while ((module = this.extractModule(sig, this.workingAxioms, sle = new SyntacticLocalityEvaluator(localityClass))).size() != size) {
            ++count;
            size = module.size();
            localityClass = localityClass == LocalityClass.TOP_TOP ? LocalityClass.BOTTOM_BOTTOM : LocalityClass.TOP_TOP;
            this.workingAxioms = module;
        }
        return module;
    }

    private Set<OWLAxiom> extractModule(Set<OWLEntity> sig, Set<OWLAxiom> workingAxioms, SyntacticLocalityEvaluator sle) {
        HashSet<OWLAxiom> globals = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> module = new HashSet<OWLAxiom>();
        HashSet<OWLEntity> workingSignature = new HashSet<OWLEntity>(sig);
        for (OWLAxiom alpha : workingAxioms) {
            if (sle.isLocal(alpha, Collections.emptySet())) continue;
            globals.add(alpha);
        }
        for (OWLAxiom axiom : globals) {
            this.addNonLocal(axiom, sig, module, workingSignature, new LinkedList<OWLEntity>(), sle);
        }
        LinkedList<OWLEntity> queue = new LinkedList<OWLEntity>(workingSignature);
        while (!queue.isEmpty()) {
            OWLEntity entity = (OWLEntity)queue.poll();
            workingSignature.remove(entity);
            for (OWLAxiom alpha : this.ontology.getReferencingAxioms(entity)) {
                if (!workingAxioms.contains(alpha) || sle.isLocal(alpha, sig)) continue;
                boolean b = this.addNonLocal(alpha, sig, module, workingSignature, queue, sle);
            }
        }
        return module;
    }

    private boolean addNonLocal(OWLAxiom alpha, Set<OWLEntity> sig, Set<OWLAxiom> module, Set<OWLEntity> workingSignature, Queue<OWLEntity> workingQueue, SyntacticLocalityEvaluator sle) {
        if (module.add(alpha)) {
            Set alphaSig = alpha.getSignature();
            for (OWLEntity entity : alphaSig) {
                if (sig.contains(entity) || !workingSignature.add(entity)) continue;
                workingQueue.add(entity);
            }
            sig.addAll(alphaSig);
            return true;
        }
        return false;
    }
}

