/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.util.Polarity;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class DeltaTransformationUnfolder {
    private OWLDataFactory dataFactory;
    private Map<OWLClass, Set<OWLClassExpression>> posName2ClassExpressionMap = new HashMap<OWLClass, Set<OWLClassExpression>>();
    private Map<OWLClass, Set<OWLClassExpression>> negName2ClassExpressionMap = new HashMap<OWLClass, Set<OWLClassExpression>>();

    public DeltaTransformationUnfolder(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public Set<OWLAxiom> getUnfolded(Set<OWLAxiom> axioms, Set<OWLEntity> signature) {
        this.posName2ClassExpressionMap.clear();
        this.negName2ClassExpressionMap.clear();
        HashSet<OWLAxiom> toUnfold = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            if (ax instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                OWLClassExpression subCls = sca.getSubClass();
                OWLClassExpression superCls = sca.getSuperClass();
                if (this.isFreshName(subCls, signature) && !this.isFreshName(superCls, signature)) {
                    DeltaTransformationUnfolder.addToIndex(subCls.asOWLClass(), superCls, this.posName2ClassExpressionMap);
                    continue;
                }
                if (this.isFreshName(superCls, signature) && !this.isFreshName(subCls, signature)) {
                    DeltaTransformationUnfolder.addToIndex(superCls.asOWLClass(), subCls, this.negName2ClassExpressionMap);
                    continue;
                }
                toUnfold.add(ax);
                continue;
            }
            toUnfold.add(ax);
        }
        HashSet<OWLAxiom> unfolded = new HashSet<OWLAxiom>();
        AxiomUnfolder axiomUnfolder = new AxiomUnfolder();
        for (OWLAxiom ax : toUnfold) {
            unfolded.add((OWLAxiom)ax.accept((OWLAxiomVisitorEx)axiomUnfolder));
        }
        return unfolded;
    }

    private static void addToIndex(OWLClass key, OWLClassExpression val, Map<OWLClass, Set<OWLClassExpression>> map) {
        Set<OWLClassExpression> vals = map.get(key);
        if (vals == null) {
            vals = new HashSet<OWLClassExpression>();
            map.put(key, vals);
        }
        vals.add(val);
    }

    private boolean isFreshName(OWLClassExpression ce, Set<OWLEntity> signature) {
        return !ce.isOWLThing() && !ce.isOWLNothing() && !ce.isAnonymous() && !signature.contains(ce.asOWLClass());
    }

    private OWLClassExpression getNamedClassExpression(Polarity pol, OWLClass namingClass) {
        if (pol.isPositive()) {
            Set<OWLClassExpression> ops = this.posName2ClassExpressionMap.get(namingClass);
            if (ops != null) {
                if (ops.size() > 1) {
                    return this.dataFactory.getOWLObjectIntersectionOf(ops);
                }
                return ops.iterator().next();
            }
        } else {
            Set<OWLClassExpression> ops = this.negName2ClassExpressionMap.get(namingClass);
            if (ops != null) {
                if (ops.size() > 1) {
                    return this.dataFactory.getOWLObjectUnionOf(ops);
                }
                return ops.iterator().next();
            }
        }
        return null;
    }

    private class ClassExpressionUnfolder
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        private Polarity currentPolarity = Polarity.POSITIVE;

        private ClassExpressionUnfolder(Polarity currentPolarity) {
            this.currentPolarity = currentPolarity;
        }

        public OWLClassExpression visit(OWLClass owlClass) {
            OWLClassExpression namedExpression = DeltaTransformationUnfolder.this.getNamedClassExpression(this.currentPolarity, owlClass);
            if (namedExpression != null) {
                if (namedExpression.isAnonymous()) {
                    return (OWLClassExpression)namedExpression.accept((OWLClassExpressionVisitorEx)this);
                }
                return namedExpression;
            }
            return owlClass;
        }

        private Set<OWLClassExpression> getUnfoldedExpressions(Set<OWLClassExpression> classExpressionSet) {
            HashSet<OWLClassExpression> unfolded = new HashSet<OWLClassExpression>();
            for (OWLClassExpression ce : classExpressionSet) {
                unfolded.add((OWLClassExpression)ce.accept((OWLClassExpressionVisitorEx)this));
            }
            return unfolded;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf owlObjectIntersectionOf) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectIntersectionOf(this.getUnfoldedExpressions(owlObjectIntersectionOf.getOperands()));
        }

        public OWLClassExpression visit(OWLObjectUnionOf owlObjectUnionOf) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectUnionOf(this.getUnfoldedExpressions(owlObjectUnionOf.getOperands()));
        }

        public OWLClassExpression visit(OWLObjectComplementOf owlObjectComplementOf) {
            this.currentPolarity = this.currentPolarity.getReversePolarity();
            OWLClassExpression op = (OWLClassExpression)owlObjectComplementOf.getOperand().accept((OWLClassExpressionVisitorEx)this);
            this.currentPolarity = this.currentPolarity.getReversePolarity();
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectComplementOf(op);
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom owlObjectSomeValuesFrom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)owlObjectSomeValuesFrom.getProperty(), (OWLClassExpression)((OWLClassExpression)owlObjectSomeValuesFrom.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom owlObjectAllValuesFrom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)owlObjectAllValuesFrom.getProperty(), (OWLClassExpression)((OWLClassExpression)owlObjectAllValuesFrom.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public OWLClassExpression visit(OWLObjectHasValue owlObjectHasValue) {
            return owlObjectHasValue;
        }

        public OWLClassExpression visit(OWLObjectMinCardinality owlObjectMinCardinality) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectMinCardinality(owlObjectMinCardinality.getCardinality(), (OWLObjectPropertyExpression)owlObjectMinCardinality.getProperty(), (OWLClassExpression)((OWLClassExpression)owlObjectMinCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public OWLClassExpression visit(OWLObjectExactCardinality owlObjectExactCardinality) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectExactCardinality(owlObjectExactCardinality.getCardinality(), (OWLObjectPropertyExpression)owlObjectExactCardinality.getProperty(), (OWLClassExpression)((OWLClassExpression)owlObjectExactCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality owlObjectMaxCardinality) {
            this.currentPolarity = this.currentPolarity.getReversePolarity();
            OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)owlObjectMaxCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this);
            this.currentPolarity = this.currentPolarity.getReversePolarity();
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectMaxCardinality(owlObjectMaxCardinality.getCardinality(), (OWLObjectPropertyExpression)owlObjectMaxCardinality.getProperty(), filler);
        }

        public OWLClassExpression visit(OWLObjectHasSelf owlObjectHasSelf) {
            return owlObjectHasSelf;
        }

        public OWLClassExpression visit(OWLObjectOneOf owlObjectOneOf) {
            return owlObjectOneOf;
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom owlDataSomeValuesFrom) {
            return owlDataSomeValuesFrom;
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom owlDataAllValuesFrom) {
            return owlDataAllValuesFrom;
        }

        public OWLClassExpression visit(OWLDataHasValue owlDataHasValue) {
            return owlDataHasValue;
        }

        public OWLClassExpression visit(OWLDataMinCardinality owlDataMinCardinality) {
            return owlDataMinCardinality;
        }

        public OWLClassExpression visit(OWLDataExactCardinality owlDataExactCardinality) {
            return owlDataExactCardinality;
        }

        public OWLClassExpression visit(OWLDataMaxCardinality owlDataMaxCardinality) {
            return owlDataMaxCardinality;
        }
    }

    private class AxiomUnfolder
    implements OWLAxiomVisitorEx<OWLAxiom> {
        private ClassExpressionUnfolder positiveClassExpressionUnfolder;
        private ClassExpressionUnfolder negativeClassExpressionUnfolder;

        private AxiomUnfolder() {
            this.positiveClassExpressionUnfolder = new ClassExpressionUnfolder(Polarity.POSITIVE);
            this.negativeClassExpressionUnfolder = new ClassExpressionUnfolder(Polarity.NEGATIVE);
        }

        private OWLClassExpression unfold(OWLClassExpression ce, Polarity polarity) {
            ClassExpressionUnfolder classExpressionUnfolder = polarity.isPositive() ? this.positiveClassExpressionUnfolder : this.negativeClassExpressionUnfolder;
            return (OWLClassExpression)ce.accept((OWLClassExpressionVisitorEx)classExpressionUnfolder);
        }

        private Set<OWLClassExpression> unfold(Set<OWLClassExpression> classExpressions, Polarity polarity) {
            HashSet<OWLClassExpression> unfolded = new HashSet<OWLClassExpression>();
            for (OWLClassExpression ce : classExpressions) {
                if (polarity.isPositive()) {
                    unfolded.add((OWLClassExpression)ce.accept((OWLClassExpressionVisitorEx)this.positiveClassExpressionUnfolder));
                    continue;
                }
                unfolded.add((OWLClassExpression)ce.accept((OWLClassExpressionVisitorEx)this.negativeClassExpressionUnfolder));
            }
            return unfolded;
        }

        public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLSubClassOfAxiom(this.unfold(axiom.getSubClass(), Polarity.NEGATIVE), this.unfold(axiom.getSuperClass(), Polarity.POSITIVE));
        }

        public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom owlNegativeObjectPropertyAssertionAxiom) {
            return owlNegativeObjectPropertyAssertionAxiom;
        }

        public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom owlAsymmetricObjectPropertyAxiom) {
            return owlAsymmetricObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom owlReflexiveObjectPropertyAxiom) {
            return owlReflexiveObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLDisjointClassesAxiom owlDisjointClassesAxiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLDisjointClassesAxiom(this.unfold(owlDisjointClassesAxiom.getClassExpressions(), Polarity.POSITIVE));
        }

        public OWLAxiom visit(OWLDataPropertyDomainAxiom owlDataPropertyDomainAxiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)owlDataPropertyDomainAxiom.getProperty(), owlDataPropertyDomainAxiom.getDomain());
        }

        public OWLAxiom visit(OWLObjectPropertyDomainAxiom owlObjectPropertyDomainAxiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)owlObjectPropertyDomainAxiom.getProperty(), owlObjectPropertyDomainAxiom.getDomain());
        }

        public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom owlEquivalentObjectPropertiesAxiom) {
            return owlEquivalentObjectPropertiesAxiom;
        }

        public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom owlNegativeDataPropertyAssertionAxiom) {
            return owlNegativeDataPropertyAssertionAxiom;
        }

        public OWLAxiom visit(OWLDifferentIndividualsAxiom owlDifferentIndividualsAxiom) {
            return owlDifferentIndividualsAxiom;
        }

        public OWLAxiom visit(OWLDisjointDataPropertiesAxiom owlDisjointDataPropertiesAxiom) {
            return owlDisjointDataPropertiesAxiom;
        }

        public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom owlDisjointObjectPropertiesAxiom) {
            return owlDisjointObjectPropertiesAxiom;
        }

        public OWLAxiom visit(OWLObjectPropertyRangeAxiom owlObjectPropertyRangeAxiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)owlObjectPropertyRangeAxiom.getProperty(), this.unfold((OWLClassExpression)owlObjectPropertyRangeAxiom.getRange(), Polarity.POSITIVE));
        }

        public OWLAxiom visit(OWLObjectPropertyAssertionAxiom owlObjectPropertyAssertionAxiom) {
            return owlObjectPropertyAssertionAxiom;
        }

        public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom owlFunctionalObjectPropertyAxiom) {
            return owlFunctionalObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLSubObjectPropertyOfAxiom owlSubObjectPropertyOfAxiom) {
            return owlSubObjectPropertyOfAxiom;
        }

        public OWLAxiom visit(OWLDisjointUnionAxiom owlDisjointUnionAxiom) {
            return owlDisjointUnionAxiom;
        }

        public OWLAxiom visit(OWLDeclarationAxiom owlDeclarationAxiom) {
            return owlDeclarationAxiom;
        }

        public OWLAxiom visit(OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom) {
            return owlAnnotationAssertionAxiom;
        }

        public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom owlSymmetricObjectPropertyAxiom) {
            return owlSymmetricObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLDataPropertyRangeAxiom owlDataPropertyRangeAxiom) {
            return owlDataPropertyRangeAxiom;
        }

        public OWLAxiom visit(OWLFunctionalDataPropertyAxiom owlFunctionalDataPropertyAxiom) {
            return owlFunctionalDataPropertyAxiom;
        }

        public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom owlEquivalentDataPropertiesAxiom) {
            return owlEquivalentDataPropertiesAxiom;
        }

        public OWLAxiom visit(OWLClassAssertionAxiom owlClassAssertionAxiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLClassAssertionAxiom(this.unfold(owlClassAssertionAxiom.getClassExpression(), Polarity.POSITIVE), owlClassAssertionAxiom.getIndividual());
        }

        public OWLAxiom visit(OWLEquivalentClassesAxiom owlEquivalentClassesAxiom) {
            return DeltaTransformationUnfolder.this.dataFactory.getOWLEquivalentClassesAxiom(this.unfold(owlEquivalentClassesAxiom.getClassExpressions(), Polarity.POSITIVE));
        }

        public OWLAxiom visit(OWLDataPropertyAssertionAxiom owlDataPropertyAssertionAxiom) {
            return owlDataPropertyAssertionAxiom;
        }

        public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom owlTransitiveObjectPropertyAxiom) {
            return owlTransitiveObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom owlIrreflexiveObjectPropertyAxiom) {
            return owlIrreflexiveObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLSubDataPropertyOfAxiom owlSubDataPropertyOfAxiom) {
            return owlSubDataPropertyOfAxiom;
        }

        public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom owlInverseFunctionalObjectPropertyAxiom) {
            return owlInverseFunctionalObjectPropertyAxiom;
        }

        public OWLAxiom visit(OWLSameIndividualAxiom owlSameIndividualAxiom) {
            return owlSameIndividualAxiom;
        }

        public OWLAxiom visit(OWLSubPropertyChainOfAxiom owlSubPropertyChainOfAxiom) {
            return owlSubPropertyChainOfAxiom;
        }

        public OWLAxiom visit(OWLInverseObjectPropertiesAxiom owlInverseObjectPropertiesAxiom) {
            return owlInverseObjectPropertiesAxiom;
        }

        public OWLAxiom visit(OWLHasKeyAxiom owlHasKeyAxiom) {
            return owlHasKeyAxiom;
        }

        public OWLAxiom visit(OWLDatatypeDefinitionAxiom owlDatatypeDefinitionAxiom) {
            return owlDatatypeDefinitionAxiom;
        }

        public OWLAxiom visit(SWRLRule swrlRule) {
            return swrlRule;
        }

        public OWLAxiom visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
            return owlSubAnnotationPropertyOfAxiom;
        }

        public OWLAxiom visit(OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
            return owlAnnotationPropertyDomainAxiom;
        }

        public OWLAxiom visit(OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
            return owlAnnotationPropertyRangeAxiom;
        }
    }
}

