/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.util.AxiomTransformation;
import org.semanticweb.owl.explanation.impl.util.Polarity;
import org.semanticweb.owlapi.apibinding.OWLFunctionalSyntaxFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class DeltaTransformation
implements AxiomTransformation {
    private int freshIRICounter = 0;
    private OWLDataFactory dataFactory;
    private Set<OWLEntity> freshEntities = new HashSet<OWLEntity>();
    private Set<OWLAxiom> transformedAxioms = new HashSet<OWLAxiom>();
    private int currentAxiomCount = 0;
    private Map<OWLAxiom, Integer> namingAxiom2ModalDepth = new HashMap<OWLAxiom, Integer>();
    private int modalDepth = 0;

    public DeltaTransformation(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    private boolean isFreshEntity(OWLEntity entity) {
        return this.freshEntities.contains(entity);
    }

    private OWLClass getFreshClass() {
        OWLClass freshClass = this.dataFactory.getOWLClass(this.getNextFreshIRI());
        this.freshEntities.add((OWLEntity)freshClass);
        return freshClass;
    }

    private OWLDatatype getFreshDatatype() {
        OWLDatatype freshDatatype = this.dataFactory.getOWLDatatype(this.getNextFreshIRI());
        this.freshEntities.add((OWLEntity)freshDatatype);
        return freshDatatype;
    }

    private OWLNamedIndividual getFreshIndividual() {
        OWLNamedIndividual freshIndividual = this.dataFactory.getOWLNamedIndividual(this.getNextFreshIRI());
        this.freshEntities.add((OWLEntity)freshIndividual);
        return freshIndividual;
    }

    private IRI getNextFreshIRI() {
        ++this.freshIRICounter;
        return IRI.create((String)("http://owlapi.sourceforge.net/transform/flattening#X" + this.freshIRICounter));
    }

    @Override
    public Set<OWLAxiom> transform(Set<OWLAxiom> axioms) {
        this.transformedAxioms.clear();
        this.namingAxiom2ModalDepth.clear();
        AxiomTransformer transformer = new AxiomTransformer();
        for (OWLAxiom ax : axioms) {
            ++this.currentAxiomCount;
            this.transformedAxioms.addAll((Collection)ax.accept((OWLAxiomVisitorEx)transformer));
        }
        return this.transformedAxioms;
    }

    public int getModalDepth(OWLAxiom renamingAxiom) {
        Integer depth = this.namingAxiom2ModalDepth.get(renamingAxiom);
        if (depth == null) {
            return 0;
        }
        return depth;
    }

    private boolean isFreshClass(OWLClassExpression ce) {
        return !ce.isAnonymous() && this.freshEntities.contains(ce.asOWLClass());
    }

    private OWLNamedIndividual assignName(OWLIndividual individual) {
        OWLNamedIndividual freshIndividual = this.getFreshIndividual();
        HashSet<Object> individuals = new HashSet<Object>();
        individuals.add(individual);
        individuals.add(freshIndividual);
        OWLSameIndividualAxiom namingAxiom = this.dataFactory.getOWLSameIndividualAxiom(individuals);
        this.namingAxiom2ModalDepth.put((OWLAxiom)namingAxiom, this.modalDepth);
        this.transformedAxioms.add((OWLAxiom)namingAxiom);
        return freshIndividual;
    }

    private OWLClass assignName(OWLClassExpression classExpression, Polarity polarity) {
        if (polarity.isPositive() ? classExpression.isOWLThing() : classExpression.isOWLNothing()) {
            return classExpression.asOWLClass();
        }
        if (this.isFreshClass(classExpression)) {
            return classExpression.asOWLClass();
        }
        OWLClass freshClass = this.getFreshClass();
        return this.assignName(classExpression, polarity, freshClass);
    }

    private OWLClass assignName(OWLClassExpression classExpression, Polarity polarity, OWLClass freshClass) {
        Set axiomId = Collections.emptySet();
        OWLSubClassOfAxiom namingAxiom = polarity.isPositive() ? this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)freshClass, classExpression, axiomId) : this.dataFactory.getOWLSubClassOfAxiom(classExpression, (OWLClassExpression)freshClass, axiomId);
        this.namingAxiom2ModalDepth.put((OWLAxiom)namingAxiom, this.modalDepth);
        this.transformedAxioms.add((OWLAxiom)namingAxiom);
        return freshClass;
    }

    public static void main(String[] args) {
        DefaultPrefixManager pm = new DefaultPrefixManager("http://test.com#");
        OWLClass A = OWLFunctionalSyntaxFactory.Class((String)":A", (PrefixManager)pm);
        OWLClass B = OWLFunctionalSyntaxFactory.Class((String)":B", (PrefixManager)pm);
        OWLClass C = OWLFunctionalSyntaxFactory.Class((String)":C", (PrefixManager)pm);
        OWLObjectProperty prop = OWLFunctionalSyntaxFactory.ObjectProperty((String)":p", (PrefixManager)pm);
        OWLNamedIndividual i = OWLFunctionalSyntaxFactory.NamedIndividual((String)":i", (PrefixManager)pm);
        OWLNamedIndividual j = OWLFunctionalSyntaxFactory.NamedIndividual((String)":j", (PrefixManager)pm);
        OWLNamedIndividual k = OWLFunctionalSyntaxFactory.NamedIndividual((String)":k", (PrefixManager)pm);
        OWLNamedIndividual l = OWLFunctionalSyntaxFactory.NamedIndividual((String)":l", (PrefixManager)pm);
        OWLDataFactoryImpl df = new OWLDataFactoryImpl();
        OWLSubClassOfAxiom ax = OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)A, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectOneOf((OWLIndividual[])new OWLIndividual[]{i, j, k, l}));
        System.out.println(ax);
        System.out.println("---------------------------------------------------");
        DeltaTransformation transformation = new DeltaTransformation((OWLDataFactory)df);
        for (OWLAxiom axt : transformation.transform(Collections.singleton(ax))) {
            System.out.println(axt);
        }
    }

    private class ClassExpressionTransformer
    implements OWLClassExpressionVisitorEx<OWLClassExpression>,
    OWLDataRangeVisitorEx<OWLDataRange> {
        private Polarity polarity;

        private ClassExpressionTransformer(Polarity polarity) {
            this.polarity = polarity;
        }

        private Set<OWLClassExpression> getRenamedClasses(Set<OWLClassExpression> classes, boolean useSameName) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            if (useSameName) {
                OWLClass name = DeltaTransformation.this.getFreshClass();
                for (OWLClassExpression ce : classes) {
                    OWLClassExpression ceP;
                    if (this.polarity.isPositive()) {
                        if (ce.isOWLThing()) continue;
                        ceP = (OWLClassExpression)ce.accept((OWLClassExpressionVisitorEx)this);
                        DeltaTransformation.this.assignName(ceP, Polarity.POSITIVE, name);
                        continue;
                    }
                    if (ce.isOWLNothing()) continue;
                    ceP = (OWLClassExpression)ce.accept((OWLClassExpressionVisitorEx)this);
                    DeltaTransformation.this.assignName(ceP, Polarity.NEGATIVE, name);
                }
                return Collections.singleton(name);
            }
            for (OWLClassExpression cls : classes) {
                OWLClassExpression transCls = (OWLClassExpression)cls.accept((OWLClassExpressionVisitorEx)this);
                OWLClass renaming = DeltaTransformation.this.assignName(transCls, this.polarity);
                result.add((OWLClassExpression)renaming);
            }
            return result;
        }

        public OWLClass visit(OWLClass ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf ce) {
            Set<OWLClassExpression> renamedOperands = this.getRenamedClasses(ce.getOperands(), this.polarity.isPositive());
            if (renamedOperands.size() == 1) {
                return renamedOperands.iterator().next();
            }
            return DeltaTransformation.this.dataFactory.getOWLObjectIntersectionOf(renamedOperands);
        }

        public OWLClassExpression visit(OWLObjectUnionOf ce) {
            Set<OWLClassExpression> renamedOperands = this.getRenamedClasses(ce.getOperands(), !this.polarity.isPositive());
            if (renamedOperands.size() == 1) {
                return renamedOperands.iterator().next();
            }
            return DeltaTransformation.this.dataFactory.getOWLObjectUnionOf(renamedOperands);
        }

        public OWLClassExpression visit(OWLObjectComplementOf ce) {
            this.polarity = this.polarity.getReversePolarity();
            OWLClass renamedComplement = DeltaTransformation.this.assignName((OWLClassExpression)ce.getOperand().accept((OWLClassExpressionVisitorEx)this), this.polarity);
            this.polarity = this.polarity.getReversePolarity();
            return DeltaTransformation.this.dataFactory.getOWLObjectComplementOf((OWLClassExpression)renamedComplement);
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom ce) {
            DeltaTransformation.this.modalDepth++;
            OWLClass renamedFiller = DeltaTransformation.this.assignName((OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this), this.polarity);
            DeltaTransformation.this.modalDepth--;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)ce.getProperty();
            return DeltaTransformation.this.dataFactory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)renamedFiller);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom ce) {
            DeltaTransformation.this.modalDepth++;
            OWLClass renamedFiller = DeltaTransformation.this.assignName((OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this), this.polarity);
            DeltaTransformation.this.modalDepth--;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)ce.getProperty();
            return DeltaTransformation.this.dataFactory.getOWLObjectAllValuesFrom(property, (OWLClassExpression)renamedFiller);
        }

        public OWLClassExpression visit(OWLObjectHasValue ce) {
            DeltaTransformation.this.modalDepth++;
            OWLNamedIndividual renamedInd = DeltaTransformation.this.assignName((OWLIndividual)ce.getValue());
            DeltaTransformation.this.modalDepth--;
            return DeltaTransformation.this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)ce.getProperty(), (OWLIndividual)renamedInd);
        }

        public OWLClassExpression visit(OWLObjectMinCardinality ce) {
            DeltaTransformation.this.modalDepth++;
            OWLClass renamedFiller = DeltaTransformation.this.assignName((OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this), this.polarity);
            DeltaTransformation.this.modalDepth--;
            OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ce.getProperty();
            int cardi = ce.getCardinality();
            return DeltaTransformation.this.dataFactory.getOWLObjectMinCardinality(cardi, prop, (OWLClassExpression)renamedFiller);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality ce) {
            return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality ce) {
            this.polarity = this.polarity.getReversePolarity();
            DeltaTransformation.this.modalDepth++;
            OWLClass renamedFiller = DeltaTransformation.this.assignName((OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this), this.polarity);
            DeltaTransformation.this.modalDepth--;
            this.polarity = this.polarity.getReversePolarity();
            OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ce.getProperty();
            int cardi = ce.getCardinality();
            return DeltaTransformation.this.dataFactory.getOWLObjectMaxCardinality(cardi, prop, (OWLClassExpression)renamedFiller);
        }

        public OWLClassExpression visit(OWLObjectHasSelf ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLObjectOneOf ce) {
            HashSet<OWLNamedIndividual> renamed = new HashSet<OWLNamedIndividual>();
            for (OWLIndividual ind : ce.getIndividuals()) {
                renamed.add(DeltaTransformation.this.assignName(ind));
            }
            return DeltaTransformation.this.dataFactory.getOWLObjectOneOf(renamed);
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLDataHasValue ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLDataMinCardinality ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLDataExactCardinality ce) {
            return ce;
        }

        public OWLClassExpression visit(OWLDataMaxCardinality ce) {
            return ce;
        }

        public OWLDataRange visit(OWLDatatype node) {
            return node;
        }

        public OWLDataRange visit(OWLDataOneOf node) {
            return node;
        }

        public OWLDataRange visit(OWLDataComplementOf node) {
            return node;
        }

        public OWLDataRange visit(OWLDataIntersectionOf node) {
            return node;
        }

        public OWLDataRange visit(OWLDataUnionOf node) {
            return node;
        }

        public OWLDataRange visit(OWLDatatypeRestriction node) {
            return node;
        }
    }

    private class AxiomTransformer
    implements OWLAxiomVisitorEx<Set<OWLAxiom>> {
        private ClassExpressionTransformer positiveTransformer;
        private ClassExpressionTransformer negativeTransformer;

        private AxiomTransformer() {
            this.positiveTransformer = new ClassExpressionTransformer(Polarity.POSITIVE);
            this.negativeTransformer = new ClassExpressionTransformer(Polarity.NEGATIVE);
        }

        private Set<OWLAxiom> visit(Set<? extends OWLAxiom> axioms) {
            HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
            for (OWLAxiom oWLAxiom : axioms) {
                result.addAll((Collection)oWLAxiom.accept((OWLAxiomVisitorEx)this));
            }
            return result;
        }

        public Set<OWLAxiom> visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression subClass = (OWLClassExpression)axiom.getSubClass().accept((OWLClassExpressionVisitorEx)this.negativeTransformer);
            OWLClass freshSub = DeltaTransformation.this.assignName(subClass, Polarity.NEGATIVE);
            OWLClassExpression superClass = (OWLClassExpression)axiom.getSuperClass().accept((OWLClassExpressionVisitorEx)this.positiveTransformer);
            OWLClass freshSuper = DeltaTransformation.this.assignName(superClass, Polarity.POSITIVE);
            HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
            result.add((OWLAxiom)DeltaTransformation.this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)freshSub, (OWLClassExpression)freshSuper));
            return result;
        }

        public Set<OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return (Set)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Set<OWLAxiom> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
            HashSet result = new HashSet();
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
            return (Set)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Set<OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
            OWLClassExpression renamedDomain = (OWLClassExpression)axiom.getDomain().accept((OWLClassExpressionVisitorEx)this.positiveTransformer);
            OWLObjectPropertyDomainAxiom transformed = DeltaTransformation.this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), renamedDomain);
            return Collections.singleton(transformed);
        }

        public Set<OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            return this.visit(axiom.asSubObjectPropertyOfAxioms());
        }

        public Set<OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return (Set)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Set<OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
            HashSet<OWLNamedIndividual> renamed = new HashSet<OWLNamedIndividual>();
            for (OWLIndividual ind : axiom.getIndividuals()) {
                renamed.add(DeltaTransformation.this.assignName(ind));
            }
            return Collections.singleton(DeltaTransformation.this.dataFactory.getOWLDifferentIndividualsAxiom(renamed));
        }

        public Set<OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
            DeltaTransformation.this.modalDepth++;
            OWLClassExpression renamedRange = (OWLClassExpression)((OWLClassExpression)axiom.getRange()).accept((OWLClassExpressionVisitorEx)this.positiveTransformer);
            DeltaTransformation.this.modalDepth--;
            OWLObjectPropertyRangeAxiom transformed = DeltaTransformation.this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), renamedRange);
            return Collections.singleton(transformed);
        }

        public Set<OWLAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLNamedIndividual renamedSubject = DeltaTransformation.this.assignName(axiom.getSubject());
            OWLNamedIndividual renamedObject = DeltaTransformation.this.assignName((OWLIndividual)axiom.getObject());
            OWLObjectPropertyAssertionAxiom flattendAx = DeltaTransformation.this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)renamedSubject, (OWLIndividual)renamedObject);
            return Collections.singleton(flattendAx);
        }

        public Set<OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSubObjectPropertyOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
            HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
            result.addAll((Collection)axiom.getOWLDisjointClassesAxiom().accept((OWLAxiomVisitorEx)this));
            result.addAll((Collection)axiom.getOWLEquivalentClassesAxiom().accept((OWLAxiomVisitorEx)this));
            return result;
        }

        public Set<OWLAxiom> visit(OWLDeclarationAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAnnotationAssertionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return this.visit(axiom.asSubDataPropertyOfAxioms());
        }

        public Set<OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
            OWLClass renamedCls = DeltaTransformation.this.assignName(axiom.getClassExpression(), Polarity.POSITIVE);
            OWLNamedIndividual renamedInd = DeltaTransformation.this.assignName(axiom.getIndividual());
            OWLClassAssertionAxiom flattenedAx = DeltaTransformation.this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)renamedCls, (OWLIndividual)renamedInd);
            return Collections.singleton(flattenedAx);
        }

        public Set<OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
            return this.visit(axiom.asOWLSubClassOfAxioms());
        }

        public Set<OWLAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
            return (Set)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Set<OWLAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSubDataPropertyOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLSameIndividualAxiom axiom) {
            HashSet<OWLNamedIndividual> renamed = new HashSet<OWLNamedIndividual>();
            for (OWLIndividual ind : axiom.getIndividuals()) {
                renamed.add(DeltaTransformation.this.assignName(ind));
            }
            return Collections.singleton(DeltaTransformation.this.dataFactory.getOWLSameIndividualAxiom(renamed));
        }

        public Set<OWLAxiom> visit(OWLSubPropertyChainOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
            return this.visit(axiom.asSubObjectPropertyOfAxioms());
        }

        public Set<OWLAxiom> visit(OWLHasKeyAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLDatatypeDefinitionAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(SWRLRule rule) {
            return Collections.singleton(rule);
        }

        public Set<OWLAxiom> visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAnnotationPropertyDomainAxiom axiom) {
            return Collections.singleton(axiom);
        }

        public Set<OWLAxiom> visit(OWLAnnotationPropertyRangeAxiom axiom) {
            return Collections.singleton(axiom);
        }
    }
}

