/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.rootderived;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.RootDerivedReasoner;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class StructuralRootDerivedReasoner
implements RootDerivedReasoner {
    private OWLOntologyManager man;
    private OWLReasoner reasoner;
    private OWLReasonerFactory reasonerFactory;
    private OWLOntology mergedOntology;
    private Map<OWLClass, Set<OWLClass>> child2Parent;
    private Map<OWLClass, Set<OWLClass>> parent2Child;
    private Set<OWLClass> roots;
    private boolean dirty;

    public StructuralRootDerivedReasoner(OWLOntologyManager man, OWLReasoner reasoner, OWLReasonerFactory reasonerFactory) {
        this.man = man;
        this.reasonerFactory = reasonerFactory;
        this.reasoner = reasoner;
        this.child2Parent = new HashMap<OWLClass, Set<OWLClass>>();
        this.parent2Child = new HashMap<OWLClass, Set<OWLClass>>();
        this.roots = new HashSet<OWLClass>();
        try {
            this.getMergedOntology();
        }
        catch (ExplanationException e) {
            e.printStackTrace();
        }
        this.dirty = true;
    }

    public OWLOntology getMergedOntology() throws ExplanationException {
        try {
            if (this.mergedOntology == null) {
                this.mergedOntology = this.man.createOntology(IRI.create((String)"owlapi:ontology:merge"), this.reasoner.getRootOntology().getImportsClosure(), true);
            }
            return this.mergedOntology;
        }
        catch (OWLOntologyCreationException e) {
            throw new ExplanationException(e);
        }
        catch (OWLOntologyChangeException e) {
            throw new ExplanationException(e);
        }
    }

    private Set<OWLClass> get(OWLClass c, Map<OWLClass, Set<OWLClass>> map) {
        Set<OWLClass> set = map.get(c);
        if (set == null) {
            set = new HashSet<OWLClass>();
            map.put(c, set);
        }
        return set;
    }

    @Override
    public Set<OWLClass> getDependentChildClasses(OWLClass cls) {
        return this.get(cls, this.parent2Child);
    }

    @Override
    public Set<OWLClass> getDependentDescendantClasses(OWLClass cls) {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        this.getDescendants(cls, result);
        return result;
    }

    private void getDescendants(OWLClass cls, Set<OWLClass> result) {
        if (result.contains(cls)) {
            return;
        }
        for (OWLClass child : this.getDependentChildClasses(cls)) {
            result.add(child);
            this.getDescendants(child, result);
        }
    }

    @Override
    public Set<OWLClass> getRootUnsatisfiableClasses() throws ExplanationException {
        if (this.dirty) {
            this.computeRootDerivedClasses();
        }
        return Collections.unmodifiableSet(this.roots);
    }

    private void computeRootDerivedClasses() throws ExplanationException {
        this.computeCandidateRoots();
        this.roots.remove(this.man.getOWLDataFactory().getOWLNothing());
        for (OWLClass child : this.child2Parent.keySet()) {
            for (OWLClass oWLClass : this.get(child, this.child2Parent)) {
                this.get(oWLClass, this.parent2Child).add(child);
            }
        }
        HashSet<OWLClass> processed = new HashSet<OWLClass>();
        HashSet<Set<OWLClass>> result = new HashSet<Set<OWLClass>>();
        for (OWLClass oWLClass : this.child2Parent.keySet()) {
            if (processed.contains(oWLClass)) continue;
            this.tarjan(oWLClass, 0, new Stack<OWLClass>(), new HashMap<OWLClass, Integer>(), new HashMap<OWLClass, Integer>(), result, processed, new HashSet<OWLClass>());
        }
        for (Set set : result) {
            this.roots.addAll(set);
        }
    }

    private void getPaths(OWLClass cls, List<OWLClass> curPath, Set<OWLClass> curPathSet, Set<List<OWLClass>> paths) {
        if (curPathSet.contains(cls)) {
            curPath.add(cls);
            paths.add(new ArrayList<OWLClass>(curPath));
            return;
        }
        curPathSet.add(cls);
        curPath.add(cls);
        Set<OWLClass> parents = this.child2Parent.get(cls);
        if (parents.isEmpty()) {
            paths.add(new ArrayList<OWLClass>(curPath));
        }
        for (OWLClass dep : parents) {
            this.getPaths(dep, curPath, curPathSet, paths);
            if (curPath.isEmpty()) continue;
            curPath.remove(curPath.size() - 1);
            curPathSet.remove(dep);
        }
    }

    public void tarjan(OWLClass cls, int index, Stack<OWLClass> stack, Map<OWLClass, Integer> indexMap, Map<OWLClass, Integer> lowlinkMap, Set<Set<OWLClass>> result, Set<OWLClass> processed, Set<OWLClass> stackClass) {
        processed.add(cls);
        indexMap.put(cls, index);
        lowlinkMap.put(cls, index);
        ++index;
        stack.push(cls);
        stackClass.add(cls);
        for (OWLClass par : this.child2Parent.get(cls)) {
            if (!indexMap.containsKey(par)) {
                this.tarjan(par, index, stack, indexMap, lowlinkMap, result, processed, stackClass);
                lowlinkMap.put(cls, Math.min(lowlinkMap.get(cls), lowlinkMap.get(par)));
                continue;
            }
            if (!stackClass.contains(par)) continue;
            lowlinkMap.put(cls, Math.min(lowlinkMap.get(cls), indexMap.get(par)));
        }
        if (lowlinkMap.get(cls).equals(indexMap.get(cls))) {
            OWLClass clsPrime;
            HashSet<OWLClass> scc = new HashSet<OWLClass>();
            do {
                clsPrime = stack.pop();
                stackClass.remove(clsPrime);
                scc.add(clsPrime);
            } while (!clsPrime.equals(cls));
            if (scc.size() > 1) {
                result.add(scc);
            }
        }
    }

    private void pruneRoots() throws ExplanationException {
        try {
            HashSet<OWLClass> rootUnsatClses = new HashSet<OWLClass>(this.roots);
            ArrayList<RemoveAxiom> appliedChanges = new ArrayList<RemoveAxiom>();
            HashSet<OWLClass> potentialRoots = new HashSet<OWLClass>();
            for (OWLDisjointClassesAxiom ax : new ArrayList(this.mergedOntology.getAxioms(AxiomType.DISJOINT_CLASSES))) {
                for (OWLClass cls : rootUnsatClses) {
                    if (!ax.getSignature().contains(cls)) continue;
                    RemoveAxiom chg = new RemoveAxiom(this.mergedOntology, (OWLAxiom)ax);
                    this.man.applyChange((OWLOntologyChange)chg);
                    appliedChanges.add(chg);
                    for (OWLEntity ent : ax.getSignature()) {
                        if (!ent.isOWLClass()) continue;
                        potentialRoots.add(ent.asOWLClass());
                    }
                }
            }
            for (OWLClass c : rootUnsatClses) {
                this.man.addAxiom(this.mergedOntology, (OWLAxiom)this.man.getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)c));
            }
            OWLReasoner checkingReasoner = this.reasonerFactory.createReasoner(this.mergedOntology);
            for (OWLClass root : new ArrayList<OWLClass>(rootUnsatClses)) {
                if (potentialRoots.contains(root) || !checkingReasoner.isSatisfiable((OWLClassExpression)root)) continue;
                rootUnsatClses.remove(root);
            }
        }
        catch (OWLOntologyChangeException e) {
            throw new ExplanationException(e);
        }
    }

    private void computeCandidateRoots() throws ExplanationException {
        Set unsatisfiableClasses = this.reasoner.getUnsatisfiableClasses().getEntities();
        OWLOntology ont = this.getMergedOntology();
        SuperClassChecker checker = new SuperClassChecker();
        for (OWLClass cls : unsatisfiableClasses) {
            checker.reset();
            for (OWLClassExpression sup : cls.getSuperClasses(this.reasoner.getRootOntology().getImportsClosure())) {
                sup.accept((OWLClassExpressionVisitor)checker);
            }
            for (OWLClassExpression sup : cls.getEquivalentClasses(this.reasoner.getRootOntology().getImportsClosure())) {
                sup.accept((OWLClassExpressionVisitor)checker);
            }
            Set<OWLClass> dependencies = checker.getDependencies();
            this.child2Parent.put(cls, new HashSet<OWLClass>(dependencies));
            if (!dependencies.isEmpty()) continue;
            this.roots.add(cls);
        }
    }

    private class SuperClassChecker
    implements OWLClassExpressionVisitor {
        private Set<OWLClass> dependsOn;
        private int modalDepth = 0;
        private Map<Integer, Set<OWLObjectAllValuesFrom>> modalDepth2UniversalRestrictionPropertyMap = new HashMap<Integer, Set<OWLObjectAllValuesFrom>>();
        private Map<Integer, Set<OWLObjectPropertyExpression>> modalDepth2ExistsRestrictionPropertyMap = new HashMap<Integer, Set<OWLObjectPropertyExpression>>();

        public SuperClassChecker() {
            this.dependsOn = new HashSet<OWLClass>();
        }

        public void addUniversalRestrictionProperty(OWLObjectAllValuesFrom r) {
            Set<OWLObjectAllValuesFrom> props = this.modalDepth2UniversalRestrictionPropertyMap.get(this.modalDepth);
            if (props == null) {
                props = new HashSet<OWLObjectAllValuesFrom>();
                this.modalDepth2UniversalRestrictionPropertyMap.put(this.modalDepth, props);
            }
            props.add(r);
        }

        public void addExistsRestrictionProperty(OWLObjectPropertyExpression prop) {
            Set<OWLObjectPropertyExpression> props = this.modalDepth2ExistsRestrictionPropertyMap.get(this.modalDepth);
            if (props == null) {
                props = new HashSet<OWLObjectPropertyExpression>();
                this.modalDepth2ExistsRestrictionPropertyMap.put(this.modalDepth, props);
            }
            props.add(prop);
        }

        public Set<OWLClass> getDependencies() {
            return Collections.unmodifiableSet(this.dependsOn);
        }

        public void reset() {
            this.dependsOn.clear();
            this.modalDepth2ExistsRestrictionPropertyMap.clear();
            this.modalDepth2UniversalRestrictionPropertyMap.clear();
        }

        public void visit(OWLClass desc) {
            if (!StructuralRootDerivedReasoner.this.reasoner.isSatisfiable((OWLClassExpression)desc)) {
                this.dependsOn.add(desc);
            }
        }

        public void visit(OWLDataAllValuesFrom desc) {
        }

        public void visit(OWLDataExactCardinality desc) {
        }

        public void visit(OWLDataMaxCardinality desc) {
        }

        public void visit(OWLDataMinCardinality desc) {
        }

        public void visit(OWLDataSomeValuesFrom desc) {
        }

        public void visit(OWLDataHasValue desc) {
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            if (((OWLClassExpression)desc.getFiller()).isAnonymous()) {
                ++this.modalDepth;
                ((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitor)this);
                --this.modalDepth;
            } else if (!StructuralRootDerivedReasoner.this.reasoner.isSatisfiable((OWLClassExpression)desc.getFiller())) {
                this.addUniversalRestrictionProperty(desc);
                this.dependsOn.add(((OWLClassExpression)desc.getFiller()).asOWLClass());
            }
        }

        public void visit(OWLObjectComplementOf desc) {
        }

        public void visit(OWLObjectExactCardinality desc) {
            if (((OWLClassExpression)desc.getFiller()).isAnonymous()) {
                ++this.modalDepth;
                ((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitor)this);
                --this.modalDepth;
            } else if (!StructuralRootDerivedReasoner.this.reasoner.isSatisfiable((OWLClassExpression)desc.getFiller()) && !((OWLClassExpression)desc.getFiller()).isAnonymous()) {
                this.dependsOn.add(((OWLClassExpression)desc.getFiller()).asOWLClass());
            }
            this.addExistsRestrictionProperty((OWLObjectPropertyExpression)desc.getProperty());
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                if (op.isAnonymous()) {
                    op.accept((OWLClassExpressionVisitor)this);
                    continue;
                }
                if (StructuralRootDerivedReasoner.this.reasoner.isSatisfiable(op)) continue;
                this.dependsOn.add(op.asOWLClass());
            }
        }

        public void visit(OWLObjectMaxCardinality desc) {
        }

        public void visit(OWLObjectMinCardinality desc) {
            if (((OWLClassExpression)desc.getFiller()).isAnonymous()) {
                ++this.modalDepth;
                ((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitor)this);
                --this.modalDepth;
            } else if (!StructuralRootDerivedReasoner.this.reasoner.isSatisfiable((OWLClassExpression)desc.getFiller())) {
                this.dependsOn.add(((OWLClassExpression)desc.getFiller()).asOWLClass());
            }
            this.addExistsRestrictionProperty((OWLObjectPropertyExpression)desc.getProperty());
        }

        public void visit(OWLObjectOneOf desc) {
        }

        public void visit(OWLObjectHasSelf desc) {
            this.addExistsRestrictionProperty((OWLObjectPropertyExpression)desc.getProperty());
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            if (((OWLClassExpression)desc.getFiller()).isAnonymous()) {
                ++this.modalDepth;
                ((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitor)this);
                --this.modalDepth;
            } else if (!StructuralRootDerivedReasoner.this.reasoner.isSatisfiable((OWLClassExpression)desc.getFiller())) {
                this.dependsOn.add(((OWLClassExpression)desc.getFiller()).asOWLClass());
            }
            this.addExistsRestrictionProperty((OWLObjectPropertyExpression)desc.getProperty());
        }

        public void visit(OWLObjectUnionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                if (!StructuralRootDerivedReasoner.this.reasoner.isSatisfiable(op)) continue;
                return;
            }
            for (OWLClassExpression op : desc.getOperands()) {
                if (op.isAnonymous()) {
                    op.accept((OWLClassExpressionVisitor)this);
                    continue;
                }
                this.dependsOn.add(op.asOWLClass());
            }
        }

        public void visit(OWLObjectHasValue desc) {
            this.addExistsRestrictionProperty((OWLObjectPropertyExpression)desc.getProperty());
        }
    }
}

