/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.masking;

import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.impl.laconic.LaconicExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.impl.masking.MaskingDetector;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.StructuralTransformation;

public class MaskingDetectorDeltaImpl
implements MaskingDetector {
    private OWLOntologyManager manager;
    private OWLReasonerFactory reasonerFactory;
    private LaconicExplanationGeneratorFactory<OWLAxiom> expGenFac;

    public MaskingDetectorDeltaImpl(OWLOntologyManager manager, LaconicExplanationGeneratorFactory<OWLAxiom> expGenFac, OWLReasonerFactory reasonerFactory) {
        this.manager = manager;
        this.reasonerFactory = reasonerFactory;
        this.expGenFac = expGenFac;
    }

    @Override
    public boolean isMaskingPresent(Explanation<OWLAxiom> explanation) {
        OWLDataFactory dataFactory = this.manager.getOWLDataFactory();
        StructuralTransformation st = new StructuralTransformation(dataFactory);
        Set axioms = st.getTransformedAxioms(explanation.getAxioms());
        ExplanationGenerator<OWLAxiom> expGen = this.expGenFac.createExplanationGenerator(axioms);
        Set<Explanation<OWLAxiom>> expls = expGen.getExplanations(explanation.getEntailment());
        return expls.size() > 1;
    }
}

