/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.IsLaconicChecker;
import org.semanticweb.owl.explanation.impl.laconic.LaconicCheckerMode;
import org.semanticweb.owl.explanation.impl.laconic.ModularityTreatment;
import org.semanticweb.owl.explanation.impl.laconic.OPlusGenerator;
import org.semanticweb.owl.explanation.impl.laconic.OPlusSplitting;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

public class LaconicExplanationGeneratorBasedOnOPlus
implements ExplanationGenerator<OWLAxiom> {
    private Set<OWLAxiom> inputAxioms;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private ExplanationGeneratorFactory<OWLAxiom> delegateFactory;
    private ExplanationProgressMonitor<OWLAxiom> progressMonitor;
    private OPlusSplitting oplusSplitting = OPlusSplitting.TOP_LEVEL;
    private ModularityTreatment modularityTreatment = ModularityTreatment.MODULE;

    public LaconicExplanationGeneratorBasedOnOPlus(Set<? extends OWLAxiom> inputAxioms, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory, ExplanationGeneratorFactory<OWLAxiom> delegateFactory, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        this.inputAxioms = new HashSet<OWLAxiom>(inputAxioms);
        this.entailmentCheckerFactory = entailmentCheckerFactory;
        this.delegateFactory = delegateFactory;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment, int limit) throws ExplanationException {
        Set<Object> oplusInput;
        OWLDataFactory dataFactory = OWLDataFactoryImpl.getInstance();
        OPlusGenerator transformation = new OPlusGenerator(dataFactory, this.oplusSplitting);
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        if (this.modularityTreatment.equals((Object)ModularityTreatment.MODULE)) {
            SyntacticLocalityModuleExtractor extractor = new SyntacticLocalityModuleExtractor(man, null, this.inputAxioms, ModuleType.STAR);
            oplusInput = extractor.extract(entailment.getSignature());
        } else {
            oplusInput = new HashSet<OWLAxiom>(this.inputAxioms);
        }
        Set<OWLAxiom> oplusAxioms = transformation.transform(oplusInput);
        ExplanationGenerator<OWLAxiom> gen = this.delegateFactory.createExplanationGenerator(oplusAxioms, (ExplanationProgressMonitor<OWLAxiom>)new MediatingProgresssMonitor());
        Set<Explanation<OWLAxiom>> oplusExpls = gen.getExplanations(entailment);
        IsLaconicChecker checker = new IsLaconicChecker(dataFactory, this.entailmentCheckerFactory, LaconicCheckerMode.EARLY_TERMINATING);
        HashSet<Explanation<OWLAxiom>> laconicExplanations = new HashSet<Explanation<OWLAxiom>>();
        for (Explanation<OWLAxiom> expl : oplusExpls) {
            if (!checker.isLaconic(expl)) continue;
            laconicExplanations.add(expl);
        }
        Set<Explanation<OWLAxiom>> reconstitutedLaconicExpls = this.getReconstitutedExplanations(dataFactory, transformation, laconicExplanations);
        this.removeWeakerExplanations(dataFactory, transformation, reconstitutedLaconicExpls);
        HashSet<Explanation<Explanation<OWLAxiom>>> progressMonitorExplanations = new HashSet<Explanation<Explanation<OWLAxiom>>>();
        for (Explanation<OWLAxiom> expl : reconstitutedLaconicExpls) {
            progressMonitorExplanations.add(expl);
            this.progressMonitor.foundExplanation(this, expl, progressMonitorExplanations);
        }
        return laconicExplanations;
    }

    private Set<Explanation<OWLAxiom>> getReconstitutedExplanations(OWLDataFactory dataFactory, OPlusGenerator transformation, Set<Explanation<OWLAxiom>> laconicExplanations) {
        HashSet<Explanation<OWLAxiom>> reconstitutedLaconicExpls = new HashSet<Explanation<OWLAxiom>>();
        for (Explanation<OWLAxiom> expl : laconicExplanations) {
            reconstitutedLaconicExpls.addAll(this.getReconstitutedExplanations(expl, transformation, dataFactory));
        }
        return reconstitutedLaconicExpls;
    }

    private void removeWeakerExplanations(OWLDataFactory dataFactory, OPlusGenerator transformation, Set<Explanation<OWLAxiom>> laconicExplanations) {
        for (Explanation<OWLAxiom> explA : new ArrayList<Explanation<OWLAxiom>>(laconicExplanations)) {
            for (Explanation<OWLAxiom> explB : new ArrayList<Explanation<OWLAxiom>>(laconicExplanations)) {
                Set<OWLAxiom> oPlusB;
                if (explA == explB || !laconicExplanations.contains(explA) || !laconicExplanations.contains(explB)) continue;
                Set<OWLAxiom> sourceAxiomsA = this.getSourceAxioms(explA, transformation);
                Set<OWLAxiom> sourceAxiomsB = this.getSourceAxioms(explB, transformation);
                OPlusGenerator gen2 = new OPlusGenerator(dataFactory, OPlusSplitting.NONE);
                Set<OWLAxiom> oPlusA = gen2.transform(explA.getAxioms());
                if (oPlusA.containsAll(oPlusB = gen2.transform(explB.getAxioms())) && sourceAxiomsA.containsAll(sourceAxiomsB)) {
                    laconicExplanations.remove(explB);
                    continue;
                }
                if (!oPlusB.containsAll(oPlusA) || !sourceAxiomsB.containsAll(sourceAxiomsA)) continue;
                laconicExplanations.remove(explA);
            }
        }
    }

    private Set<OWLAxiom> getSourceAxioms(Explanation<OWLAxiom> expl, OPlusGenerator oPlusGenerator) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : expl.getAxioms()) {
            Set<OWLAxiom> sourceAxioms = oPlusGenerator.getAxiom2SourceMap().get(ax);
            if (sourceAxioms == null) continue;
            result.addAll(sourceAxioms);
        }
        return result;
    }

    private Set<Explanation<OWLAxiom>> getReconstitutedExplanations(Explanation<OWLAxiom> expl, OPlusGenerator oPlusGenerator, OWLDataFactory dataFactory) {
        HashSet<OWLAxiom> nonSubClassOfAxioms = new HashSet<OWLAxiom>();
        HashSet<OWLSubClassOfAxiom> uniqueSourceSubClassAxioms = new HashSet<OWLSubClassOfAxiom>();
        HashSet<OWLSubClassOfAxiom> reconstitutedAxioms = new HashSet<OWLSubClassOfAxiom>();
        HashSet<OWLAxiom> reconstitutedAxiomSourcesWithMultipleSources = new HashSet<OWLAxiom>();
        for (OWLAxiom explAx : expl.getAxioms()) {
            if (explAx instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)explAx;
                Set<OWLAxiom> sameSourceAxioms = oPlusGenerator.getSameSourceAxioms((OWLAxiom)sca, expl.getAxioms());
                if (!sameSourceAxioms.isEmpty()) {
                    HashSet<OWLClassExpression> superClassConjuncts = new HashSet<OWLClassExpression>();
                    HashSet<OWLClassExpression> subClassDisjuncts = new HashSet<OWLClassExpression>();
                    for (OWLAxiom ax : sameSourceAxioms) {
                        if (!(ax instanceof OWLSubClassOfAxiom)) continue;
                        OWLSubClassOfAxiom sameSourceSCA = (OWLSubClassOfAxiom)ax;
                        superClassConjuncts.addAll(sameSourceSCA.getSuperClass().asConjunctSet());
                        subClassDisjuncts.addAll(sameSourceSCA.getSubClass().asDisjunctSet());
                        if (!oPlusGenerator.hasMultipleSources(ax)) continue;
                        reconstitutedAxiomSourcesWithMultipleSources.add(ax);
                    }
                    subClassDisjuncts.addAll(sca.getSubClass().asDisjunctSet());
                    superClassConjuncts.addAll(sca.getSuperClass().asConjunctSet());
                    OWLSubClassOfAxiom mergedAxiom = this.createSubClassAxiom(dataFactory, subClassDisjuncts, superClassConjuncts);
                    reconstitutedAxioms.add(mergedAxiom);
                    continue;
                }
                uniqueSourceSubClassAxioms.add(sca);
                continue;
            }
            nonSubClassOfAxioms.add(explAx);
        }
        if (reconstitutedAxioms.isEmpty()) {
            return Collections.singleton(expl);
        }
        HashSet<OWLAxiom> pool = new HashSet<OWLAxiom>();
        pool.addAll(nonSubClassOfAxioms);
        pool.addAll(uniqueSourceSubClassAxioms);
        pool.addAll(reconstitutedAxioms);
        pool.addAll(reconstitutedAxiomSourcesWithMultipleSources);
        if (reconstitutedAxiomSourcesWithMultipleSources.isEmpty()) {
            return Collections.singleton(new Explanation<OWLAxiom>(expl.getEntailment(), pool));
        }
        ExplanationGenerator<OWLAxiom> expGen = this.delegateFactory.createExplanationGenerator(pool);
        return expGen.getExplanations(expl.getEntailment());
    }

    private OWLSubClassOfAxiom createSubClassAxiom(OWLDataFactory dataFactory, Set<OWLClassExpression> subClassDisjuncts, Set<OWLClassExpression> superClassConjuncts) {
        Object mergedSubClass = subClassDisjuncts.size() == 1 ? subClassDisjuncts.iterator().next() : dataFactory.getOWLObjectUnionOf(subClassDisjuncts);
        Object mergedSuperClass = superClassConjuncts.size() == 1 ? superClassConjuncts.iterator().next() : dataFactory.getOWLObjectIntersectionOf(superClassConjuncts);
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)mergedSubClass, (OWLClassExpression)mergedSuperClass);
    }

    private class MediatingProgresssMonitor
    implements ExplanationProgressMonitor<OWLAxiom> {
        private MediatingProgresssMonitor() {
        }

        @Override
        public void foundExplanation(ExplanationGenerator<OWLAxiom> owlAxiomExplanationGenerator, Explanation<OWLAxiom> owlAxiomExplanation, Set<Explanation<OWLAxiom>> allFoundExplanations) {
        }

        @Override
        public boolean isCancelled() {
            return LaconicExplanationGeneratorBasedOnOPlus.this.progressMonitor.isCancelled();
        }
    }
}

