/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.LaconicCheckerMode;
import org.semanticweb.owl.explanation.impl.util.DeltaTransformation;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class IsLaconicChecker {
    private OWLDataFactory dataFactory;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private LaconicCheckerMode checkerMode;
    private DeltaTransformation deltaTransformation;
    private Set<OWLAnnotation> nonLaconicSourceAxioms = new HashSet<OWLAnnotation>();

    public IsLaconicChecker(OWLDataFactory dataFactory, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory) {
        this(dataFactory, entailmentCheckerFactory, LaconicCheckerMode.EARLY_TERMINATING);
    }

    public IsLaconicChecker(OWLDataFactory dataFactory, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory, LaconicCheckerMode checkerMode) {
        this.dataFactory = dataFactory;
        this.entailmentCheckerFactory = entailmentCheckerFactory;
        this.checkerMode = checkerMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLaconic(Explanation<OWLAxiom> expl) {
        if (expl.isJustificationEntailment()) {
            return true;
        }
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        DefaultTelemetryInfo info = new DefaultTelemetryInfo("laconiccheck", new TelemetryTimer[0]);
        transmitter.beginTransmission((TelemetryInfo)info);
        boolean laconic = true;
        int entailmentCheckCount = 0;
        this.nonLaconicSourceAxioms.clear();
        try {
            Set<OWLAxiom> flattened = this.getFlattenedAxioms(expl.getAxioms());
            transmitter.recordMeasurement((TelemetryInfo)info, "justification size", (Number)expl.getSize());
            transmitter.recordMeasurement((TelemetryInfo)info, "delta axioms size", (Number)flattened.size());
            EntailmentChecker<OWLAxiom> checker = this.entailmentCheckerFactory.createEntailementChecker(expl.getEntailment());
            for (OWLAxiom curAxiom : new ArrayList<OWLAxiom>(flattened)) {
                flattened.remove(curAxiom);
                ++entailmentCheckCount;
                if (checker.isEntailed(flattened)) {
                    laconic = false;
                    this.recordNonLaconicity((TelemetryInfo)info, curAxiom);
                    if (this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                flattened.add(curAxiom);
                if (!(curAxiom instanceof OWLSubClassOfAxiom)) continue;
                OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)curAxiom;
                if (sca.getSubClass() instanceof OWLObjectMinCardinality) {
                    ++entailmentCheckCount;
                    if (!this.isEntailedByWeakerMinCardinalitySubClass(sca, flattened, checker)) continue;
                    laconic = false;
                    this.recordNonLaconicity((TelemetryInfo)info, curAxiom);
                    if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (sca.getSubClass() instanceof OWLObjectMaxCardinality) {
                    ++entailmentCheckCount;
                    if (!this.isEntailedByWeakerMaxCardinalitySubClass(sca, flattened, checker)) continue;
                    laconic = false;
                    this.recordNonLaconicity((TelemetryInfo)info, curAxiom);
                    if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (sca.getSuperClass() instanceof OWLObjectMinCardinality) {
                    ++entailmentCheckCount;
                    if (!this.isEntailedByWeakerMinCardinalitySuperClass(sca, flattened, checker)) continue;
                    laconic = false;
                    this.recordNonLaconicity((TelemetryInfo)info, curAxiom);
                    if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (!(sca.getSuperClass() instanceof OWLObjectMaxCardinality)) continue;
                ++entailmentCheckCount;
                if (!this.isEntailedByWeakerMaxCardinalitySuperClass(sca, flattened, checker)) continue;
                laconic = false;
                this.recordNonLaconicity((TelemetryInfo)info, curAxiom);
                if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
            transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", (Number)entailmentCheckCount);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", (Number)this.nonLaconicSourceAxioms.size());
            transmitter.endTransmission((TelemetryInfo)info);
        }
        return laconic;
    }

    private void recordNonLaconicity(TelemetryInfo info, OWLAxiom curAxiom) {
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        this.nonLaconicSourceAxioms.addAll(curAxiom.getAnnotations());
        int modalDepth = this.deltaTransformation.getModalDepth(curAxiom);
        transmitter.recordMeasurement(info, "superfluity depth", (Number)modalDepth);
    }

    private boolean isEntailedByWeakerMinCardinalitySubClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMinCardinality cardinality = (OWLObjectMinCardinality)ax.getSubClass();
        int card = cardinality.getCardinality();
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMinCardinality weaker = this.dataFactory.getOWLObjectMinCardinality(card + 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)weaker, ax.getSuperClass());
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedByWeakerMaxCardinalitySubClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMaxCardinality cardinality = (OWLObjectMaxCardinality)ax.getSubClass();
        int card = cardinality.getCardinality();
        if (card == 0) {
            return false;
        }
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMaxCardinality weaker = this.dataFactory.getOWLObjectMaxCardinality(card - 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)weaker, ax.getSuperClass());
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedByWeakerMinCardinalitySuperClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMinCardinality cardinality = (OWLObjectMinCardinality)ax.getSuperClass();
        int card = cardinality.getCardinality();
        if (card == 1 || card == 0) {
            return false;
        }
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMinCardinality weaker = this.dataFactory.getOWLObjectMinCardinality(card - 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom(ax.getSubClass(), (OWLClassExpression)weaker);
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedByWeakerMaxCardinalitySuperClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMaxCardinality cardinality = (OWLObjectMaxCardinality)ax.getSuperClass();
        int card = cardinality.getCardinality();
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMaxCardinality weaker = this.dataFactory.getOWLObjectMaxCardinality(card + 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom(ax.getSubClass(), (OWLClassExpression)weaker);
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedWithReplacement(OWLAxiom axiom, OWLAxiom replacementAxiom, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        axioms.remove(axiom);
        axioms.add(replacementAxiom);
        boolean entailed = checker.isEntailed(axioms);
        axioms.remove(replacementAxiom);
        axioms.add(axiom);
        return entailed;
    }

    private Set<OWLAxiom> getFlattenedAxioms(Set<OWLAxiom> axioms) {
        this.deltaTransformation = new DeltaTransformation(this.dataFactory);
        return this.deltaTransformation.transform(axioms);
    }
}

