/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.laconic.BetaGenerator;
import org.semanticweb.owl.explanation.impl.laconic.TauGenerator;
import org.semanticweb.owl.explanation.impl.laconic.TriviallyBottomChecker;
import org.semanticweb.owl.explanation.impl.laconic.TriviallyTopChecker;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public abstract class BaseDescriptionGenerator
implements OWLClassExpressionVisitorEx<Set<OWLClassExpression>> {
    private OWLDataFactory factory;
    private static TriviallyTopChecker topChecker = new TriviallyTopChecker();
    private static TriviallyBottomChecker bottomChecker = new TriviallyBottomChecker();

    public BaseDescriptionGenerator(OWLDataFactory factory) {
        this.factory = factory;
    }

    public boolean isThing(OWLClassExpression description) {
        return (Boolean)description.accept((OWLClassExpressionVisitorEx)topChecker);
    }

    public boolean isNothing(OWLClassExpression description) {
        return (Boolean)description.accept((OWLClassExpressionVisitorEx)bottomChecker);
    }

    public OWLDataFactory getDataFactory() {
        return this.factory;
    }

    public Set<OWLClassExpression> computeTau(OWLClassExpression desc) {
        TauGenerator gen = new TauGenerator(this.factory);
        return (Set)desc.accept((OWLClassExpressionVisitorEx)gen);
    }

    public Set<OWLClassExpression> computeBeta(OWLClassExpression desc) {
        BetaGenerator gen = new BetaGenerator(this.factory);
        return (Set)desc.accept((OWLClassExpressionVisitorEx)gen);
    }

    private Set<Set<OWLClassExpression>> computeReplacements(Set<OWLClassExpression> operands) {
        HashSet ps = new HashSet();
        ps.add(new ArrayList());
        for (OWLClassExpression op : operands) {
            HashSet hashSet = new HashSet(ps);
            for (OWLClassExpression opEx : (Set)op.accept((OWLClassExpressionVisitorEx)this)) {
                for (List pselement : hashSet) {
                    ArrayList<OWLClassExpression> union = new ArrayList<OWLClassExpression>();
                    union.addAll(pselement);
                    union.add(opEx);
                    ps.remove(pselement);
                    ps.add(union);
                }
            }
        }
        HashSet<Set<OWLClassExpression>> result = new HashSet<Set<OWLClassExpression>>();
        for (List list : ps) {
            result.add(new HashSet(list));
        }
        return result;
    }

    public Set<OWLClassExpression> visit(OWLObjectIntersectionOf desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        Set<Set<OWLClassExpression>> conjunctions = this.computeReplacements(desc.getOperands());
        for (Set<OWLClassExpression> conjuncts : conjunctions) {
            Iterator<OWLClassExpression> it = conjuncts.iterator();
            while (it.hasNext()) {
                if (!this.isThing(it.next())) continue;
                it.remove();
            }
            if (conjuncts.isEmpty()) {
                descs.add((OWLClassExpression)this.factory.getOWLThing());
                continue;
            }
            if (conjuncts.size() != 1) {
                descs.add((OWLClassExpression)this.factory.getOWLObjectIntersectionOf(conjuncts));
                continue;
            }
            descs.add(conjuncts.iterator().next());
        }
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectUnionOf desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        Set<Set<OWLClassExpression>> disjunctions = this.computeReplacements(desc.getOperands());
        for (Set<OWLClassExpression> disjuncts : disjunctions) {
            Iterator<OWLClassExpression> it = disjuncts.iterator();
            while (it.hasNext()) {
                if (!this.isNothing(it.next())) continue;
                it.remove();
            }
            if (disjuncts.size() != 1) {
                descs.add((OWLClassExpression)this.factory.getOWLObjectUnionOf(disjuncts));
                continue;
            }
            descs.add(disjuncts.iterator().next());
        }
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectSomeValuesFrom desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        descs.add((OWLClassExpression)desc);
        for (OWLClassExpression filler : (Set)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this)) {
            if (this.isNothing(filler)) continue;
            descs.add((OWLClassExpression)this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler));
        }
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectAllValuesFrom desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLClassExpression filler : (Set)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this)) {
            if (this.isThing(filler)) continue;
            descs.add((OWLClassExpression)this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), filler));
        }
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectHasValue desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        descs.add((OWLClassExpression)desc);
        descs.add((OWLClassExpression)this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), (OWLClassExpression)this.factory.getOWLThing()));
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectExactCardinality desc) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        OWLObjectMinCardinality min = this.getDataFactory().getOWLObjectMinCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), (OWLClassExpression)desc.getFiller());
        result.addAll((Collection)min.accept((OWLClassExpressionVisitorEx)this));
        OWLObjectMaxCardinality max = this.getDataFactory().getOWLObjectMaxCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), (OWLClassExpression)desc.getFiller());
        result.addAll((Collection)max.accept((OWLClassExpressionVisitorEx)this));
        result.add((OWLClassExpression)this.getLimit());
        return result;
    }

    public Set<OWLClassExpression> visit(OWLObjectHasSelf desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        descs.add((OWLClassExpression)desc);
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectOneOf desc) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        if (desc.getIndividuals().size() == 1) {
            ops.add((OWLClassExpression)desc);
            ops.add((OWLClassExpression)this.getLimit());
            return ops;
        }
        for (OWLIndividual ind : desc.getIndividuals()) {
            ops.add((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{ind}));
        }
        OWLObjectUnionOf rewrite = this.factory.getOWLObjectUnionOf(ops);
        return (Set)rewrite.accept((OWLClassExpressionVisitorEx)this);
    }

    protected abstract OWLClass getLimit();

    protected abstract OWLDataRange getDataLimit();

    public Set<OWLClassExpression> visit(OWLDataSomeValuesFrom desc) {
        return Collections.singleton(desc);
    }

    public Set<OWLClassExpression> visit(OWLDataAllValuesFrom desc) {
        return Collections.singleton(desc);
    }

    public Set<OWLClassExpression> visit(OWLDataHasValue desc) {
        return Collections.singleton(desc);
    }

    public Set<OWLClassExpression> visit(OWLDataMinCardinality desc) {
        return Collections.singleton(desc);
    }

    public Set<OWLClassExpression> visit(OWLDataExactCardinality desc) {
        return Collections.singleton(desc);
    }

    public Set<OWLClassExpression> visit(OWLDataMaxCardinality desc) {
        return Collections.singleton(desc);
    }
}

