/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.checker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

public class SatisfiabilityEntailmentChecker
implements EntailmentChecker<OWLAxiom> {
    private OWLOntologyManager man;
    private OWLAxiom axiom;
    private OWLClassExpression unsatDesc;
    private Set<OWLEntity> freshEntities;
    private OWLReasonerFactory reasonerFactory;
    private Set<OWLAxiom> seedSignature;
    private boolean useModularisation;
    private final Set<OWLAxiom> lastAxioms;
    private final Set<OWLAxiom> lastEntailingAxioms;
    private int counter = 0;
    private ModuleType moduleType = ModuleType.STAR;
    private long timeOutMS = Long.MAX_VALUE;

    public SatisfiabilityEntailmentChecker(OWLReasonerFactory reasonerFactory, OWLAxiom entailment) {
        this(reasonerFactory, entailment, true, Long.MAX_VALUE);
    }

    public SatisfiabilityEntailmentChecker(OWLReasonerFactory reasonerFactory, OWLAxiom entailment, boolean useModularisation, long timeOutMS) {
        this.reasonerFactory = reasonerFactory;
        this.axiom = entailment;
        this.useModularisation = useModularisation;
        this.timeOutMS = timeOutMS;
        this.seedSignature = new HashSet<OWLAxiom>();
        this.lastAxioms = new HashSet<OWLAxiom>();
        this.lastEntailingAxioms = new HashSet<OWLAxiom>();
        this.freshEntities = new HashSet<OWLEntity>();
        this.man = OWLManager.createOWLOntologyManager();
        if (entailment instanceof OWLSubClassOfAxiom && ((OWLSubClassOfAxiom)entailment).getSuperClass().isOWLNothing()) {
            this.unsatDesc = ((OWLSubClassOfAxiom)entailment).getSubClass();
        } else {
            SatisfiabilityConverter con = new SatisfiabilityConverter();
            this.unsatDesc = (OWLClassExpression)entailment.accept((OWLAxiomVisitorEx)con);
        }
    }

    @Override
    public String getModularisationTypeDescription() {
        return this.moduleType.toString();
    }

    @Override
    public boolean isUseModularisation() {
        return this.useModularisation;
    }

    @Override
    public OWLAxiom getEntailment() {
        return this.axiom;
    }

    @Override
    public Set<OWLEntity> getEntailmentSignature() {
        return this.axiom.getSignature();
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void resetCounter() {
        this.counter = 0;
    }

    @Override
    public Set<OWLEntity> getSeedSignature() {
        if (this.axiom instanceof OWLSubClassOfAxiom) {
            return ((OWLSubClassOfAxiom)this.axiom).getSubClass().getSignature();
        }
        return this.axiom.getSignature();
    }

    @Override
    public Set<OWLAxiom> getModule(Set<OWLAxiom> axioms) {
        if (this.useModularisation) {
            if (axioms.isEmpty()) {
                return Collections.emptySet();
            }
            Set<OWLAxiom> inputAxioms = null;
            inputAxioms = axioms;
            OWLOntologyManager man2 = OWLManager.createOWLOntologyManager();
            this.moduleType = ModuleType.STAR;
            SyntacticLocalityModuleExtractor extractor = new SyntacticLocalityModuleExtractor(man2, null, inputAxioms, this.moduleType);
            Set module = extractor.extract(this.getEntailmentSignature());
            return module;
        }
        return axioms;
    }

    private boolean containsNominals(OWLAxiom axiom) {
        for (OWLClassExpression ce : axiom.getNestedClassExpressions()) {
            if (!(ce instanceof OWLObjectOneOf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEntailed(Set<OWLAxiom> axioms) {
        TelemetryTimer totalTimer = new TelemetryTimer();
        TelemetryTimer moduleTimer = new TelemetryTimer();
        TelemetryTimer entailmentCheckTimer = new TelemetryTimer();
        DefaultTelemetryInfo info = new DefaultTelemetryInfo("entailmentcheck", false, new TelemetryTimer[]{totalTimer, moduleTimer, entailmentCheckTimer});
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        transmitter.beginTransmission((TelemetryInfo)info);
        boolean entailed = true;
        OWLOntology ont = null;
        try {
            transmitter.recordMeasurement((TelemetryInfo)info, "input size", (Number)axioms.size());
            totalTimer.start();
            this.lastEntailingAxioms.clear();
            this.lastAxioms.clear();
            this.lastAxioms.addAll(axioms);
            if (axioms.contains(this.axiom)) {
                this.lastEntailingAxioms.add(this.axiom);
                boolean bl = true;
                return bl;
            }
            ont = this.man.createOntology(axioms);
            for (OWLEntity ent : this.unsatDesc.getSignature()) {
                if (ent.isBuiltIn() || ont.containsEntityInSignature(ent)) continue;
                this.man.addAxiom(ont, (OWLAxiom)this.man.getOWLDataFactory().getOWLDeclarationAxiom(ent));
            }
            String clsName = "Entailment" + System.currentTimeMillis();
            OWLClass namingCls = this.man.getOWLDataFactory().getOWLClass(IRI.create((String)clsName));
            OWLSubClassOfAxiom namingAxiom = this.man.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)namingCls, this.unsatDesc);
            this.man.addAxiom(ont, (OWLAxiom)namingAxiom);
            for (OWLEntity freshEntity : this.freshEntities) {
                this.man.addAxiom(ont, (OWLAxiom)this.man.getOWLDataFactory().getOWLDeclarationAxiom(freshEntity));
            }
            ++this.counter;
            entailmentCheckTimer.start();
            OWLReasoner reasoner = this.reasonerFactory.createReasoner(ont, (OWLReasonerConfiguration)new SimpleConfiguration((ReasonerProgressMonitor)new NullReasonerProgressMonitor(), FreshEntityPolicy.ALLOW, this.timeOutMS, IndividualNodeSetPolicy.BY_SAME_AS));
            entailed = !reasoner.isSatisfiable(this.unsatDesc);
            entailmentCheckTimer.stop();
            reasoner.dispose();
            this.man.removeOntology(ont);
            if (entailed) {
                this.lastEntailingAxioms.remove(namingAxiom);
                this.lastEntailingAxioms.addAll(ont.getLogicalAxioms());
            }
            boolean bl = entailed;
            return bl;
        }
        catch (OWLOntologyCreationException e) {
            throw new ExplanationException(e);
        }
        catch (TimeOutException e) {
            transmitter.recordMeasurement((TelemetryInfo)info, "reasoner time out", true);
            throw e;
        }
        catch (ExplanationGeneratorInterruptedException e) {
            transmitter.recordMeasurement((TelemetryInfo)info, "interrupted", true);
            throw e;
        }
        catch (RuntimeException e) {
            try {
                if (ont != null) {
                    ont.getOWLOntologyManager().saveOntology(ont, (OutputStream)new FileOutputStream(new File("/tmp/lasterror.owl")));
                }
            }
            catch (OWLOntologyStorageException e1) {
                e1.printStackTrace();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            transmitter.recordException((TelemetryInfo)info, (Throwable)e);
            throw e;
        }
        finally {
            totalTimer.stop();
            transmitter.recordTiming((TelemetryInfo)info, "satisfiability check time", entailmentCheckTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "entailed", entailed);
            transmitter.recordTiming((TelemetryInfo)info, "time", totalTimer);
            transmitter.endTransmission((TelemetryInfo)info);
        }
    }

    @Override
    public Set<OWLAxiom> getEntailingAxioms(Set<OWLAxiom> axioms) {
        if (!axioms.equals(this.lastAxioms)) {
            this.isEntailed(axioms);
        }
        return this.lastEntailingAxioms;
    }

    public static class UnsupportedAxiomTypeException
    extends RuntimeException {
        private AxiomType type;

        public UnsupportedAxiomTypeException(OWLAxiom ax) {
            super("Unsupported type of axiom: " + ax.getAxiomType().getName());
            this.type = ax.getAxiomType();
        }

        public AxiomType getType() {
            return this.type;
        }
    }

    private class SatisfiabilityConverter
    implements OWLAxiomVisitorEx<OWLClassExpression> {
        private OWLDataFactory df;

        private SatisfiabilityConverter() {
            this.df = SatisfiabilityEntailmentChecker.this.man.getOWLDataFactory();
        }

        public OWLClassExpression visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLClassAssertionAxiom axiom) {
            OWLObjectOneOf nominal = this.df.getOWLObjectOneOf(new OWLIndividual[]{axiom.getIndividual()});
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{nominal, this.df.getOWLObjectComplementOf(axiom.getClassExpression())});
        }

        public OWLClassExpression visit(OWLDataPropertyAssertionAxiom axiom) {
            OWLObjectOneOf nom = this.df.getOWLObjectOneOf(new OWLIndividual[]{axiom.getSubject()});
            OWLDataHasValue hasVal = this.df.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{nom, this.df.getOWLObjectComplementOf((OWLClassExpression)hasVal)});
        }

        public OWLClassExpression visit(OWLDataPropertyDomainAxiom axiom) {
            OWLDataSomeValuesFrom exists = this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)this.df.getTopDatatype());
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{exists, this.df.getOWLObjectComplementOf(axiom.getDomain())});
        }

        public OWLClassExpression visit(OWLDataPropertyRangeAxiom axiom) {
            OWLDataAllValuesFrom forall = this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)axiom.getRange());
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.df.getOWLThing(), this.df.getOWLObjectComplementOf((OWLClassExpression)forall)});
        }

        public OWLClassExpression visit(OWLSubDataPropertyOfAxiom axiom) {
            OWLLiteral c = this.df.getOWLLiteral("x");
            OWLDataHasValue subHasValue = this.df.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getSubProperty(), c);
            OWLDataHasValue supHasValue = this.df.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getSuperProperty(), c);
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{subHasValue, this.df.getOWLObjectComplementOf((OWLClassExpression)supHasValue)});
        }

        public OWLClassExpression visit(OWLDeclarationAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLDifferentIndividualsAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLDisjointClassesAxiom axiom) {
            return this.df.getOWLObjectIntersectionOf(axiom.getClassExpressions());
        }

        public OWLClassExpression visit(OWLDisjointDataPropertiesAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLDisjointObjectPropertiesAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLDisjointUnionAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLAnnotationAssertionAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLEquivalentClassesAxiom axiom) {
            if (axiom.getClassExpressions().size() != 2) {
                throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
            }
            OWLClassExpression[] descs = axiom.getClassExpressions().toArray(new OWLClassExpression[2]);
            OWLClassExpression d1 = descs[0];
            OWLClassExpression d2 = descs[1];
            if (d1.isOWLNothing()) {
                return d2;
            }
            if (d2.isOWLNothing()) {
                return d1;
            }
            if (d1.isOWLThing()) {
                return this.df.getOWLObjectComplementOf(d2);
            }
            if (d2.isOWLThing()) {
                return this.df.getOWLObjectComplementOf(d1);
            }
            return this.df.getOWLObjectUnionOf(new OWLClassExpression[]{this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{d1, this.df.getOWLObjectComplementOf(d2)}), this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.df.getOWLObjectComplementOf(d1), d2})});
        }

        public OWLClassExpression visit(OWLEquivalentDataPropertiesAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLFunctionalDataPropertyAxiom axiom) {
            return (OWLClassExpression)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public OWLClassExpression visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return (OWLClassExpression)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public OWLClassExpression visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return (OWLClassExpression)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public OWLClassExpression visit(OWLInverseObjectPropertiesAxiom axiom) {
            OWLClass clsA = this.df.getOWLClass(IRI.create((String)"owlapi:explanation:clsA"));
            SatisfiabilityEntailmentChecker.this.freshEntities.add(clsA);
            OWLClass clsB = this.df.getOWLClass(IRI.create((String)"owlapi:explanation:clsB"));
            SatisfiabilityEntailmentChecker.this.freshEntities.add(clsB);
            OWLObjectSomeValuesFrom subHasValueA = this.df.getOWLObjectSomeValuesFrom(axiom.getFirstProperty(), (OWLClassExpression)clsA);
            OWLObjectSomeValuesFrom supHasValueA = this.df.getOWLObjectSomeValuesFrom(axiom.getSecondProperty().getInverseProperty(), (OWLClassExpression)clsA);
            OWLObjectSomeValuesFrom subHasValueB = this.df.getOWLObjectSomeValuesFrom(axiom.getSecondProperty(), (OWLClassExpression)clsB);
            OWLObjectSomeValuesFrom supHasValueB = this.df.getOWLObjectSomeValuesFrom(axiom.getFirstProperty().getInverseProperty(), (OWLClassExpression)clsB);
            OWLObjectIntersectionOf ceA = this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{subHasValueA, this.df.getOWLObjectComplementOf((OWLClassExpression)supHasValueA)});
            OWLObjectIntersectionOf ceB = this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{subHasValueB, this.df.getOWLObjectComplementOf((OWLClassExpression)supHasValueB)});
            return this.df.getOWLObjectUnionOf(new OWLClassExpression[]{ceA, ceB});
        }

        public OWLClassExpression visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return (OWLClassExpression)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public OWLClassExpression visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return (OWLClassExpression)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public OWLClassExpression visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return (OWLClassExpression)axiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public OWLClassExpression visit(OWLHasKeyAxiom owlHasKeyAxiom) {
            throw new UnsupportedAxiomTypeException(SatisfiabilityEntailmentChecker.this.axiom);
        }

        public OWLClassExpression visit(OWLDatatypeDefinitionAxiom owlDatatypeDefinition) {
            throw new UnsupportedAxiomTypeException(SatisfiabilityEntailmentChecker.this.axiom);
        }

        public OWLClassExpression visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
            throw new UnsupportedAxiomTypeException(SatisfiabilityEntailmentChecker.this.axiom);
        }

        public OWLClassExpression visit(OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
            throw new UnsupportedAxiomTypeException(SatisfiabilityEntailmentChecker.this.axiom);
        }

        public OWLClassExpression visit(OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
            throw new UnsupportedAxiomTypeException(SatisfiabilityEntailmentChecker.this.axiom);
        }

        public OWLClassExpression visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLObjectOneOf nom = this.df.getOWLObjectOneOf(new OWLIndividual[]{axiom.getSubject()});
            OWLObjectHasValue hasVal = this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{nom, this.df.getOWLObjectComplementOf((OWLClassExpression)hasVal)});
        }

        public OWLClassExpression visit(OWLSubPropertyChainOfAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLObjectPropertyDomainAxiom axiom) {
            OWLObjectSomeValuesFrom exists = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.df.getOWLThing());
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{exists, this.df.getOWLObjectComplementOf(axiom.getDomain())});
        }

        public OWLClassExpression visit(OWLObjectPropertyRangeAxiom axiom) {
            OWLObjectAllValuesFrom forall = this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange());
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.df.getOWLThing(), this.df.getOWLObjectComplementOf((OWLClassExpression)forall)});
        }

        public OWLClassExpression visit(OWLSubObjectPropertyOfAxiom axiom) {
            OWLClass clsA = this.df.getOWLClass(IRI.create((String)"owlapi:explanation:clsA"));
            SatisfiabilityEntailmentChecker.this.freshEntities.add(clsA);
            OWLObjectSomeValuesFrom subHasValue = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getSubProperty(), (OWLClassExpression)clsA);
            OWLObjectSomeValuesFrom supHasValue = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getSuperProperty(), (OWLClassExpression)clsA);
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{subHasValue, this.df.getOWLObjectComplementOf((OWLClassExpression)supHasValue)});
        }

        public OWLClassExpression visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)axiom.getProperty()).getObjectComplementOf();
        }

        public OWLClassExpression visit(OWLSameIndividualAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLSubClassOfAxiom axiom) {
            return SatisfiabilityEntailmentChecker.this.man.getOWLDataFactory().getOWLObjectIntersectionOf(new OWLClassExpression[]{axiom.getSubClass(), SatisfiabilityEntailmentChecker.this.man.getOWLDataFactory().getOWLObjectComplementOf(axiom.getSuperClass())});
        }

        public OWLClassExpression visit(OWLSymmetricObjectPropertyAxiom axiom) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)axiom);
        }

        public OWLClassExpression visit(OWLTransitiveObjectPropertyAxiom axiom) {
            OWLClass clsA = this.df.getOWLClass(IRI.create((String)"owlapi:explanation:clsA"));
            SatisfiabilityEntailmentChecker.this.freshEntities.add(clsA);
            OWLObjectSomeValuesFrom subHasValue = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)clsA));
            OWLObjectSomeValuesFrom supHasValue = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)clsA);
            return this.df.getOWLObjectIntersectionOf(new OWLClassExpression[]{subHasValue, this.df.getOWLObjectComplementOf((OWLClassExpression)supHasValue)});
        }

        public OWLClassExpression visit(SWRLRule rule) {
            throw new UnsupportedAxiomTypeException((OWLAxiom)rule);
        }
    }

    private class AxiomsSplitter
    implements OWLAxiomVisitor {
        private Set<OWLAxiom> aboxAxioms;
        private Set<OWLAxiom> tboxAxioms;

        private AxiomsSplitter(int size) {
            this.aboxAxioms = new HashSet<OWLAxiom>(size);
            this.tboxAxioms = new HashSet<OWLAxiom>(size);
        }

        public Set<OWLAxiom> getAboxAxioms() {
            return this.aboxAxioms;
        }

        public Set<OWLAxiom> getTboxAxioms() {
            return this.tboxAxioms;
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.aboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.aboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            this.aboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.aboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            this.aboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLHasKeyAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.tboxAxioms.add((OWLAxiom)axiom);
        }

        public void visit(SWRLRule rule) {
            this.tboxAxioms.add(SatisfiabilityEntailmentChecker.this.axiom);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }
    }
}

