/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.ExpansionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.InitialEntailmentCheckStrategy;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class StructuralTypePriorityExpansionStrategy
implements ExpansionStrategy {
    private int count = 0;
    private InitialEntailmentCheckStrategy initialEntailmentCheckStrategy = InitialEntailmentCheckStrategy.PERFORM;

    public StructuralTypePriorityExpansionStrategy() {
    }

    public StructuralTypePriorityExpansionStrategy(InitialEntailmentCheckStrategy initialEntailmentCheckStrategy) {
        this.initialEntailmentCheckStrategy = initialEntailmentCheckStrategy;
    }

    @Override
    public Set<OWLAxiom> doExpansion(Set<OWLAxiom> axioms, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        HashSet<OWLAxiom> expansion;
        try {
            HashSet<OWLAxiom> result;
            this.count = 0;
            if (progressMonitor.isCancelled()) {
                throw new ExplanationGeneratorInterruptedException();
            }
            ++this.count;
            if (this.initialEntailmentCheckStrategy.equals((Object)InitialEntailmentCheckStrategy.PERFORM) && !checker.isEntailed(axioms)) {
                return Collections.emptySet();
            }
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.createOntology(axioms);
            expansion = new HashSet<OWLAxiom>();
            Set<OWLEntity> entailmentSignature = checker.getEntailmentSignature();
            EntityFilteredDefinitionExpander expander = new EntityFilteredDefinitionExpander(ont);
            HashSet<OWLEntity> expandedWithDefinition = new HashSet<OWLEntity>();
            HashSet<OWLDeclarationAxiom> addedAxioms = new HashSet<OWLDeclarationAxiom>();
            for (OWLEntity ent : entailmentSignature) {
                OWLDeclarationAxiom declAx = man.getOWLDataFactory().getOWLDeclarationAxiom(ent);
                expansion.add((OWLAxiom)declAx);
                addedAxioms.add(declAx);
            }
            for (OWLEntity ent : entailmentSignature) {
                expandedWithDefinition.add(ent);
                Set owlAxioms = (Set)ent.accept((OWLEntityVisitorEx)expander);
                expansion.addAll(owlAxioms);
            }
            int size = 0;
            HashSet<OWLDisjointClassesAxiom> disjointClassesAxioms = new HashSet<OWLDisjointClassesAxiom>();
            HashSet expansionSig = new HashSet();
            while (size != expansion.size()) {
                if (progressMonitor.isCancelled()) {
                    return Collections.emptySet();
                }
                size = expansion.size();
                HashSet<OWLAxiom> combined = new HashSet<OWLAxiom>(disjointClassesAxioms.size() + expansion.size() + 50);
                combined.addAll(expansion);
                block5: for (OWLDisjointClassesAxiom disjointAx : disjointClassesAxioms) {
                    for (OWLClassExpression desc : disjointAx.getClassExpressions()) {
                        if (desc.isAnonymous()) {
                            combined.add((OWLAxiom)disjointAx);
                            continue block5;
                        }
                        if (!expansionSig.contains(desc.asOWLClass())) continue block5;
                        combined.add((OWLAxiom)disjointAx);
                    }
                }
                ++this.count;
                if (checker.isEntailed(combined)) {
                    HashSet<OWLAxiom> result2 = new HashSet<OWLAxiom>(checker.getEntailingAxioms(combined));
                    result2.removeAll(addedAxioms);
                    return result2;
                }
                for (OWLAxiom ax : new ArrayList<OWLAxiom>(expansion)) {
                    for (OWLEntity ent : ax.getSignature()) {
                        if (expandedWithDefinition.contains(ent)) continue;
                        Set owlAxioms = (Set)ent.accept((OWLEntityVisitorEx)expander);
                        for (OWLAxiom expAx : owlAxioms) {
                            if (!expAx.getAxiomType().equals(AxiomType.DISJOINT_CLASSES) && !expAx.isOfType(new AxiomType[]{AxiomType.CLASS_ASSERTION, AxiomType.OBJECT_PROPERTY_ASSERTION, AxiomType.DATA_PROPERTY_ASSERTION, AxiomType.SAME_INDIVIDUAL, AxiomType.DIFFERENT_INDIVIDUALS})) {
                                expansion.add(expAx);
                                expansionSig.addAll(expAx.getSignature());
                                continue;
                            }
                            if (!(expAx instanceof OWLDisjointClassesAxiom)) continue;
                            disjointClassesAxioms.add((OWLDisjointClassesAxiom)expAx);
                        }
                        expandedWithDefinition.add(ent);
                    }
                }
            }
            for (OWLEntity ent : expansionSig) {
                if (!ent.isOWLClass()) continue;
                expansion.addAll(ont.getDisjointClassesAxioms(ent.asOWLClass()));
            }
            ++this.count;
            if (checker.isEntailed(expansion)) {
                result = new HashSet<OWLAxiom>(checker.getEntailingAxioms(expansion));
                result.removeAll(addedAxioms);
                return result;
            }
            while (!expansion.containsAll(ont.getLogicalAxioms())) {
                if (progressMonitor.isCancelled()) {
                    return Collections.emptySet();
                }
                for (OWLAxiom ax : new ArrayList<OWLAxiom>(expansion)) {
                    for (OWLEntity ent : ax.getSignature()) {
                        Set owlAxioms = ont.getReferencingAxioms(ent);
                        expansion.addAll(owlAxioms);
                    }
                }
                ++this.count;
                if (!checker.isEntailed(expansion)) continue;
                result = new HashSet<OWLAxiom>(checker.getEntailingAxioms(expansion));
                result.removeAll(addedAxioms);
                return result;
            }
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
        return expansion;
    }

    @Override
    public int getNumberOfSteps() {
        return this.count;
    }

    private class EntityFilteredDefinitionExpander
    implements OWLEntityVisitorEx<Set<? extends OWLAxiom>> {
        private OWLOntology theOnt;

        private EntityFilteredDefinitionExpander(OWLOntology theOnt) {
            this.theOnt = theOnt;
        }

        public Set<? extends OWLAxiom> visit(OWLClass cls) {
            HashSet axioms = new HashSet(this.theOnt.getAxioms(cls));
            return axioms;
        }

        public Set<? extends OWLAxiom> visit(OWLAnnotationProperty owlAnnotationProperty) {
            return Collections.emptySet();
        }

        public Set<? extends OWLAxiom> visit(OWLObjectProperty property) {
            return this.theOnt.getAxioms((OWLObjectPropertyExpression)property);
        }

        public Set<? extends OWLAxiom> visit(OWLDataProperty property) {
            return this.theOnt.getAxioms(property);
        }

        public Set<? extends OWLAxiom> visit(OWLNamedIndividual individual) {
            HashSet<OWLObjectPropertyAssertionAxiom> axioms = new HashSet<OWLObjectPropertyAssertionAxiom>(this.theOnt.getAxioms((OWLIndividual)individual));
            for (OWLObjectPropertyAssertionAxiom ax : this.theOnt.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                if (!((OWLIndividual)ax.getObject()).equals(individual)) continue;
                axioms.add(ax);
            }
            return axioms;
        }

        public Set<? extends OWLAxiom> visit(OWLDatatype dataType) {
            return Collections.emptySet();
        }
    }
}

