/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owlapi.model.OWLAxiom;

public class OrderedAxiomWithWindowContractionStrategy
implements ContractionStrategy {
    private Object lastEntailment;
    private int cumulativeExpansionSize;
    private int cumulativeJustificationSize;
    private double justificationToExpansionRatio;
    private Set<OWLAxiom> lastJustification = new HashSet<OWLAxiom>();
    private int count = 0;

    @Override
    public Set<OWLAxiom> doPruning(Set<OWLAxiom> axioms, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        this.count = 0;
        int windowSize = 10;
        ArrayList<OWLAxiom> orderedAxioms = new ArrayList<OWLAxiom>(axioms);
        if (this.lastEntailment != null) {
            if (checker.getEntailment().equals(this.lastEntailment)) {
                if (!this.lastJustification.isEmpty()) {
                    // empty if block
                }
            } else {
                this.lastJustification.clear();
            }
        }
        int windowCount = orderedAxioms.size() / windowSize;
        HashSet<OWLAxiom> contraction = new HashSet<OWLAxiom>(axioms);
        for (int windowIndex = 0; windowIndex < windowCount; ++windowIndex) {
            int start = windowIndex * windowSize;
            int end = start + windowSize;
            List cur = orderedAxioms.subList(start, end);
            contraction.removeAll(cur);
            ++this.count;
            if (checker.isEntailed(contraction)) continue;
            contraction.addAll(cur);
        }
        HashSet<OWLAxiom> contractionCopy = new HashSet<OWLAxiom>(contraction);
        for (OWLAxiom ax : contractionCopy) {
            contraction.remove(ax);
            ++this.count;
            if (checker.isEntailed(contraction)) continue;
            contraction.add(ax);
        }
        this.lastEntailment = checker.getEntailment();
        this.cumulativeJustificationSize += contraction.size();
        this.cumulativeExpansionSize += axioms.size();
        this.justificationToExpansionRatio = 1.0 * (double)this.cumulativeJustificationSize / (1.0 * (double)this.cumulativeExpansionSize);
        this.lastJustification.clear();
        return contraction;
    }

    @Override
    public int getNumberOfSteps() {
        return this.count;
    }
}

