/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.api.ExplanationTelemetryWrapper;
import org.semanticweb.owl.explanation.api.NullExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.blackbox.ExpansionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.hst.BreadthFirstStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.hst.ExplanationGeneratorMediator;
import org.semanticweb.owl.explanation.impl.blackbox.hst.HittingSetTree;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.TimeOutException;

public class BlackBoxExplanationGenerator2<E>
implements ExplanationGenerator<E>,
ExplanationGeneratorMediator<E> {
    private ExpansionStrategy expansionStrategy;
    private ContractionStrategy contractionStrategy;
    private EntailmentCheckerFactory<E> checkerFactory;
    private Set<OWLAxiom> workingAxioms;
    private Set<OWLAxiom> module;
    private ExplanationProgressMonitor<E> progressMonitor;
    private Set<Explanation<E>> cache = new HashSet<Explanation<E>>();
    private TelemetryTimer generatorTimer = new TelemetryTimer();
    private int cacheHitCounter = 0;

    public BlackBoxExplanationGenerator2(Set<? extends OWLAxiom> axioms, EntailmentCheckerFactory<E> checkerFactory, ExpansionStrategy expansionStrategy, ContractionStrategy contractionStrategy, ExplanationProgressMonitor<E> progressMonitor) {
        this.workingAxioms = new HashSet<OWLAxiom>(axioms);
        this.checkerFactory = checkerFactory;
        this.expansionStrategy = expansionStrategy;
        this.contractionStrategy = contractionStrategy;
        this.progressMonitor = progressMonitor != null ? progressMonitor : new NullExplanationProgressMonitor();
    }

    @Override
    public Set<Explanation<E>> getExplanations(E entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Explanation<E>> getExplanations(E entailment, int limit) throws ExplanationException {
        DefaultTelemetryInfo justificationsInfo = new DefaultTelemetryInfo("justifications", new TelemetryTimer[0]);
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        try {
            this.cache.clear();
            transmitter.beginTransmission((TelemetryInfo)justificationsInfo);
            transmitter.recordMeasurement((TelemetryInfo)justificationsInfo, "entailment", entailment.toString());
            transmitter.recordMeasurement((TelemetryInfo)justificationsInfo, "input size", (Number)this.workingAxioms.size());
            EntailmentChecker<E> checker = this.checkerFactory.createEntailementChecker(entailment);
            this.extractModule(checker);
            this.generatorTimer.reset();
            this.generatorTimer.start();
            BreadthFirstStrategy strategy = new BreadthFirstStrategy();
            HittingSetTree<E> hittingSetTree = new HittingSetTree<E>(strategy, this.progressMonitor);
            hittingSetTree.buildHittingSetTree(entailment, limit, this);
            Set set = hittingSetTree.getExplanations();
            return set;
        }
        finally {
            transmitter.endTransmission((TelemetryInfo)justificationsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractModule(EntailmentChecker<E> checker) {
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        TelemetryTimer modularisationTimer = new TelemetryTimer();
        DefaultTelemetryInfo moduleInfo = new DefaultTelemetryInfo("module", new TelemetryTimer[]{modularisationTimer});
        try {
            transmitter.beginTransmission((TelemetryInfo)moduleInfo);
            modularisationTimer.start();
            this.module = this.extractModule(this.workingAxioms, checker);
            modularisationTimer.stop();
        }
        finally {
            transmitter.recordMeasurement((TelemetryInfo)moduleInfo, "module type", checker.getModularisationTypeDescription());
            transmitter.recordMeasurement((TelemetryInfo)moduleInfo, "input size", (Number)this.workingAxioms.size());
            if (this.module != null) {
                transmitter.recordMeasurement((TelemetryInfo)moduleInfo, "module size", (Number)this.module.size());
            }
            transmitter.recordTiming((TelemetryInfo)moduleInfo, "module extraction time", modularisationTimer);
            transmitter.endTransmission((TelemetryInfo)moduleInfo);
        }
    }

    public Set<OWLAxiom> getWorkingAxioms() {
        return this.workingAxioms;
    }

    protected Explanation<E> computeExplanation(E entailment) {
        TelemetryTimer justificationTimer = new TelemetryTimer();
        DefaultTelemetryInfo findOneInfo = new DefaultTelemetryInfo("findone", new TelemetryTimer[]{justificationTimer});
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        transmitter.beginTransmission((TelemetryInfo)findOneInfo);
        Explanation<E> result = Explanation.getEmptyExplanation(entailment);
        boolean entailed = false;
        try {
            justificationTimer.start();
            if (entailment instanceof OWLAxiom && this.workingAxioms.contains((OWLAxiom)entailment)) {
                entailed = true;
                result = new Explanation<E>(entailment, Collections.singleton((OWLAxiom)entailment));
            } else {
                if (this.progressMonitor.isCancelled()) {
                    throw new ExplanationGeneratorInterruptedException();
                }
                EntailmentChecker<E> checker = this.checkerFactory.createEntailementChecker(entailment);
                Set<OWLAxiom> expandedAxioms = this.doExpansion(checker);
                if (!expandedAxioms.isEmpty()) {
                    Set<OWLAxiom> justificationAxioms = this.doContraction(checker, expandedAxioms);
                    result = new Explanation<E>(entailment, justificationAxioms);
                }
            }
            justificationTimer.stop();
        }
        catch (TimeOutException e) {
            transmitter.recordMeasurement((TelemetryInfo)findOneInfo, "reasoner time out", true);
            throw e;
        }
        catch (ExplanationGeneratorInterruptedException e) {
            transmitter.recordMeasurement((TelemetryInfo)findOneInfo, "interrupted", true);
            throw e;
        }
        catch (RuntimeException e) {
            transmitter.recordException((TelemetryInfo)findOneInfo, (Throwable)e);
            throw e;
        }
        finally {
            transmitter.recordMeasurement((TelemetryInfo)findOneInfo, "input size", (Number)this.module.size());
            transmitter.recordMeasurement((TelemetryInfo)findOneInfo, "entailed", entailed);
            transmitter.recordMeasurement((TelemetryInfo)findOneInfo, "self justification", result.isJustificationEntailment());
            transmitter.recordMeasurement((TelemetryInfo)findOneInfo, "justification size", (Number)result.getSize());
            transmitter.recordTiming((TelemetryInfo)findOneInfo, "time", justificationTimer);
            this.recordJustification(entailment, (TelemetryInfo)findOneInfo, result);
            transmitter.endTransmission((TelemetryInfo)findOneInfo);
        }
        return result;
    }

    private void recordJustification(E entailment, TelemetryInfo findOneInfo, Explanation<E> result) {
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        if (!result.isEmpty() && entailment instanceof OWLAxiom) {
            ExplanationTelemetryWrapper telemetryObject = new ExplanationTelemetryWrapper(result);
            transmitter.recordObject(findOneInfo, "justification", ".owl.xml", (Object)telemetryObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OWLAxiom> doContraction(EntailmentChecker<E> checker, Set<OWLAxiom> expandedAxioms) {
        Set<OWLAxiom> justificationAxioms;
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        TelemetryTimer contractionTimer = new TelemetryTimer();
        DefaultTelemetryInfo contractionInfo = new DefaultTelemetryInfo("contraction", new TelemetryTimer[]{contractionTimer});
        try {
            contractionTimer.start();
            transmitter.beginTransmission((TelemetryInfo)contractionInfo);
            justificationAxioms = this.contractionStrategy.doPruning(expandedAxioms, checker, this.progressMonitor);
            contractionTimer.stop();
            transmitter.recordMeasurement((TelemetryInfo)contractionInfo, "contraction strategy", this.contractionStrategy.getClass().getName());
            transmitter.recordMeasurement((TelemetryInfo)contractionInfo, "contraction size", (Number)justificationAxioms.size());
            transmitter.recordTiming((TelemetryInfo)contractionInfo, "contraction time", contractionTimer);
            transmitter.recordMeasurement((TelemetryInfo)contractionInfo, "contraction entailment check count", (Number)this.contractionStrategy.getNumberOfSteps());
        }
        finally {
            transmitter.endTransmission((TelemetryInfo)contractionInfo);
        }
        return justificationAxioms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OWLAxiom> doExpansion(EntailmentChecker<E> checker) {
        Set<OWLAxiom> expandedAxioms;
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        TelemetryTimer expansionTimer = new TelemetryTimer();
        DefaultTelemetryInfo expansionInfo = new DefaultTelemetryInfo("expansion", new TelemetryTimer[]{expansionTimer});
        try {
            transmitter.beginTransmission((TelemetryInfo)expansionInfo);
            expansionTimer.start();
            expandedAxioms = this.expansionStrategy.doExpansion(this.module, checker, this.progressMonitor);
            expansionTimer.stop();
            transmitter.recordMeasurement((TelemetryInfo)expansionInfo, "expansion strategy", this.expansionStrategy.getClass().getName());
            transmitter.recordMeasurement((TelemetryInfo)expansionInfo, "expansion size", (Number)expandedAxioms.size());
            transmitter.recordTiming((TelemetryInfo)expansionInfo, "expansion time", expansionTimer);
            transmitter.recordMeasurement((TelemetryInfo)expansionInfo, "expansion entailment check count", (Number)this.expansionStrategy.getNumberOfSteps());
        }
        finally {
            transmitter.endTransmission((TelemetryInfo)expansionInfo);
        }
        return expandedAxioms;
    }

    protected Set<OWLAxiom> extractModule(Set<OWLAxiom> axioms, EntailmentChecker<E> checker) {
        return checker.getModule(axioms);
    }

    @Override
    public Explanation<E> generateExplanation(E entailment) {
        for (Explanation<E> expl : this.cache) {
            if (!expl.getEntailment().equals(entailment) || !this.module.containsAll(expl.getAxioms())) continue;
            ++this.cacheHitCounter;
            return expl;
        }
        Explanation<E> expl = this.computeExplanation(entailment);
        if (!expl.isEmpty()) {
            this.cache.add(expl);
        }
        return expl;
    }

    @Override
    public void removeAxiom(OWLAxiom axiom) {
        this.module.remove(axiom);
        this.workingAxioms.remove(axiom);
    }

    @Override
    public void addAxiom(OWLAxiom axiom) {
        this.module.add(axiom);
        this.workingAxioms.add(axiom);
    }
}

