/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapitools.profiles.OWLProfileViolationVisitor;
import org.semanticweb.owlapitools.profiles.OWLProfileViolationVisitorEx;

public abstract class OWLProfileViolation<T> {
    protected final OWLOntology ontology;
    protected final OWLDataFactory df;
    protected final OWLAxiom axiom;
    protected final T expression;

    public OWLProfileViolation(OWLOntology ontology, OWLAxiom axiom, T o) {
        this.axiom = axiom;
        this.ontology = ontology;
        this.df = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.expression = o;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontology.getOntologyID();
    }

    public final OWLOntology getOntology() {
        return this.ontology;
    }

    public T getExpression() {
        return this.expression;
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    public List<OWLOntologyChange> repair() {
        return this.list(new OWLOntologyChange[]{new RemoveAxiom(this.ontology, this.axiom)});
    }

    protected AddAxiom addDeclaration(OWLEntity e) {
        return new AddAxiom(this.ontology, (OWLAxiom)this.df.getOWLDeclarationAxiom(e));
    }

    public abstract void accept(OWLProfileViolationVisitor var1);

    public abstract <O> O accept(OWLProfileViolationVisitorEx<O> var1);

    protected String toString(String template) {
        return String.format(template + " [%s in %s]", this.axiom, this.ontology.getOntologyID());
    }

    protected String toString(String template, Object object) {
        return String.format(template + " [%s in %s]", object, this.axiom, this.ontology.getOntologyID());
    }

    protected String toString(String template, Object object1, Object object2) {
        return String.format(template + " [%s in %s]", object1, object2, this.axiom, this.ontology.getOntologyID());
    }

    protected List<OWLOntologyChange> list(OWLOntologyChange ... changes) {
        return Arrays.asList(changes);
    }
}

