/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;

public class OWLProfileReport {
    private final OWLProfile profile;
    private final List<OWLProfileViolation<?>> violations;

    public OWLProfileReport(OWLProfile profile, Set<OWLProfileViolation<?>> violations) {
        this.profile = profile;
        this.violations = new ArrayList(violations);
    }

    public OWLProfile getProfile() {
        return this.profile;
    }

    public boolean isInProfile() {
        return this.violations.isEmpty();
    }

    public List<OWLProfileViolation<?>> getViolations() {
        return this.violations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.profile.getName());
        sb.append(" Profile Report: ");
        if (this.isInProfile()) {
            sb.append("[Ontology and imports closure in profile]\n");
        } else {
            sb.append("Ontology and imports closure NOT in profile. The following violations are present:\n");
        }
        for (OWLProfileViolation<?> na : this.violations) {
            sb.append(na);
            sb.append("\n");
        }
        return sb.toString();
    }
}

